/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.c;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.en;

public final class ParticipantEntity
extends en
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new a();
    private final int iM;
    private final String nd;
    private final String ml;
    private final Uri mq;
    private final Uri mr;
    private final int nU;
    private final String nV;
    private final boolean nW;
    private final PlayerEntity nX;
    private final int nY;

    public ParticipantEntity(Participant participant) {
        this.iM = 1;
        this.nd = participant.getParticipantId();
        this.ml = participant.getDisplayName();
        this.mq = participant.getIconImageUri();
        this.mr = participant.getHiResImageUri();
        this.nU = participant.getStatus();
        this.nV = participant.ci();
        this.nW = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.nX = player == null ? null : new PlayerEntity(player);
        this.nY = participant.getCapabilities();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities) {
        this.iM = versionCode;
        this.nd = participantId;
        this.ml = displayName;
        this.mq = iconImageUri;
        this.mr = hiResImageUri;
        this.nU = status;
        this.nV = clientAddress;
        this.nW = connectedToRoom;
        this.nX = player;
        this.nY = capabilities;
    }

    public int getVersionCode() {
        return this.iM;
    }

    public int getStatus() {
        return this.nU;
    }

    public String ci() {
        return this.nV;
    }

    public boolean isConnectedToRoom() {
        return this.nW;
    }

    public String getDisplayName() {
        if (this.nX == null) {
            return this.ml;
        }
        return this.nX.getDisplayName();
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.nX == null) {
            eg.b(this.ml, dataOut);
            return;
        }
        this.nX.getDisplayName(dataOut);
    }

    public Uri getIconImageUri() {
        if (this.nX == null) {
            return this.mq;
        }
        return this.nX.getIconImageUri();
    }

    public Uri getHiResImageUri() {
        if (this.nX == null) {
            return this.mr;
        }
        return this.nX.getHiResImageUri();
    }

    public String getParticipantId() {
        return this.nd;
    }

    public Player getPlayer() {
        return this.nX;
    }

    public int getCapabilities() {
        return this.nY;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return dl.hashCode(participant.getPlayer(), participant.getStatus(), participant.ci(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return dl.equal(participant2.getPlayer(), participant.getPlayer()) && dl.equal(participant2.getStatus(), participant.getStatus()) && dl.equal(participant2.ci(), participant.ci()) && dl.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && dl.equal(participant2.getDisplayName(), participant.getDisplayName()) && dl.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && dl.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && dl.equal(participant2.getCapabilities(), participant.getCapabilities());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return dl.d(participant).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.ci()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("HiResImage", participant.getHiResImageUri()).a("Capabilities", participant.getCapabilities()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.aX()) {
            c.a(this, dest, flags);
        } else {
            dest.writeString(this.nd);
            dest.writeString(this.ml);
            dest.writeString(this.mq == null ? null : this.mq.toString());
            dest.writeString(this.mr == null ? null : this.mr.toString());
            dest.writeInt(this.nU);
            dest.writeString(this.nV);
            dest.writeInt(this.nW ? 1 : 0);
            dest.writeInt(this.nX == null ? 0 : 1);
            if (this.nX != null) {
                this.nX.writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends c {
        a() {
        }

        public ParticipantEntity w(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.aW());
            if (bl2 || ParticipantEntity.y(ParticipantEntity.class.getCanonicalName())) {
                return super.w(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(1, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, n3);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.w(x0);
        }
    }
}

