/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSPropertiesPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CVSProjectPropertiesPage
extends CVSPropertiesPage {
    IProject project;
    ICVSRepositoryLocation oldLocation;
    ICVSRepositoryLocation newLocation = null;
    private static final int TABLE_HEIGHT_HINT = 150;
    private static final int TABLE_WIDTH_HINT = 300;
    Label methodLabel;
    Label userLabel;
    Label hostLabel;
    Label pathLabel;
    Label moduleLabel;
    Label portLabel;
    Label tagLabel;
    private Button fetchButton;
    private Button watchEditButton;
    IUserInfo info;
    CVSTeamProvider provider;
    private boolean fetch;
    private boolean watchEdit;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;

    public static boolean isCompatible(ICVSRepositoryLocation location, ICVSRepositoryLocation oldLocation) {
        if (!location.getHost().equals(oldLocation.getHost())) {
            return false;
        }
        if (!location.getRootDirectory().equals(oldLocation.getRootDirectory())) {
            return false;
        }
        return !location.equals(oldLocation);
    }

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = this.createLabel(composite, Policy.bind("CVSProjectPropertiesPage.connectionType"), 1);
        this.methodLabel = this.createLabel(composite, "", 1);
        label = this.createLabel(composite, Policy.bind("CVSProjectPropertiesPage.user"), 1);
        this.userLabel = this.createLabel(composite, "", 1);
        label = this.createLabel(composite, Policy.bind("CVSPropertiesPage.host"), 1);
        this.hostLabel = this.createLabel(composite, "", 1);
        label = this.createLabel(composite, Policy.bind("CVSPropertiesPage.port"), 1);
        this.portLabel = this.createLabel(composite, "", 1);
        label = this.createLabel(composite, Policy.bind("CVSPropertiesPage.path"), 1);
        this.pathLabel = this.createLabel(composite, "", 1);
        label = this.createLabel(composite, Policy.bind("CVSPropertiesPage.module"), 1);
        this.moduleLabel = this.createLabel(composite, "", 1);
        label = this.createLabel(composite, Policy.bind("CVSPropertiesPage.tag"), 1);
        this.tagLabel = this.createLabel(composite, "", 1);
        this.createLabel(composite, "", 1);
        this.fetchButton = this.createCheckBox(composite, Policy.bind("CVSProjectPropertiesPage.fetchAbsentDirectoriesOnUpdate"));
        this.fetchButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CVSProjectPropertiesPage.this.fetch = CVSProjectPropertiesPage.this.fetchButton.getSelection();
            }
        });
        this.watchEditButton = this.createCheckBox(composite, Policy.bind("CVSProjectPropertiesPage.configureForWatchEdit"));
        this.watchEditButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CVSProjectPropertiesPage.this.watchEdit = CVSProjectPropertiesPage.this.watchEditButton.getSelection();
            }
        });
        this.createLabel(composite, "", 1);
        this.createLabel(composite, "", 1);
        this.createLabel(composite, "", 1);
        this.createLabel(composite, "", 1);
        label = new Label(composite, 64);
        label.setText(Policy.bind("CVSProjectPropertiesPage.You_can_change_the_sharing_of_this_project_to_another_repository_location._However,_this_is_only_possible_if_the_new_location_is___compatible___(on_the_same_host_with_the_same_repository_path)._1"));
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Button changeButton = new Button(composite, 8);
        changeButton.setText(Policy.bind("CVSProjectPropertiesPage.Change_Sharing_5"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, changeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        changeButton.setLayoutData((Object)data);
        changeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RepositorySelectionDialog dialog = new RepositorySelectionDialog(CVSProjectPropertiesPage.this.getShell(), CVSProjectPropertiesPage.this.oldLocation);
                dialog.open();
                ICVSRepositoryLocation location = dialog.getLocation();
                if (location == null) {
                    return;
                }
                CVSProjectPropertiesPage.this.newLocation = location;
                CVSProjectPropertiesPage.this.initializeValues(CVSProjectPropertiesPage.this.newLocation);
            }
        });
        this.initializeValues(this.oldLocation);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.team.cvs.ui.project_property_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    private void initialize() {
        this.project = null;
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            this.project = (IProject)element;
        } else {
            Object adapter = element.getAdapter(class$org$eclipse$core$resources$IProject == null ? (class$org$eclipse$core$resources$IProject = CVSProjectPropertiesPage.class$("org.eclipse.core.resources.IProject")) : class$org$eclipse$core$resources$IProject);
            if (adapter instanceof IProject) {
                this.project = (IProject)adapter;
            }
        }
        this.provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.project, (String)CVSProviderPlugin.getTypeId());
        if (this.provider == null) {
            return;
        }
        CVSWorkspaceRoot cvsRoot = this.provider.getCVSWorkspaceRoot();
        try {
            this.oldLocation = cvsRoot.getRemoteLocation();
            this.fetch = this.provider.getFetchAbsentDirectories();
            this.watchEdit = this.provider.isWatchEditEnabled();
        }
        catch (TeamException e) {
            this.handle(e);
        }
    }

    private void initializeValues(ICVSRepositoryLocation location) {
        if (this.provider == null) {
            return;
        }
        CVSWorkspaceRoot cvsRoot = this.provider.getCVSWorkspaceRoot();
        ICVSFolder folder = cvsRoot.getLocalRoot();
        try {
            if (!folder.isCVSFolder()) {
                return;
            }
            this.methodLabel.setText(location.getMethod().getName());
            this.info = location.getUserInfo(true);
            this.userLabel.setText(this.info.getUsername());
            this.hostLabel.setText(location.getHost());
            int port = location.getPort();
            if (port == 0) {
                this.portLabel.setText(Policy.bind("CVSPropertiesPage.defaultPort"));
            } else {
                this.portLabel.setText("" + port);
            }
            this.pathLabel.setText(location.getRootDirectory());
            FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
            if (syncInfo == null) {
                return;
            }
            String label = syncInfo.getRepository();
            if (label.equals("CVSROOT/Emptydir")) {
                label = Policy.bind("CVSPropertiesPage.virtualModule", label);
            }
            this.moduleLabel.setText(label);
            this.fetchButton.setSelection(this.fetch);
            this.watchEditButton.setSelection(this.watchEdit);
        }
        catch (TeamException e) {
            this.handle(e);
        }
        this.initializeTag();
    }

    private void initializeTag() {
        this.provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.project, (String)CVSProviderPlugin.getTypeId());
        if (this.provider == null) {
            return;
        }
        try {
            ICVSFolder local = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.project);
            CVSEntryLineTag tag = local.getFolderSyncInfo().getTag();
            this.tagLabel.setText(CVSProjectPropertiesPage.getTagLabel((CVSTag)tag));
        }
        catch (TeamException e) {
            this.handle(e);
        }
    }

    public boolean performOk() {
        final boolean[] changeReadOnly = new boolean[]{false};
        try {
            if (this.fetch != this.provider.getFetchAbsentDirectories()) {
                this.provider.setFetchAbsentDirectories(this.fetch);
            }
            if (this.watchEdit != this.provider.isWatchEditEnabled()) {
                this.provider.setWatchEditEnabled(this.watchEdit);
                changeReadOnly[0] = true;
            }
        }
        catch (CVSException e) {
            this.handle(e);
        }
        if (this.newLocation == null && !changeReadOnly[0]) {
            return true;
        }
        try {
            if (this.newLocation != null && !CVSProjectPropertiesPage.isCompatible(this.newLocation, this.oldLocation) && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("CVSProjectPropertiesPage.32"), (String)Policy.bind("CVSProjectPropertiesPage.33"))) {
                return false;
            }
            new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Policy.bind("CVSProjectPropertiesPage.progressTaskName"), (CVSProjectPropertiesPage.this.newLocation == null ? 0 : 100) + (changeReadOnly[0] ? 100 : 0));
                        if (CVSProjectPropertiesPage.this.newLocation != null) {
                            CVSProjectPropertiesPage.this.provider.setRemoteRoot(CVSProjectPropertiesPage.this.newLocation, Policy.subMonitorFor(monitor, 100));
                        }
                        if (changeReadOnly[0]) {
                            CVSProjectPropertiesPage.this.setReadOnly(CVSProjectPropertiesPage.this.watchEdit, Policy.infiniteSubMonitorFor(monitor, 100));
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            this.newLocation = null;
            if (changeReadOnly[0]) {
                CVSUIPlugin.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED", null, null));
            }
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    protected void setReadOnly(final boolean watchEdit, final IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 512);
        String taskName = watchEdit ? Policy.bind("CVSProjectPropertiesPage.setReadOnly") : Policy.bind("CVSProjectPropertiesPage.clearReadOnly");
        monitor.subTask(taskName);
        ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.project);
        root.accept(new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                if (file.isManaged() && !file.isModified(null)) {
                    file.setReadOnly(watchEdit);
                }
                monitor.worked(1);
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
                folder.acceptChildren((ICVSResourceVisitor)this);
            }
        });
        monitor.done();
    }

    protected void handle(Throwable t) {
        CVSUIPlugin.openError(this.getShell(), null, null, t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RepositorySelectionDialog
    extends Dialog {
        ICVSRepositoryLocation[] allLocations;
        ICVSRepositoryLocation[] compatibleLocatons;
        ICVSRepositoryLocation selectedLocation;
        TableViewer viewer;
        Button okButton;
        boolean showCompatible = true;

        public RepositorySelectionDialog(Shell shell, ICVSRepositoryLocation oldLocation) {
            super(shell);
            this.initialize(oldLocation);
        }

        private void initialize(ICVSRepositoryLocation oldLocation) {
            this.allLocations = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations();
            ArrayList<ICVSRepositoryLocation> locations = new ArrayList<ICVSRepositoryLocation>();
            for (int i = 0; i < this.allLocations.length; ++i) {
                ICVSRepositoryLocation location = this.allLocations[i];
                if (!CVSProjectPropertiesPage.isCompatible(location, oldLocation)) continue;
                locations.add(location);
            }
            this.compatibleLocatons = locations.toArray(new ICVSRepositoryLocation[locations.size()]);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.okButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected Control createDialogArea(Composite parent) {
            parent.getShell().setText(Policy.bind("CVSProjectPropertiesPage.Select_a_Repository_1"));
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            CVSProjectPropertiesPage.this.createLabel(composite, Policy.bind("CVSProjectPropertiesPage.Select_a_CVS_repository_location_to_share_the_project_with__2"), 1);
            Table table = new Table(composite, 2820);
            GridData data = new GridData();
            data.widthHint = 300;
            data.heightHint = 150;
            table.setLayoutData((Object)data);
            this.viewer = new TableViewer(table);
            this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(this){
                private final /* synthetic */ RepositorySelectionDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public Object[] getElements(Object inputElement) {
                    if (this.this$1.showCompatible) {
                        return this.this$1.compatibleLocatons;
                    }
                    return this.this$1.allLocations;
                }
            });
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                private final /* synthetic */ RepositorySelectionDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (selection.isEmpty()) {
                        this.this$1.selectedLocation = null;
                        this.this$1.okButton.setEnabled(false);
                    } else {
                        this.this$1.selectedLocation = (ICVSRepositoryLocation)selection.getFirstElement();
                        this.this$1.okButton.setEnabled(true);
                    }
                }
            });
            this.viewer.addDoubleClickListener(new IDoubleClickListener(this){
                private final /* synthetic */ RepositorySelectionDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void doubleClick(DoubleClickEvent event) {
                    RepositorySelectionDialog.access$000(this.this$1);
                }
            });
            this.viewer.setInput((Object)this.compatibleLocatons);
            Button compatibleButton = CVSProjectPropertiesPage.this.createCheckBox(composite, Policy.bind("CVSProjectPropertiesPage.31"));
            compatibleButton.setSelection(this.showCompatible);
            compatibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, compatibleButton){
                private final /* synthetic */ Button val$compatibleButton;
                private final /* synthetic */ RepositorySelectionDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$compatibleButton = val$compatibleButton;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.showCompatible = this.val$compatibleButton.getSelection();
                    this.this$1.viewer.refresh();
                }
            });
            return composite;
        }

        protected void cancelPressed() {
            this.selectedLocation = null;
            super.cancelPressed();
        }

        public ICVSRepositoryLocation getLocation() {
            return this.selectedLocation;
        }

        static /* synthetic */ void access$000(RepositorySelectionDialog x0) {
            x0.okPressed();
        }
    }
}

