/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.IModelChangeProviderExtension;
import org.eclipse.pde.internal.core.IModelChangedListenerFilter;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.ui.forms.IFormPart;

public class PluginInputContextManager
extends InputContextManager {
    private BundlePluginModelBase bmodel;

    public PluginInputContextManager(PDEFormEditor editor) {
        super(editor);
    }

    public IBaseModel getAggregateModel() {
        if (this.bmodel != null) {
            return this.bmodel;
        }
        return this.findPluginModel();
    }

    public IModel getPluginModel() {
        if (this.bmodel != null) {
            return this.bmodel.getExtensionsModel();
        }
        return this.findPluginModel();
    }

    protected void fireContextChange(InputContext context, boolean added) {
        super.fireContextChange(context, added);
        if (context.getId().equals("bundle-context")) {
            if (added) {
                this.bundleAdded(context);
            } else {
                this.bundleRemoved(context);
            }
        } else if (context.getId().equals("build-context")) {
            if (added) {
                this.buildAdded(context);
            } else {
                this.buildRemoved(context);
            }
        } else if (context.getId().equals("plugin-context")) {
            if (added) {
                this.pluginAdded(context);
            } else {
                this.pluginRemoved(context);
            }
        }
    }

    private void bundleAdded(InputContext bundleContext) {
        IBundleModel model = (IBundleModel)bundleContext.getModel();
        this.bmodel = model.isFragmentModel() ? new BundleFragmentModel() : new BundlePluginModel();
        this.bmodel.setBundleModel(model);
        this.syncExtensions();
    }

    private void syncExtensions() {
        IModel emodel = this.findPluginModel();
        if (emodel != null && emodel instanceof ISharedExtensionsModel) {
            this.bmodel.setExtensionsModel((ISharedExtensionsModel)emodel);
            this.transferListeners(emodel, (IModel)this.bmodel);
        } else {
            this.bmodel.setExtensionsModel(null);
        }
    }

    private IModel findPluginModel() {
        InputContext pcontext = this.findContext("plugin-context");
        if (pcontext != null) {
            return (IModel)pcontext.getModel();
        }
        return null;
    }

    private void bundleRemoved(InputContext bundleContext) {
        if (this.bmodel != null) {
            BundlePluginModelBase preserved = this.bmodel;
            this.bmodel = null;
            IModel emodel = this.findPluginModel();
            if (emodel != null) {
                this.transferListeners((IModel)preserved, emodel);
            }
        }
    }

    private void transferListeners(IModel source, IModel target) {
        if (source instanceof IModelChangeProviderExtension && target instanceof IModelChangeProviderExtension) {
            IModelChangeProviderExtension smodel = (IModelChangeProviderExtension)source;
            IModelChangeProviderExtension tmodel = (IModelChangeProviderExtension)target;
            smodel.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)smodel, 99, null, null));
            smodel.transferListenersTo(tmodel, new IModelChangedListenerFilter(){

                public boolean accept(IModelChangedListener listener) {
                    return listener instanceof IFormPart || listener instanceof FormOutlinePage;
                }
            });
        }
    }

    private void pluginAdded(InputContext pluginContext) {
        if (this.bmodel != null) {
            this.syncExtensions();
        }
    }

    private void pluginRemoved(InputContext pluginContext) {
        if (this.bmodel != null) {
            this.syncExtensions();
        }
    }

    private void buildAdded(InputContext buildContext) {
    }

    private void buildRemoved(InputContext buildContext) {
    }
}

