/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class RefreshAction
extends SelectionDispatchAction {
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public RefreshAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("RefreshAction.label"));
        this.setToolTipText(ActionMessages.getString("RefreshAction.toolTip"));
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "refresh_nav.gif");
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.refresh_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return true;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)element).getAdapter(class$org$eclipse$core$resources$IResource == null ? RefreshAction.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
                if (resource == null) {
                    return false;
                }
                if (resource.getType() != 4 || ((IProject)resource).isOpen()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void run(IStructuredSelection selection) {
        final IResource[] resources = this.getResources(selection);
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(ActionMessages.getString("RefreshAction.progressMessage"), resources.length * 2);
                monitor.subTask("");
                ArrayList<IJavaElement> javaElements = new ArrayList<IJavaElement>(5);
                for (int r = 0; r < resources.length; ++r) {
                    IResource resource = resources[r];
                    if (resource.getType() == 4) {
                        RefreshAction.this.checkLocationDeleted((IProject)resource);
                    } else if (resource.getType() == 8) {
                        IProject[] projects = ((IWorkspaceRoot)resource).getProjects();
                        for (int p = 0; p < projects.length; ++p) {
                            RefreshAction.this.checkLocationDeleted(projects[p]);
                        }
                    }
                    resource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    IJavaElement jElement = JavaCore.create((IResource)resource);
                    if (jElement == null || !jElement.exists()) continue;
                    javaElements.add(jElement);
                }
                IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                model.refreshExternalArchives(javaElements.toArray(new IJavaElement[javaElements.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, resources.length));
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.getString("RefreshAction.error.title"), ActionMessages.getString("RefreshAction.error.message"));
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private IResource[] getResources(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        ArrayList<IResource> result = new ArrayList<IResource>(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IResource resource;
            Object element = iter.next();
            if (!(element instanceof IAdaptable) || (resource = (IResource)((IAdaptable)element).getAdapter(class$org$eclipse$core$resources$IResource == null ? RefreshAction.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource)) == null) continue;
            result.add(resource);
        }
        iter = result.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (!this.isDescendent(result, resource)) continue;
            iter.remove();
        }
        return result.toArray(new IResource[result.size()]);
    }

    private boolean isDescendent(List candidates, IResource element) {
        for (IContainer parent = element.getParent(); parent != null; parent = parent.getParent()) {
            if (!candidates.contains(parent)) continue;
            return true;
        }
        return false;
    }

    private void checkLocationDeleted(IProject project) throws CoreException {
        if (!project.exists()) {
            return;
        }
        File location = project.getLocation().toFile();
        if (!location.exists()) {
            final String message = ActionMessages.getFormattedString("RefreshAction.locationDeleted.message", new Object[]{project.getName(), location.getAbsolutePath()});
            final boolean[] result = new boolean[1];
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    result[0] = MessageDialog.openQuestion((Shell)RefreshAction.this.getShell(), (String)ActionMessages.getString("RefreshAction.locationDeleted.title"), (String)message);
                }
            });
            if (result[0]) {
                project.delete(true, true, null);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

