/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.custom.StyleRange;

public class MultilineDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    protected IDocument fDocument;
    protected ITokenScanner fScanner;
    protected TextAttribute fDefaultTextAttribute;

    public MultilineDamagerRepairer(ITokenScanner scanner, TextAttribute defaultTextAttribute) {
        this.fScanner = scanner;
        this.fDefaultTextAttribute = defaultTextAttribute;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    protected int endOfLineOf(int offset) throws BadLocationException {
        IRegion info = this.fDocument.getLineInformationOfOffset(offset);
        if (offset <= info.getOffset() + info.getLength()) {
            return info.getOffset() + info.getLength();
        }
        int line = this.fDocument.getLineOfOffset(offset);
        try {
            info = this.fDocument.getLineInformation(line + 1);
            return info.getOffset() + info.getLength();
        }
        catch (BadLocationException x) {
            return this.fDocument.getLength();
        }
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        return partition;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        IToken token;
        if (this.fScanner == null) {
            this.addRange(presentation, region.getOffset(), region.getLength(), this.fDefaultTextAttribute);
            return;
        }
        int lastStart = region.getOffset();
        int length = 0;
        IToken lastToken = Token.UNDEFINED;
        TextAttribute lastAttribute = this.getTokenTextAttribute(lastToken);
        this.fScanner.setRange(this.fDocument, lastStart, region.getLength());
        while (!(token = this.fScanner.nextToken()).isEOF()) {
            TextAttribute attribute = this.getTokenTextAttribute(token);
            if (lastAttribute != null && lastAttribute.equals((Object)attribute)) {
                length += this.fScanner.getTokenLength();
                continue;
            }
            this.addRange(presentation, lastStart, length, lastAttribute);
            lastToken = token;
            lastAttribute = attribute;
            lastStart = this.fScanner.getTokenOffset();
            length = this.fScanner.getTokenLength();
        }
        this.addRange(presentation, lastStart, length, lastAttribute);
    }

    protected TextAttribute getTokenTextAttribute(IToken token) {
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            return (TextAttribute)data;
        }
        return this.fDefaultTextAttribute;
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            presentation.addStyleRange(new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), attr.getStyle()));
        }
    }

    public void setDefaultTextAttribute(TextAttribute defaultTextAttribute) {
        this.fDefaultTextAttribute = defaultTextAttribute;
    }
}

