/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.search;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.jdt.internal.core.search.JavaWorkspaceScope;
import org.eclipse.jdt.internal.core.search.PathCollector;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.util.Util;

public class SearchEngine {
    private Parser parser;
    private CompilerOptions compilerOptions;
    private ICompilationUnit[] workingCopies;
    private WorkingCopyOwner workingCopyOwner;
    public static boolean VERBOSE = false;

    public SearchEngine() {
    }

    public SearchEngine(ICompilationUnit[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    public SearchEngine(IWorkingCopy[] workingCopies) {
        int length = workingCopies.length;
        this.workingCopies = new ICompilationUnit[length];
        System.arraycopy(workingCopies, 0, this.workingCopies, 0, length);
    }

    public SearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner;
    }

    public static IJavaSearchScope createHierarchyScope(IType type) throws JavaModelException {
        return SearchEngine.createHierarchyScope(type, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IJavaSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws JavaModelException {
        return new HierarchyScope(type, owner);
    }

    public static IJavaSearchScope createJavaSearchScope(IResource[] resources) {
        int length = resources.length;
        IJavaElement[] elements = new IJavaElement[length];
        for (int i = 0; i < length; ++i) {
            elements[i] = JavaCore.create(resources[i]);
        }
        return SearchEngine.createJavaSearchScope(elements);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements) {
        return SearchEngine.createJavaSearchScope(elements, true);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements, boolean includeReferencedProjects) {
        int includeMask = 7;
        if (includeReferencedProjects) {
            includeMask |= 8;
        }
        return SearchEngine.createJavaSearchScope(elements, includeMask);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements, int includeMask) {
        JavaSearchScope scope = new JavaSearchScope();
        HashSet visitedProjects = new HashSet(2);
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            IJavaElement element = elements[i];
            if (element == null) continue;
            try {
                if (element instanceof JavaProject) {
                    scope.add((JavaProject)element, includeMask, visitedProjects);
                    continue;
                }
                scope.add(element);
                continue;
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
        return scope;
    }

    public static ISearchPattern createOrSearchPattern(ISearchPattern leftPattern, ISearchPattern rightPattern) {
        SearchPattern left = ((SearchPatternAdapter)leftPattern).pattern;
        SearchPattern right = ((SearchPatternAdapter)rightPattern).pattern;
        SearchPattern pattern = SearchPattern.createOrPattern(left, right);
        return new SearchPatternAdapter(pattern);
    }

    public static ISearchPattern createSearchPattern(String stringPattern, int searchFor, int limitTo, boolean isCaseSensitive) {
        int matchMode = stringPattern.indexOf(42) != -1 || stringPattern.indexOf(63) != -1 ? 2 : 0;
        int matchRule = isCaseSensitive ? matchMode | 8 : matchMode;
        return new SearchPatternAdapter(SearchPattern.createPattern(stringPattern, searchFor, limitTo, matchRule));
    }

    public static ISearchPattern createSearchPattern(IJavaElement element, int limitTo) {
        return new SearchPatternAdapter(SearchPattern.createPattern(element, limitTo));
    }

    public static IJavaSearchScope createWorkspaceScope() {
        return new JavaWorkspaceScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findMatches(SearchPattern pattern, SearchParticipant[] participants, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (monitor != null) {
            monitor.beginTask(Util.bind("engine.searching"), 100);
        }
        if (VERBOSE) {
            System.out.println("Searching for " + this + " in " + scope);
        }
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        try {
            int l;
            requestor.beginReporting();
            int n = l = participants == null ? 0 : participants.length;
            for (int i = 0; i < l; ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SearchParticipant participant = participants[i];
                try {
                    participant.beginSearching();
                    requestor.enterParticipant(participant);
                    PathCollector pathCollector = new PathCollector();
                    indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, pathCollector), 3, monitor);
                    if (monitor != null && monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    String[] indexMatchPaths = pathCollector.getPaths();
                    pathCollector = null;
                    int indexMatchLength = indexMatchPaths == null ? 0 : indexMatchPaths.length;
                    SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                    for (int j = 0; j < indexMatchLength; ++j) {
                        indexMatches[j] = participant.getDocument(indexMatchPaths[j]);
                    }
                    SearchDocument[] matches = MatchLocator.addWorkingCopies(pattern, indexMatches, this.getWorkingCopies(), participant);
                    participant.locateMatches(matches, pattern, scope, requestor, monitor);
                    continue;
                }
                finally {
                    requestor.exitParticipant(participant);
                    participant.doneSearching();
                }
            }
            Object var17_17 = null;
            requestor.endReporting();
            if (monitor == null) return;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            requestor.endReporting();
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new JavaSearchParticipant();
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.compilerOptions = new CompilerOptions(JavaCore.getOptions());
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory());
            this.parser = new Parser(problemReporter, true);
        }
        return this.parser;
    }

    private IResource getResource(IJavaElement element) {
        ICompilationUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getCompilationUnit()) != null) {
            return cu.getResource();
        }
        return element.getResource();
    }

    private ICompilationUnit[] getWorkingCopies() {
        int length;
        ICompilationUnit[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    ICompilationUnit unit;
                    int i;
                    HashMap<IPath, ICompilationUnit> pathToCUs = new HashMap<IPath, ICompilationUnit>();
                    int length2 = copies.length;
                    for (i = 0; i < length2; ++i) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                    }
                    length2 = this.workingCopies.length;
                    for (i = 0; i < length2; ++i) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                    }
                    length = pathToCUs.size();
                    copies = new ICompilationUnit[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? JavaModelManager.getJavaModelManager().getWorkingCopies(this.workingCopyOwner, true) : JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        ICompilationUnit[] result = null;
        length = copies.length;
        int index = 0;
        for (int i = 0; i < length; ++i) {
            CompilationUnit copy = (CompilationUnit)copies[i];
            try {
                if (copy.isPrimary() && !copy.hasUnsavedChanges() && !copy.hasResourceChanged()) continue;
                if (result == null) {
                    result = new ICompilationUnit[length];
                }
                result[index++] = copy;
                continue;
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
        if (index != length && result != null) {
            ICompilationUnit[] iCompilationUnitArray = result;
            result = new ICompilationUnit[index];
            System.arraycopy(iCompilationUnitArray, 0, result, 0, index);
        }
        return result;
    }

    private ICompilationUnit[] getWorkingCopies(IJavaElement element) {
        ICompilationUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getCompilationUnit()) != null && cu.isWorkingCopy()) {
            int length;
            ICompilationUnit[] copies = this.getWorkingCopies();
            int n = length = copies == null ? 0 : copies.length;
            if (length > 0) {
                ICompilationUnit[] newWorkingCopies = new ICompilationUnit[length + 1];
                System.arraycopy(copies, 0, newWorkingCopies, 0, length);
                newWorkingCopies[length] = cu;
                return newWorkingCopies;
            }
            return new ICompilationUnit[]{cu};
        }
        return this.getWorkingCopies();
    }

    boolean match(char classOrInterface, char[] patternPkg, char[] patternTypeName, int matchRule, boolean isClass, char[] pkg, char[] typeName) {
        boolean isCaseSensitive;
        switch (classOrInterface) {
            case 'C': {
                if (!isClass) {
                    return false;
                }
            }
            case 'I': {
                if (!isClass) break;
                return false;
            }
        }
        boolean bl = isCaseSensitive = (matchRule & 8) != 0;
        if (patternPkg != null && !CharOperation.equals(patternPkg, pkg, isCaseSensitive)) {
            return false;
        }
        if (patternTypeName != null) {
            int matchMode = matchRule - (isCaseSensitive ? 8 : 0);
            switch (matchMode) {
                case 0: {
                    return CharOperation.equals(patternTypeName, typeName, isCaseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(patternTypeName, typeName, isCaseSensitive);
                }
                case 2: {
                    return CharOperation.match(patternTypeName, typeName, isCaseSensitive);
                }
            }
        }
        return true;
    }

    public void search(IWorkspace workspace, String patternString, int searchFor, int limitTo, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        try {
            int matchMode = patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1 ? 2 : 0;
            this.search(SearchPattern.createPattern(patternString, searchFor, limitTo, matchMode | 8), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new ResultCollectorAdapter(resultCollector), resultCollector.getProgressMonitor());
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    public void search(IWorkspace workspace, IJavaElement element, int limitTo, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        this.search(workspace, SearchEngine.createSearchPattern(element, limitTo), scope, resultCollector);
    }

    public void search(IWorkspace workspace, ISearchPattern searchPattern, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        try {
            this.search(((SearchPatternAdapter)searchPattern).pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new ResultCollectorAdapter(resultCollector), resultCollector.getProgressMonitor());
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        this.findMatches(pattern, participants, scope, requestor, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchAllTypeNames(char[] packageName, char[] typeName, int matchRule, int searchFor, IJavaSearchScope scope, final ITypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaModelException {
        block17: {
            char classOrInterface;
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            switch (searchFor) {
                case 5: {
                    classOrInterface = 'C';
                    break;
                }
                case 6: {
                    classOrInterface = 'I';
                    break;
                }
                default: {
                    classOrInterface = '\u0000';
                }
            }
            TypeDeclarationPattern pattern = new TypeDeclarationPattern(packageName, null, typeName, classOrInterface, matchRule);
            final HashSet<String> workingCopyPaths = new HashSet<String>();
            ICompilationUnit[] copies = this.getWorkingCopies();
            if (copies != null) {
                int length = copies.length;
                for (int i = 0; i < length; ++i) {
                    ICompilationUnit workingCopy = copies[i];
                    workingCopyPaths.add(workingCopy.getPath().toString());
                }
            }
            IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

                public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant) {
                    TypeDeclarationPattern record = (TypeDeclarationPattern)indexRecord;
                    if (record.enclosingTypeNames != IIndexConstants.ONE_ZERO_CHAR && !workingCopyPaths.contains(documentPath)) {
                        boolean isClass;
                        boolean bl = isClass = record.classOrInterface != 'I';
                        if (isClass) {
                            nameRequestor.acceptClass(record.pkg, record.simpleName, record.enclosingTypeNames, documentPath);
                        } else {
                            nameRequestor.acceptInterface(record.pkg, record.simpleName, record.enclosingTypeNames, documentPath);
                        }
                    }
                    return true;
                }
            };
            try {
                if (progressMonitor != null) {
                    progressMonitor.beginTask(Util.bind("engine.searching"), 100);
                }
                indexManager.performConcurrentJob(new PatternSearchJob(pattern, SearchEngine.getDefaultSearchParticipant(), scope, searchRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 100)));
                if (copies == null) break block17;
                int length = copies.length;
                for (int i = 0; i < length; ++i) {
                    CompilationResult compilationUnitResult;
                    char[] contents;
                    org.eclipse.jdt.internal.compiler.env.ICompilationUnit unit;
                    ICompilationUnit workingCopy = copies[i];
                    String path = workingCopy.getPath().toString();
                    if (workingCopy.isConsistent()) {
                        IPackageDeclaration[] packageDeclarations = workingCopy.getPackageDeclarations();
                        char[] packageDeclaration = packageDeclarations.length == 0 ? CharOperation.NO_CHAR : packageDeclarations[0].getElementName().toCharArray();
                        IType[] allTypes = workingCopy.getAllTypes();
                        int allTypesLength = allTypes.length;
                        for (int j = 0; j < allTypesLength; ++j) {
                            char[][] enclosingTypeNames;
                            IType type = allTypes[j];
                            IJavaElement parent = type.getParent();
                            if (parent instanceof IType) {
                                char[] parentQualifiedName = ((IType)parent).getTypeQualifiedName('.').toCharArray();
                                enclosingTypeNames = CharOperation.splitOn('.', parentQualifiedName);
                            } else {
                                enclosingTypeNames = CharOperation.NO_CHAR_CHAR;
                            }
                            char[] simpleName = type.getElementName().toCharArray();
                            if (!this.match(classOrInterface, packageName, typeName, matchRule, type.isClass(), packageDeclaration, simpleName)) continue;
                            if (type.isClass()) {
                                nameRequestor.acceptClass(packageDeclaration, simpleName, enclosingTypeNames, path);
                                continue;
                            }
                            nameRequestor.acceptInterface(packageDeclaration, simpleName, enclosingTypeNames, path);
                        }
                        continue;
                    }
                    Parser basicParser = this.getParser();
                    CompilationUnitDeclaration parsedUnit = basicParser.dietParse(unit = new org.eclipse.jdt.internal.compiler.env.ICompilationUnit(contents = workingCopy.getBuffer().getCharacters()){
                        private final /* synthetic */ char[] val$contents;
                        {
                            this.val$contents = val$contents;
                        }

                        public char[] getContents() {
                            return this.val$contents;
                        }

                        public char[] getMainTypeName() {
                            return null;
                        }

                        public char[][] getPackageName() {
                            return null;
                        }

                        public char[] getFileName() {
                            return null;
                        }
                    }, compilationUnitResult = new CompilationResult(unit, 0, 0, this.compilerOptions.maxProblemsPerUnit));
                    if (parsedUnit == null) continue;
                    char[] packageDeclaration = parsedUnit.currentPackage == null ? CharOperation.NO_CHAR : CharOperation.concatWith(parsedUnit.currentPackage.getImportName(), '.');
                    class AllTypeDeclarationsVisitor
                    extends ASTVisitor {
                        private final /* synthetic */ char val$classOrInterface;
                        private final /* synthetic */ char[] val$packageName;
                        private final /* synthetic */ char[] val$typeName;
                        private final /* synthetic */ int val$matchRule;
                        private final /* synthetic */ char[] val$packageDeclaration;
                        private final /* synthetic */ ITypeNameRequestor val$nameRequestor;
                        private final /* synthetic */ String val$path;

                        AllTypeDeclarationsVisitor(char val$classOrInterface, char[] val$packageName, char[] val$typeName, int val$matchRule, char[] val$packageDeclaration, ITypeNameRequestor val$nameRequestor, String val$path) {
                            this.val$classOrInterface = val$classOrInterface;
                            this.val$packageName = val$packageName;
                            this.val$typeName = val$typeName;
                            this.val$matchRule = val$matchRule;
                            this.val$packageDeclaration = val$packageDeclaration;
                            this.val$nameRequestor = val$nameRequestor;
                            this.val$path = val$path;
                        }

                        public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
                            return false;
                        }

                        public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope compilationUnitScope) {
                            if (SearchEngine.this.match(this.val$classOrInterface, this.val$packageName, this.val$typeName, this.val$matchRule, !typeDeclaration.isInterface(), this.val$packageDeclaration, typeDeclaration.name)) {
                                if (!typeDeclaration.isInterface()) {
                                    this.val$nameRequestor.acceptClass(this.val$packageDeclaration, typeDeclaration.name, CharOperation.NO_CHAR_CHAR, this.val$path);
                                } else {
                                    this.val$nameRequestor.acceptInterface(this.val$packageDeclaration, typeDeclaration.name, CharOperation.NO_CHAR_CHAR, this.val$path);
                                }
                            }
                            return true;
                        }

                        public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope classScope) {
                            if (SearchEngine.this.match(this.val$classOrInterface, this.val$packageName, this.val$typeName, this.val$matchRule, !memberTypeDeclaration.isInterface(), this.val$packageDeclaration, memberTypeDeclaration.name)) {
                                TypeDeclaration enclosing = memberTypeDeclaration.enclosingType;
                                char[][] enclosingTypeNames = CharOperation.NO_CHAR_CHAR;
                                while (enclosing != null) {
                                    enclosingTypeNames = CharOperation.arrayConcat((char[][])new char[][]{enclosing.name}, enclosingTypeNames);
                                    if ((enclosing.bits & 0x400) != 0) {
                                        enclosing = enclosing.enclosingType;
                                        continue;
                                    }
                                    enclosing = null;
                                }
                                if (!memberTypeDeclaration.isInterface()) {
                                    this.val$nameRequestor.acceptClass(this.val$packageDeclaration, memberTypeDeclaration.name, enclosingTypeNames, this.val$path);
                                } else {
                                    this.val$nameRequestor.acceptInterface(this.val$packageDeclaration, memberTypeDeclaration.name, enclosingTypeNames, this.val$path);
                                }
                            }
                            return true;
                        }
                    }
                    parsedUnit.traverse((ASTVisitor)new AllTypeDeclarationsVisitor(classOrInterface, packageName, typeName, matchRule, packageDeclaration, nameRequestor, path), parsedUnit.scope);
                }
            }
            finally {
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
        }
    }

    public void searchAllTypeNames(IWorkspace workspace, char[] packageName, char[] typeName, int matchMode, boolean isCaseSensitive, int searchFor, IJavaSearchScope scope, ITypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaModelException {
        this.searchAllTypeNames(packageName, typeName, isCaseSensitive ? matchMode | 8 : matchMode, searchFor, scope, nameRequestor, waitingPolicy, progressMonitor);
    }

    private void searchDeclarations(IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector, SearchPattern pattern) throws JavaModelException {
        this.searchDeclarations(enclosingElement, new ResultCollectorAdapter(resultCollector), pattern, resultCollector.getProgressMonitor());
    }

    private void searchDeclarations(IJavaElement enclosingElement, SearchRequestor requestor, SearchPattern pattern, IProgressMonitor monitor) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(new IJavaElement[]{enclosingElement});
        IResource resource = this.getResource(enclosingElement);
        try {
            if (resource instanceof IFile) {
                if (VERBOSE) {
                    System.out.println("Searching for " + pattern + " in " + resource.getFullPath());
                }
                SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
                SearchDocument[] documents = MatchLocator.addWorkingCopies(pattern, new SearchDocument[]{new JavaSearchDocument(enclosingElement.getPath().toString(), participant)}, this.getWorkingCopies(enclosingElement), participant);
                participant.locateMatches(documents, pattern, scope, requestor, monitor);
            } else {
                this.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
            }
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    public void searchDeclarationsOfAccessedFields(IJavaElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaModelException {
        DeclarationOfAccessedFieldsPattern pattern = new DeclarationOfAccessedFieldsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfAccessedFields(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfAccessedFieldsPattern pattern = new DeclarationOfAccessedFieldsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, resultCollector, pattern);
    }

    public void searchDeclarationsOfReferencedTypes(IJavaElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaModelException {
        DeclarationOfReferencedTypesPattern pattern = new DeclarationOfReferencedTypesPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfReferencedTypes(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfReferencedTypesPattern pattern = new DeclarationOfReferencedTypesPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, resultCollector, pattern);
    }

    public void searchDeclarationsOfSentMessages(IJavaElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaModelException {
        DeclarationOfReferencedMethodsPattern pattern = new DeclarationOfReferencedMethodsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfSentMessages(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfReferencedMethodsPattern pattern = new DeclarationOfReferencedMethodsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, resultCollector, pattern);
    }

    class ResultCollectorAdapter
    extends SearchRequestor {
        IJavaSearchResultCollector resultCollector;

        ResultCollectorAdapter(IJavaSearchResultCollector resultCollector) {
            this.resultCollector = resultCollector;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.resultCollector.accept(match.getResource(), match.getOffset(), match.getOffset() + match.getLength(), (IJavaElement)match.getElement(), match.getAccuracy());
        }

        public void beginReporting() {
            this.resultCollector.aboutToStart();
        }

        public void endReporting() {
            this.resultCollector.done();
        }
    }

    static class SearchPatternAdapter
    implements ISearchPattern {
        SearchPattern pattern;

        SearchPatternAdapter(SearchPattern pattern) {
            this.pattern = pattern;
        }
    }
}

