/*
 * Copyright  2002,2004 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package org.apache.tools.ant.taskdefs.optional.extension.resolvers;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionResolver;

/**
 * Resolver that just returns s specified location.
 *
 * @version $Revision: 1.6.2.4 $ $Date: 2004/03/09 17:01:46 $
 */
public class LocationResolver
    implements ExtensionResolver {
    private String m_location;

    public void setLocation(final String location) {
        m_location = location;
    }

    public File resolve(final Extension extension,
                        final Project project)
        throws BuildException {
        if (null == m_location) {
            final String message = "No location specified for resolver";
            throw new BuildException(message);
        }

        return project.resolveFile(m_location);
    }

    public String toString() {
        return "Location[" + m_location + "]";
    }
}
