/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorUtility {
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public static boolean isEditorInput(Object element, IEditorPart editor) {
        if (editor != null) {
            try {
                return editor.getEditorInput().equals(EditorUtility.getEditorInput(element));
            }
            catch (JavaModelException x) {
                JavaPlugin.log(x.getStatus());
            }
        }
        return false;
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (JavaModelException x) {
            JavaPlugin.log(x.getStatus());
        }
        if (input != null && (p = JavaPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws JavaModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws JavaModelException, PartInitException {
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return EditorUtility.openInEditor(fileInput.getFile(), activate);
        }
        if (input != null) {
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, IJavaElement element) {
        if (element != null && part instanceof JavaEditor) {
            ((JavaEditor)part).setSelection(element);
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = JavaPlugin.getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = JavaPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        IAction toggleAction;
        if (editorPart instanceof ITextEditor && (toggleAction = editorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly")) != null && toggleAction.isEnabled() && toggleAction.isChecked()) {
            if (toggleAction instanceof TextEditorAction) {
                ((TextEditorAction)toggleAction).setEditor(null);
                ((TextEditorAction)toggleAction).setEditor((ITextEditor)editorPart);
            } else {
                toggleAction.run();
                toggleAction.run();
            }
        }
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        String inputName;
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDescriptor = registry.getDefaultEditor(inputName = input.getName());
        if (editorDescriptor == null && registry.isSystemInPlaceEditorAvailable(inputName)) {
            editorDescriptor = registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (editorDescriptor == null && registry.isSystemExternalEditorAvailable(inputName)) {
            editorDescriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (editorDescriptor == null) {
            editorDescriptor = registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        if (editorDescriptor == null) {
            return null;
        }
        return editorDescriptor.getId();
    }

    private static IEditorInput getEditorInput(IJavaElement element) throws JavaModelException {
        while (element != null) {
            ICompilationUnit unit;
            IResource resource;
            if (element instanceof ICompilationUnit && (resource = (unit = JavaModelUtil.toOriginal((ICompilationUnit)element)).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            if (element instanceof IClassFile) {
                return new InternalClassFileEditorInput((IClassFile)element);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws JavaModelException {
        if (input instanceof IJavaElement) {
            return EditorUtility.getEditorInput((IJavaElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (input instanceof IStorage) {
            return new JarEntryEditorInput((IStorage)input);
        }
        return null;
    }

    public static IJavaElement getActiveEditorJavaInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            return (IJavaElement)editorInput.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = EditorUtility.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        }
        return null;
    }

    public static int findLocalizedModifier(String token) {
        if (token == null) {
            return 0;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return JavaEditorMessages.getFormattedString("EditorUtility.concatModifierStrings", new String[]{modifierString, newModifierString});
    }

    public static IJavaProject getJavaProject(IEditorInput input) {
        IJavaProject jProject = null;
        if (input instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            if (project != null && !(jProject = JavaCore.create((IProject)project)).exists()) {
                jProject = null;
            }
        } else if (input instanceof IClassFileEditorInput) {
            jProject = ((IClassFileEditorInput)input).getClassFile().getJavaProject();
        }
        return jProject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

