/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.code.ExtractMethodWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExtractMethodAction
extends SelectionDispatchAction {
    private final CompilationUnitEditor fEditor;
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.getString("ExtractMethodAction.dialog.title");

    public ExtractMethodAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.getString("ExtractMethodAction.label"));
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.extract_method_action");
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(ITextSelection selection) {
        if (selection.getLength() == 0) {
            return false;
        }
        return this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null;
    }

    public void selectionChanged(JavaTextSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(JavaTextSelection selection) {
        return (selection.resolveInMethodBody() || selection.resolveInInitializer()) && ExtractMethodRefactoring.isAvailable(selection.resolveSelectedNodes());
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            ExtractMethodRefactoring refactoring = ExtractMethodAction.createRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection);
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, ExtractMethodAction.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }

    private static ExtractMethodRefactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) throws CoreException {
        return ExtractMethodRefactoring.create(cunit, selection.getOffset(), selection.getLength(), JavaPreferencesSettings.getCodeGenerationSettings());
    }

    private static RefactoringWizard createWizard(ExtractMethodRefactoring refactoring) {
        return new ExtractMethodWizard(refactoring);
    }
}

