/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.debug.internal.core.ContributedDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchManager;

public class LaunchConfigurationType
extends PlatformObject
implements ILaunchConfigurationType {
    private IConfigurationElement fElement;
    private Set fBaseModes;
    private Set fContributedModes;
    private Map fDelegates;

    protected LaunchConfigurationType(IConfigurationElement element) {
        this.setConfigurationElement(element);
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fElement = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    public boolean supportsMode(String mode) {
        return this.getBaseModes().contains(mode) || this.getContributedModes().contains(mode);
    }

    protected Set getBaseModes() {
        if (this.fBaseModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return new HashSet(0);
            }
            StringTokenizer tokenizer = new StringTokenizer(modes, ",");
            this.fBaseModes = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fBaseModes.add(tokenizer.nextToken().trim());
            }
        }
        return this.fBaseModes;
    }

    protected Set getContributedModes() {
        if (this.fContributedModes == null) {
            this.fContributedModes = new HashSet(0);
            List delegates = ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).getContributedDelegates();
            Iterator iterator = delegates.iterator();
            while (iterator.hasNext()) {
                ContributedDelegate delegate = (ContributedDelegate)iterator.next();
                if (!delegate.getLaunchConfigurationType().equals(this.getIdentifier())) continue;
                this.fContributedModes.addAll(delegate.getModes());
            }
        }
        return this.fContributedModes;
    }

    public String getName() {
        return this.getConfigurationElement().getAttribute("name");
    }

    public ISourcePathComputer getSourcePathComputer() {
        String id = this.getConfigurationElement().getAttribute("sourcePathComputerId");
        if (id != null && id.length() > 0) {
            return DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer(id);
        }
        return null;
    }

    public String getIdentifier() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }

    public String getAttribute(String attributeName) {
        return this.getConfigurationElement().getAttribute(attributeName);
    }

    public boolean isPublic() {
        String publicString = this.getConfigurationElement().getAttribute("public");
        return publicString == null || !publicString.equalsIgnoreCase("false");
    }

    public ILaunchConfigurationWorkingCopy newInstance(IContainer container, String name) {
        return new LaunchConfigurationWorkingCopy(container, name, this);
    }

    public ILaunchConfigurationDelegate getDelegate() throws CoreException {
        return this.getDelegate("run");
    }

    public ILaunchConfigurationDelegate getDelegate(String mode) throws CoreException {
        ILaunchConfigurationDelegate delegate;
        if (!this.supportsMode(mode)) {
            throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, MessageFormat.format(DebugCoreMessages.getString("LaunchConfigurationType.9"), mode, this.getIdentifier()), null));
        }
        if (this.fDelegates == null) {
            this.fDelegates = new Hashtable(3);
        }
        if ((delegate = (ILaunchConfigurationDelegate)this.fDelegates.get(mode)) == null) {
            Set modes = this.getBaseModes();
            if (modes.contains(mode)) {
                Object object = this.getConfigurationElement().createExecutableExtension("delegate");
                if (object instanceof ILaunchConfigurationDelegate) {
                    Iterator iter = modes.iterator();
                    while (iter.hasNext()) {
                        this.fDelegates.put(iter.next(), object);
                    }
                    return (ILaunchConfigurationDelegate)object;
                }
                throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, MessageFormat.format(DebugCoreMessages.getString("LaunchConfigurationType.Launch_delegate_for_{0}_does_not_implement_required_interface_ILaunchConfigurationDelegate._1"), this.getName()), null));
            }
            List contributed = ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).getContributedDelegates();
            Iterator iterator = contributed.iterator();
            while (iterator.hasNext()) {
                ContributedDelegate contributedDelegate = (ContributedDelegate)iterator.next();
                if (!this.getIdentifier().equals(contributedDelegate.getLaunchConfigurationType()) || !(modes = contributedDelegate.getModes()).contains(mode)) continue;
                delegate = contributedDelegate.getDelegate();
                Iterator modesIterator = modes.iterator();
                while (modesIterator.hasNext()) {
                    this.fDelegates.put(modesIterator.next(), delegate);
                }
                return delegate;
            }
        } else {
            return delegate;
        }
        throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, MessageFormat.format(DebugCoreMessages.getString("LaunchConfigurationType.10"), this.getIdentifier(), mode), null));
    }

    public String getSourceLocatorId() {
        return this.getAttribute("sourceLocatorId");
    }

    public String getPluginIdentifier() {
        return this.fElement.getDeclaringExtension().getNamespace();
    }
}

