/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Type;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.model.JDIArrayType;
import org.eclipse.jdt.internal.debug.core.model.JDIClassType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIInterfaceType;

public class JDIType
implements IJavaType {
    private Type fType;
    private JDIDebugTarget fDebugTarget;

    protected JDIType(JDIDebugTarget target, Type type) {
        this.setDebugTarget(target);
        this.setUnderlyingType(type);
    }

    public static JDIType createType(JDIDebugTarget target, Type type) {
        if (type instanceof ArrayType) {
            return new JDIArrayType(target, (ArrayType)type);
        }
        if (type instanceof ClassType) {
            return new JDIClassType(target, (ClassType)type);
        }
        if (type instanceof InterfaceType) {
            return new JDIInterfaceType(target, (InterfaceType)type);
        }
        return new JDIType(target, type);
    }

    public String getSignature() throws DebugException {
        try {
            return this.getUnderlyingType().signature();
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIType.exception_while_retrieving_signature"), e.toString()), e);
            return null;
        }
    }

    protected JDIDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    protected void setDebugTarget(JDIDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    public Type getUnderlyingType() {
        return this.fType;
    }

    protected void setUnderlyingType(Type type) {
        this.fType = type;
    }

    public String toString() {
        return this.getUnderlyingType().toString();
    }

    public String getName() throws DebugException {
        try {
            return this.getUnderlyingType().name();
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIType.exception_while_retrieving_type_name"), e.toString()), e);
            return null;
        }
    }

    public boolean equals(Object object) {
        return object instanceof JDIType && this.fType.equals(((JDIType)object).fType);
    }

    public int hashCode() {
        return this.fType.hashCode();
    }
}

