/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class ContentStamps {
    public static final ContentStamp NULL_CONTENT_STAMP = new ContentStampImpl(-1);
    private static final QualifiedName CONTENT_STAMP = new QualifiedName(RefactoringCorePlugin.getPluginId(), "contentStamp");

    public static ContentStamp get(IFile file) {
        try {
            ContentStamp result = (ContentStamp)file.getSessionProperty(CONTENT_STAMP);
            if (result != null) {
                return result;
            }
            return NULL_CONTENT_STAMP;
        }
        catch (CoreException coreException) {
            return NULL_CONTENT_STAMP;
        }
    }

    public static ContentStamp get(IFile file, boolean create) {
        ContentStamp result = ContentStamps.get(file);
        if (result.isNullStamp() && create) {
            result = new ContentStampImpl(0);
            try {
                file.setSessionProperty(CONTENT_STAMP, (Object)result);
            }
            catch (CoreException e) {
                return NULL_CONTENT_STAMP;
            }
        }
        return result;
    }

    public static void remove(IFile file) {
        try {
            file.setSessionProperty(CONTENT_STAMP, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void increment(IFile file) {
        try {
            ContentStampImpl stamp = (ContentStampImpl)file.getSessionProperty(CONTENT_STAMP);
            if (stamp == null) {
                return;
            }
            file.setSessionProperty(CONTENT_STAMP, (Object)new ContentStampImpl(stamp.fValue + 1));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void set(IFile file, ContentStamp stamp) {
        try {
            file.setSessionProperty(CONTENT_STAMP, (Object)stamp);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private static class ContentStampImpl
    extends ContentStamp {
        public static final int NULL_VALUE = -1;
        private int fValue;

        private ContentStampImpl(int value) {
            this.fValue = value;
        }

        public boolean isNullStamp() {
            return this.fValue == -1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ContentStampImpl)) {
                return false;
            }
            return ((ContentStampImpl)obj).fValue == this.fValue;
        }

        public int hashCode() {
            return this.fValue;
        }

        public String toString() {
            if (this.fValue == -1) {
                return "Null Stamp";
            }
            return "Stamp: " + this.fValue;
        }
    }
}

