/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ProvidingBundle;

public class BundleLoaderProxy
implements KeyedElement,
ProvidingBundle {
    private BundleLoader loader;
    private BundleHost bundle;
    private String symbolicName;
    private Version version;
    private String key;
    private boolean stale = false;
    private KeyedHashSet users;
    private KeyedHashSet pkgSources;
    protected boolean markedUsedDependencies = false;

    public BundleLoaderProxy(BundleHost bundle) {
        this.bundle = bundle;
        this.symbolicName = bundle.getSymbolicName();
        if (this.symbolicName == null) {
            this.symbolicName = bundle.getBundleId() + "NOSYMBOLICNAME";
        }
        this.version = bundle.getVersion();
        this.key = this.symbolicName + "_" + this.version.toString();
        this.users = new KeyedHashSet(false);
        this.pkgSources = new KeyedHashSet(false);
    }

    public BundleLoader getBundleLoader() {
        if (this.loader == null) {
            this.loader = this.bundle.getBundleLoader();
        }
        return this.loader;
    }

    public AbstractBundle getBundleHost() {
        return this.bundle;
    }

    public void setBundleLoader(BundleLoader value) {
        this.loader = value;
    }

    public void markUsed(BundleLoaderProxy user) {
        if (user.getBundleHost() != this.bundle) {
            this.users.add(user);
        }
    }

    public void unMarkUsed(BundleLoaderProxy user) {
        this.users.removeByKey(user.getKey());
    }

    public int getKeyHashCode() {
        return this.key.hashCode();
    }

    public boolean compare(KeyedElement other) {
        if (!(other instanceof BundleLoaderProxy)) {
            return false;
        }
        BundleLoaderProxy otherLoaderProxy = (BundleLoaderProxy)other;
        return this.symbolicName.equals(otherLoaderProxy.symbolicName) && this.version.equals((Object)otherLoaderProxy.version);
    }

    public Object getKey() {
        return this.key;
    }

    public void setStale() {
        this.stale = true;
    }

    public boolean isStale() {
        return this.stale;
    }

    public boolean inUse() {
        return this.users.size() > 0;
    }

    public AbstractBundle[] getDependentBundles() {
        KeyedElement[] proxyLoaders = this.users.elements();
        KeyedHashSet bundles = new KeyedHashSet(proxyLoaders.length, false);
        for (int i = 0; i < proxyLoaders.length; ++i) {
            BundleLoaderProxy loaderProxy = (BundleLoaderProxy)proxyLoaders[i];
            bundles.add(loaderProxy.getBundleHost());
        }
        KeyedElement[] elements = bundles.elements();
        AbstractBundle[] result = new AbstractBundle[elements.length];
        System.arraycopy(elements, 0, result, 0, elements.length);
        return result;
    }

    public String toString() {
        String symbolicName = this.bundle.getSymbolicName();
        StringBuffer sb = new StringBuffer(symbolicName == null ? this.bundle.getLocation() : symbolicName);
        sb.append("; ").append("bundle-version");
        sb.append("=\"").append(this.version.toString()).append("\"");
        return sb.toString();
    }

    protected void markDependencies() {
        if (this.markedUsedDependencies || !this.bundle.isResolved()) {
            return;
        }
        this.markedUsedDependencies = true;
        BundleDescription bundleDes = this.bundle.getBundleDescription();
        if (Debug.DEBUG_GENERAL && bundleDes == null) {
            Debug.println("Bundle.resolved called and getBundleDescription returned null: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        PackageSpecification[] packages = bundleDes.getPackages();
        BundleSpecification[] requiredBundles = bundleDes.getRequiredBundles();
        BundleDescription[] fragDescriptions = bundleDes.getFragments();
        this.markUsedPackages(packages);
        this.markUsedBundles(requiredBundles);
        for (int i = 0; i < fragDescriptions.length; ++i) {
            if (!fragDescriptions[i].isResolved()) continue;
            this.markUsedPackages(fragDescriptions[i].getPackages());
            this.markUsedBundles(fragDescriptions[i].getRequiredBundles());
        }
        this.getBundleLoader();
    }

    private void markUsedPackages(PackageSpecification[] packages) {
        if (packages != null) {
            for (int i = 0; i < packages.length; ++i) {
                SingleSourcePackage packagesource = (SingleSourcePackage)this.bundle.framework.packageAdmin.exportedPackages.getByKey(packages[i].getName());
                if (packagesource == null) continue;
                packagesource.getSupplier().markUsed(this);
            }
        }
    }

    private void markUsedBundles(BundleSpecification[] requiredBundles) {
        if (requiredBundles != null) {
            for (int i = 0; i < requiredBundles.length; ++i) {
                String bundleKey;
                BundleLoaderProxy loaderProxy;
                if (!requiredBundles[i].isResolved() || (loaderProxy = (BundleLoaderProxy)this.bundle.framework.packageAdmin.exportedBundles.getByKey(bundleKey = requiredBundles[i].getName() + "_" + requiredBundles[i].getActualVersion().toString())) == null) continue;
                loaderProxy.markUsed(this);
            }
        }
    }

    public Bundle getBundle() {
        if (this.isStale()) {
            return null;
        }
        return this.bundle;
    }

    public Bundle[] getRequiringBundles() {
        if (this.isStale()) {
            return null;
        }
        KeyedElement[] requiringProxies = this.users.elements();
        ArrayList<AbstractBundle> requiringBundles = new ArrayList<AbstractBundle>();
        for (int i = 0; i < requiringProxies.length; ++i) {
            BundleLoaderProxy requiringProxy = (BundleLoaderProxy)requiringProxies[i];
            BundleLoader requiringLoader = requiringProxy.getBundleLoader();
            BundleLoaderProxy[] reqBundles = requiringLoader.requiredBundles;
            if (reqBundles == null) continue;
            for (int j = 0; j < reqBundles.length; ++j) {
                if (reqBundles[j] != this) continue;
                requiringBundles.add(requiringProxy.getBundleHost());
            }
        }
        return requiringBundles.toArray(new AbstractBundle[requiringBundles.size()]);
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public boolean isRemovalPending() {
        return this.bundle.framework.packageAdmin.removalPending.contains(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleSourcePackage getPackageSource(String pkgName) {
        SingleSourcePackage pkgSource = (SingleSourcePackage)this.pkgSources.getByKey(pkgName);
        if (pkgSource == null) {
            KeyedHashSet keyedHashSet = this.pkgSources;
            synchronized (keyedHashSet) {
                pkgSource = new SingleSourcePackage(pkgName, this);
                this.pkgSources.add(pkgSource);
            }
        }
        return pkgSource;
    }
}

