/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.launching.LaunchingMessages;

public final class LibraryLocation {
    private IPath fSystemLibrary;
    private IPath fSystemLibrarySource;
    private IPath fPackageRootPath;

    public LibraryLocation(IPath libraryPath, IPath sourcePath, IPath packageRoot) {
        if (libraryPath == null) {
            throw new IllegalArgumentException(LaunchingMessages.getString("libraryLocation.assert.libraryNotNull"));
        }
        this.fSystemLibrary = libraryPath;
        this.fSystemLibrarySource = sourcePath;
        this.fPackageRootPath = packageRoot;
    }

    public IPath getSystemLibraryPath() {
        return this.fSystemLibrary;
    }

    public IPath getSystemLibrarySourcePath() {
        return this.fSystemLibrarySource;
    }

    public IPath getPackageRootPath() {
        return this.fPackageRootPath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LibraryLocation) {
            LibraryLocation lib = (LibraryLocation)obj;
            return this.getSystemLibraryPath().equals(lib.getSystemLibraryPath()) && this.equals(this.getSystemLibrarySourcePath(), lib.getSystemLibrarySourcePath()) && this.equals(this.getPackageRootPath(), lib.getPackageRootPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystemLibraryPath().hashCode();
    }

    protected boolean equals(IPath path1, IPath path2) {
        if (path1 == null) {
            return path2 == null;
        }
        if (path2 == null) {
            return false;
        }
        return path1.equals(path2);
    }
}

