/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinSimpleButtonIndexModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class LiquidSliderUI
extends BasicSliderUI {
    private static Skin skinThumbHoriz;
    private static Skin skinThumbVert;
    private static Skin skinHorizSlider;
    private static Skin skinVertSlider;
    private Skin skinSlider;
    private SkinSimpleButtonIndexModel skinIndexModel = new SkinSimpleButtonIndexModel();
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    protected boolean isDragging = false;
    protected BasicSliderUI.TrackListener trackListener;

    public LiquidSliderUI() {
        super(null);
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new MyTrackListener();
    }

    protected Dimension getThumbSize() {
        Dimension size = this.getSkinThumb().getSize();
        return size;
    }

    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        int index = this.skinIndexModel.getIndexForState(this.slider.isEnabled(), this.isRollover, this.isDragging);
        this.getSkinThumb().drawCentered(g, index, knobBounds.x, knobBounds.y, knobBounds.width, knobBounds.height);
    }

    public static ComponentUI createUI(JComponent c) {
        return new LiquidSliderUI();
    }

    protected int getTrackWidth() {
        double kIdealTrackWidth = 7.0;
        double kIdealThumbHeight = 16.0;
        double kWidthScalar = 0.4375;
        if (this.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)this.thumbRect.height);
        }
        return (int)(0.4375 * (double)this.thumbRect.width);
    }

    protected int getThumbOverhang() {
        if (this.slider.getOrientation() == 1) {
            return (int)(this.getThumbSize().getWidth() - (double)this.getTrackWidth()) / 2;
        }
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    public void paint(Graphics g, JComponent c) {
        c.setOpaque(false);
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
        super.paint(g, c);
    }

    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        int w = tickBounds.width;
        int h = tickBounds.height;
        boolean leftToRight = this.slider.getComponentOrientation().isLeftToRight();
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(tickBounds.x, tickBounds.y, tickBounds.width, tickBounds.height);
        g.setColor(Color.black);
        int maj = this.slider.getMajorTickSpacing();
        int min = this.slider.getMinorTickSpacing();
        if (this.slider.getOrientation() == 0) {
            int value;
            g.translate(0, tickBounds.y);
            int xPos = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMinorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum();
            int yPos = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!leftToRight) {
                    offset = tickBounds.width - tickBounds.width / 2;
                    g.translate(offset, 0);
                }
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                if (!leftToRight) {
                    g.translate(-offset, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                value = this.slider.getMinimum();
                if (!leftToRight) {
                    g.translate(2, 0);
                }
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMajorTickSpacing();
                }
                if (!leftToRight) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    public void paintTrack(Graphics g) {
        Color trackColor = Color.red;
        boolean leftToRight = this.slider.getComponentOrientation().isLeftToRight();
        g.translate(this.trackRect.x, this.trackRect.y);
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
            int h = (trackBottom - trackTop - LiquidSliderUI.getSkinHorizSlider().getVsize()) / 2;
            LiquidSliderUI.getSkinHorizSlider().draw(g, 0, trackLeft, trackTop + h, trackRight - trackLeft, LiquidSliderUI.getSkinHorizSlider().getVsize());
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
            int w = (trackRight - trackLeft - LiquidSliderUI.getSkinVertSlider().getHsize()) / 2;
            LiquidSliderUI.getSkinVertSlider().draw(g, 0, trackLeft + w, trackTop, LiquidSliderUI.getSkinVertSlider().getHsize(), trackBottom - trackTop);
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(LiquidLookAndFeel.getDarkControl());
        g.drawLine(x, 0, x, tickBounds.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(LiquidLookAndFeel.getDarkControl());
        g.drawLine(x, 0, x, tickBounds.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(LiquidLookAndFeel.getDarkControl());
        g.drawLine(0, y, tickBounds.width / 2 - 1, y);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(LiquidLookAndFeel.getDarkControl());
        g.drawLine(0, y, tickBounds.width - 2, y);
    }

    public static Skin getSkinHorizSlider() {
        if (skinHorizSlider == null) {
            skinHorizSlider = new Skin("sliderhorizbackground.png", 1, 6, 0, 6, 0);
        }
        return skinHorizSlider;
    }

    public static Skin getSkinThumbHoriz() {
        if (skinThumbHoriz == null) {
            skinThumbHoriz = new Skin("sliderhoriz.png", 4, 0);
        }
        return skinThumbHoriz;
    }

    public static Skin getSkinThumbVert() {
        if (skinThumbVert == null) {
            skinThumbVert = new Skin("slidervert.png", 4, 0);
        }
        return skinThumbVert;
    }

    public static Skin getSkinVertSlider() {
        if (skinVertSlider == null) {
            skinVertSlider = new Skin("slidervertbackground.png", 1, 0, 6, 0, 6);
        }
        return skinVertSlider;
    }

    public Skin getSkinThumb() {
        if (this.skinSlider == null) {
            this.skinSlider = this.slider.getOrientation() == 0 ? LiquidSliderUI.getSkinThumbHoriz() : LiquidSliderUI.getSkinThumbVert();
        }
        return this.skinSlider;
    }

    class MyTrackListener
    extends BasicSliderUI.TrackListener {
        MyTrackListener() {
            super(LiquidSliderUI.this);
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            LiquidSliderUI.this.isDragging = false;
            LiquidSliderUI.this.slider.repaint();
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (LiquidSliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                LiquidSliderUI.this.isDragging = true;
            }
            LiquidSliderUI.this.slider.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            LiquidSliderUI.this.isRollover = false;
            LiquidSliderUI.this.wasRollover = false;
            if (LiquidSliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                LiquidSliderUI.this.isRollover = true;
            }
        }

        public void mouseExited(MouseEvent e) {
            LiquidSliderUI.this.isRollover = false;
            if (LiquidSliderUI.this.isRollover != LiquidSliderUI.this.wasRollover) {
                LiquidSliderUI.this.slider.repaint();
                LiquidSliderUI.this.wasRollover = LiquidSliderUI.this.isRollover;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (LiquidSliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                LiquidSliderUI.this.isRollover = true;
            }
            super.mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            if (LiquidSliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                LiquidSliderUI.this.isRollover = true;
                if (LiquidSliderUI.this.isRollover != LiquidSliderUI.this.wasRollover) {
                    LiquidSliderUI.this.slider.repaint();
                    LiquidSliderUI.this.wasRollover = LiquidSliderUI.this.isRollover;
                }
            } else {
                LiquidSliderUI.this.isRollover = false;
                if (LiquidSliderUI.this.isRollover != LiquidSliderUI.this.wasRollover) {
                    LiquidSliderUI.this.slider.repaint();
                    LiquidSliderUI.this.wasRollover = LiquidSliderUI.this.isRollover;
                }
            }
        }
    }
}

