{$N-,E-,V-,O+,F+}

Unit bibdialg;

Interface

uses
  bibwindo, objects, Dos, bibCrt, bibstrg, BibMouse, streams, bibstrm, bibwild,
  bibvars, bibfile, bibdisp, bibutil, bibsrtpt, bibsedit, bibedit, bib8bit,
  bibpchec, bibtext, bibselct, rc_strng, bibtmplt, bibcache, lfnunit;


function  PattFields(flds:string): string;
procedure PatternGet(pattern: PatRecPtr; var changed: boolean);
function  OneCritPattern(Pattern: PatRecPtr; CritInd: integer): boolean;
procedure About;
procedure Preferences;
procedure EncodingsOptions;
procedure FileFormatOptions;


Implementation

function PattFields(flds: string): string;
var
  tmp: string;
  Add: string[1];
  One: string[63];
  i: integer;
begin
  PattFields:='';
  if flds='' then Exit;
  if length(flds)>OrigFieldLast+1 then
  begin
    PattFields:='all fields'; Exit;
  end;
  tmp:=''; Add:='';
  for i:=1 to length(flds) do
  begin
    One:='';
    if flds[i]=PattField_Name then One:=PattStr_Name
    else if flds[i]=PattField_Undec then One:=PattStr_Undec
    else if (Ord(flds[i])<=OrigFieldLast) or
            (Ord(flds[i])=StringIndex) then
                 One:=TypeField^[ord(flds[i])];
    if One<>'' then
    begin
      tmp:=tmp+Add+One; Add:='+';
    end;
  end;
  StrLwr(tmp);
  PattFields:=tmp;
end;                          { PattFields }

procedure PatternGet(Pattern: PatRecPtr; var changed: boolean);
var
  i,nspec,choice,icode,depth: integer;
  scroll,MaxLine : LongInt;
  xfirst,att: byte;
  Slen: word;
  selected: SelectionType;
  OldSpec : SpecArr;
  fieldlist: ListArrPtr;
  AuthorAll,ok,outside,OldEmpty,fchanged,retain: boolean;
  CaseSen,RegExp: boolean;
  tmp: string;
  ScrBar: ScrBarPtr;

procedure NewField(selected: byte);
var
  i,j,xstart : integer;
  OldSpec : SpecArr;
  fieldlist: ListArrPtr;
  ifld,lastfld : byte;
  NewCase,NewReg,Negate: boolean;
begin
  if selected=0 then Exit;
  with Pattern^ do
  begin
  if (noper>=MaxPattOper) or (npatt>=MaxPattCrit) then
    begin
      ErrorMessageRC(Str_PattTooComplex,''); Exit;
    end;
    Inc(npatt);
    Inc(noper);
    flag[noper]:=0;
    if CaseSen then flag[noper]:=flag[noper] or PattFlag_CaseSen;
    if Regexp  then flag[noper]:=flag[noper] or PattFlag_Regexp;    
    operation[noper]:=npatt; Field[npatt]:='';
    if selected=CPattAdd_name then           { entry name }
    begin                                                  
      field[npatt]:=PattField_Name;
    end else if selected=CPattAdd_Type then  { entry type }
    begin
      field[npatt]:=PattField_Type;
    end else if selected=CPattAdd_Tagged then { Tagged entries }
    begin
      field[npatt]:=PattField_Tagged;
    end else if selected=CPattAdd_All then { All }
    begin
      nspec:=StringIndex+1;
      for i:=1 to nspec do field[npatt]:=field[npatt]+Chr(i-1);
    end else if selected=CPattAdd_Same then   { Same as last time }
    begin
      i:=npatt-1;
      while (i>0) and (operation[i]<=0) do dec(i);
      if i=0 then
      begin
        selected:=0;
        ErrorMessageRC(Str_NoPreviousFields,'');
      end else field[npatt]:=field[i];
    end else if selected=CPattAdd_Other then {Choose}
    begin
      nspec:=0;
      getmem(FieldList,(OrigFieldLast+4)*sizeof(ListArrRec));
      MaxMemAvail;
      FieldList^[1]:=PattStr_Name;
      for i:=1 to OrigFieldLast do FieldList^[i+1]:=typefield^[i];
      FieldList^[Origfieldlast+2]:=typefield^[StringIndex];
      FieldList^[Origfieldlast+3]:=PattStr_Undec;
      FieldChoose(FieldList^,Origfieldlast+3,3,15,OldSpec,nspec,
                                              false,false,1,0,true,true);
      FreeMem(FieldList,(Origfieldlast+4)*sizeof(ListArrRec));
      for i:=1 to nspec do
      begin
        if oldspec[i]<=Origfieldlast+1 then
          field[npatt]:=field[npatt]+Chr(oldspec[i]-1)
        else if OldSpec[i]=OrigFieldLast+2 then
          field[npatt]:=Field[npatt]+Chr(StringIndex)
        else if OldSpec[i]=OrigFieldLast+3 then
          field[npatt]:=Field[npatt]+PattField_Undec;
      end;
      if field[npatt]='' then selected:=0;
    end else if selected>=CPattAdd_User then    { User defined }
    begin
      for i:=1 to PmenuChoice[selected-CPattAdd_User+1,0] do
        field[npatt]:=field[npatt]+Chr(PmenuChoice[selected-CPattAdd_User+1,i]);     
    end;
    if (selected>0) and (selected<>CPattAdd_Tagged) then
    begin
      if field[npatt]=PattField_Type then   {Type}
      begin
        Patrn[npatt]:='';
        nspec:=0;
        GetMem(FieldList,(StringTypeInd+1)*sizeof(ListArrRec));
        MaxMemAvail;
        for i:=1 to StringTypeInd do FieldList^[i]:=TypeEntry^[i];
        FieldChoose(FieldList^,StringTypeInd,3,15,OldSpec,nspec,
                                              false,false,1,0,true,true);
        FreeMem(FieldList,(StringTypeInd+1)*sizeof(ListArrRec));
        for i:=1 to nspec do Patrn[npatt]:=Patrn[npatt]+Chr(oldspec[i]);
        if nspec=0 then
        begin
          npatt:=npatt-1; noper:=noper-1;
        end else
        begin
          depth:=depth+1;
          on:=true; changed:=true;
        end;
      end else
      begin
        AuthorAll:=true;
        nspec:=length(field[npatt]);
        for i:=1 to nspec do 
        begin
          OldSpec[i]:=Ord(Field[npatt,i]);
          if (Ord(field[npatt,i])>0) and (Ord(field[npatt,i])<=fieldlast) then
            AuthorAll:=AuthorAll and FieldParams^[Ord(field[npatt,i])].authorlike
          else if (Ord(field[npatt,i])>0) and (Ord(field[npatt,i])=StringIndex) then
            AuthorAll:=false;
        end;
        Patrn[npatt]:='';
        xstart:=(ScrWidth-75) div 2 +1;
        Slen:=0;
        NewCase:=CaseSen; NewReg:=RegExp; Negate:=false;
        repeat
          ReadBig('Enter Pattern: ',Patrn[npatt][1],Slen,
               ScrLen-9,xstart,6,75,[#0..#31]-[#21],fchanged,retain,253,
               true,NewCase,NewReg,@Negate,false,AuthorAll,PattFields(Field[npatt]));
          if retain and NewReg then
          begin
            Patrn[npatt][0]:=Chr(Slen);
            ok:=ValidRegexp(Patrn[npatt],true);
          end else ok:=true;
        until (not retain) or ok;
        if not retain then Patrn[npatt]:=''
        else Patrn[npatt][0]:=Chr(Slen);
        ChrDelL(Patrn[npatt],' '); ChrDelR(Patrn[npatt],' ');
        if Prog7bit then SConv27Bit(Patrn[npatt],AuthorAll)
        else if Prog8bit then SConv28Bit(Patrn[npatt],AuthorAll);
        if retain then
        begin
          depth:=depth+1;
          on:=true; changed:=true;
          CaseSen:=NewCase; RegExp:=NewReg;
          flag[noper]:=flag[noper] and not (PattFlag_CaseSen or PattFlag_Regexp);
          if CaseSen then flag[noper]:=flag[noper] or PattFlag_CaseSen;
          if Regexp  then flag[noper]:=flag[noper] or PattFlag_Regexp;
          if Negate  then flag[noper]:=flag[noper] or PattFlag_NOT;
        end else begin
          npatt:=npatt-1; noper:=noper-1;
        end;
      end;
    end else if selected=CPattAdd_Tagged then
    begin
      depth:=depth+1;
      on:=true; changed:=true;
    end else
    begin
      npatt:=npatt-1; noper:=noper-1;
    end;
  end;
end;                     { NewField }

begin                    { PatternGet }
  Scroll:=0; ScrBar:=Nil; Depth:=0;
  if Pattern^.noper>0 then Depth:=1;
  changed:=false;
  CaseSen:=false; RegExp:=false;
  PushBufferStack(Pattern^,sizeof(PatRec),EnoughMem(sizeof(PatRec)),0);
  MakeWindowNo(2,1,ScrLen-1,ScrWidth,PatternNorm,PatternBorder,2,RNorm,0,0);
  MaxMemAvail;
  TitleWindow(2,PatternBorder,'Edit Pattern');

  OldEmpty:=(Pattern^.noper=0);
  PattEditMenu.currentpos:=1;
  New(ScrBar); ScrBar^.Color:=CScrBarPatt; ScrBar^.HeldDown:=false;
  with Pattern^ do
  repeat
    GetPattCase(Pattern,noper,CaseSen,RegExp);
    OutputPattern(Pattern,ScrWidth-2,true,2,3,ScrLen-3,Scroll,MaxLine,
                  Nil,'','',false,true);
    outside:=false;
    TopLine(PattEditMenu, selected, OldEmpty, outside, Scroll, MaxLine,ScrBar);
    if OldEmpty then
    begin
      outside:=true;
      selected[0]:=CPattAdd;
      outside:=false;
      OldEmpty:=false
    end;
    choice:=selected[0];

    if choice=CTop_Outside then choice:=0;
    if choice=CTop_F1 then ContextHelp('Pattern')
    else if choice=CPattAdd then
    begin
      if (noper<MaxPattOper) and (npatt<MaxPattCrit) then
      begin
        NewField(selected[1]);
        changed:=true;
      end else ErrorMessageRC(Str_PattTooComplex,'');
    end else if choice=CPattAND then  { AND }
    begin
      if (noper>=MaxPattOper) then ErrorMessageRC(Str_PattTooComplex,'')
      else if depth>1 then
      begin
        noper:=noper+1;
        operation[noper]:=Patt_AND;
        flag[noper]:=0;
        depth:=depth-1;
        changed:=true;
      end else ErrorMessageRC(Str_PattTooManyOpers,'');
    end else if choice=CPattOR then  { OR }
    begin
      if (noper>=MaxPattOper) then ErrorMessageRC(Str_PattTooComplex,'')
      else if depth>1 then
      begin
        noper:=noper+1;
        operation[noper]:=Patt_OR;
        flag[noper]:=0;
        depth:=depth-1;
        changed:=true;
      end else ErrorMessageRC(Str_PattTooManyOpers,'');
    end else if choice=CPattNOT then      { NOT }
    begin
      if noper>0 then
      begin
        if (flag[noper] and PattFlag_NOT)<>0 then
          flag[noper]:=flag[noper] and not PattFlag_NOT
        else
          flag[noper]:=flag[noper] or PattFlag_NOT; 
       end;
       changed:=true;
    end else if (choice=CPattBS) and (noper>0) then  { Delete last }
    begin
      if operation[noper]>0 then
      begin
        npatt:=npatt-1; depth:=depth-1;
      end else depth:=depth+1;
      noper:=noper-1;
      changed:=true;
      if (npatt=0) or (noper=0) then on:=false;
    end else if choice=CPattClear then       { Delete all }
    begin
      noper:=0;  npatt:=0; depth:=0;
      on:=false; changed:=true;
    end else if choice=CPattFile then                { Load/Save }
    begin
      if selected[1]=CPattFile_Load then
      begin
        PatternLoad(Pattern,'',true,ok);
        if ok then changed:=true;
      end else if selected[1]=CPattFile_Save then
      begin
        if depth=1 then PatternSave(Pattern)
        else ErrorMessageRC(Str_PatternIncomplete,'');
      end;
    end else if choice=CPattOnOff then
    begin
      if Pattern^.on or (npatt>0) then Pattern^.on:=not Pattern^.on;
    end else if choice=CPattSave then
    begin
      if depth>1 then
      begin
        ErrorMessageRC(Str_PatternIncomplete,'');
        choice:=0;
      end;
    end;
  until (choice=CPattSave) or (choice=CPattQuit);
  if ScrBar<>Nil then Dispose(ScrBar); ScrBar:=Nil;

  if choice=CPattQuit then RecallBufferStack(Pattern^,0)   { Quit }
  else if changed then
  begin
    inc(PatternNumber);
    with Pattern^ do
      for i:=1 to noper do
        if operation[i]>0 then
          SortPattField(Field[operation[i]]);
  end;
  if (Pattern^.npatt=0) or (Pattern^.noper=0) then Pattern^.on:=false;
  RemoveWindow;
  DiscardBufferStack;
end;                          { PatternGet }

function OneCritPattern(Pattern: PatRecPtr; CritInd: integer): boolean;
var
  Regexp,Casesen,Negate,AuthorAll,Retain,fchanged: boolean;
  Crit,flds,Title: string;
  i,nspec,xstart: integer;
  SLen: word;
begin
  OneCritPattern:=false;
  Regexp:=false; Casesen:=false; Negate:=false; Crit:='';
  with Pattern^ do
  begin
    if (noper=1) then
    begin
      CaseSen:=(flag[1] and PattFlag_CaseSen)<>0;
      RegExp :=(flag[1] and PattFlag_CaseSen)<>0;
      Negate :=(flag[1] and PattFlag_NOT    )<>0;
      Crit:=Patrn[1];
    end;
    flds:='';
    if CritInd=CPatt_AllFields then
      for i:=1 to StringIndex+1 do flds:=flds+Chr(i-1)
    else flds:=PString(@PmenuChoice[CritInd-CPatt_User+1,0])^;
    AuthorAll:=true;
    nspec:=length(flds);
    for i:=1 to nspec do
    begin
      if (ord(flds[i])>0) and (ord(flds[i])<=fieldlast) then
          AuthorAll:=AuthorAll and FieldParams^[ord(flds[i])].AuthorLike
      else if (ord(flds[i])>0) and (ord(flds[i])=StringIndex) then
          AuthorAll:=false;
    end;

    xstart:=(ScrWidth-75) div 2 +1; fchanged:=false; retain:=true;
    SLen:=length(Crit);
    if CritInd=CPatt_AllFields then Title:='all fields'
    else Title:=PMenuStr[CritInd-CPatt_User+1]^;
    StrLwr(Title);
    ReadBig('Enter Pattern: ',Crit[1],Slen,
            ScrLen-9,xstart,6,75,[#0..#31]-[#21],fchanged,retain,253,
            true,CaseSen,Regexp,@Negate,true,AuthorAll,Title);
    if not retain then Exit;
    if SLen>255 then Slen:=255;
    Crit[0]:=Chr(SLen);
    ChrDelL(Crit,' '); ChrDelR(Crit,' ');
    if Prog7bit then SConv27Bit(Crit,AuthorAll)
    else if Prog8bit then SConv28Bit(Crit,AuthorAll);

    noper:=1; npatt:=1;
    Patrn[1]:=Crit; Field[1]:=flds;
    operation[1]:=1;
    Flag[1]:=0;
    if Negate  then Flag[1]:=Flag[1] or PattFlag_NOT;
    if CaseSen then Flag[1]:=Flag[1] or PattFlag_CaseSen;
    if RegExp  then Flag[1]:=Flag[1] or PattFlag_Regexp;
    on:=true;
    OneCritPattern:=true;
  end;
end;                             { OneCritPattern }

procedure About;
var                            
  l,fst,h,MaxWidth : integer;
  BaseRow: Byte;
  ch : char;
  tmp1,tmp2,tmp3 : string[132];

procedure GetWinVer(var VerStr: string);
var
  major,minor,wmode: byte;
  tmp: string;
begin
  major:=0; minor:=0; wmode:=0;
  asm
    mov ax, $160a
    int $2f
    cmp ax, 0
    jne @1
    mov major, bh
    mov minor, bl
    mov wmode, cl
@1:
  end;
  if (major=0) and (minor=0) then Exit;
  VerStr:='Windows ';
  Str(major,tmp); VerStr:=VerStr+tmp;
  Str(minor,tmp); VerStr:=VerStr+'.'+tmp;
  if wmode=3 then VerStr:=VerStr+' enhanced mode'
  else VerStr:=VerStr+' standard mode';
end;                                { GetWinVer }

procedure GetOS2Ver(var VerStr: string);
var
  axreg,vers: word;
  tmp: string;
begin
  vers:=0;
  asm
    mov ax, $4010
    int $21
    mov axreg, ax
    mov vers, bx
  end;
  if axreg=$4010 then exit;
  VerStr:='OS2';
  if axreg=0 then VerStr:=VerStr+' Warp';
  Str(Vers,tmp); VerStr:=VerStr+' '+tmp;
end;                                { GetOS2Ver }

procedure GetDVVer(Var VerStr: string);
var
  major,minor: byte;
  tmp: string;
begin
  major:=0; minor:=0;
  asm
    mov ax, $2b01
    mov bx, $0100
    mov cx, $4445
    mov dx, $5351
    int $21
    cmp al, $ff
    je @1
    mov major, bh
    mov minor, bl
@1:
  end;
  if (major=0) and (minor=0) then Exit;
  if (major=0) and (minor=2) then
  begin
    major:=2; minor:=0;
  end;
  VerStr:='DESQview ';
  Str(major,tmp); VerStr:=VerStr+tmp;
  Str(minor,tmp);
  if length(tmp)=1 then tmp:='0'+tmp;
  VerStr:=VerStr+'.'+tmp;
  if Virtualize_DV then VerStr:=VerStr+', virtualized';
end;                                { GetDVVer }

procedure GetDRDOSVer(var VerStr: string);
var
  regs: registers;
begin
  regs.ax:=$4452; regs.flags:=FCarry;
  intr($21,regs);
  if regs.flags AND FCarry<>0 then Exit;      { not DRDOS }
  if regs.ah=$10 then            { Single user }
  begin
    if regs.al=$60 then VerStr:='DOS Plus'
    else if regs.al=$63 then VerStr:='DR-DOS 3.41'
    else if regs.al=$64 then VerStr:='DR-DOS 3.42'
    else if regs.al=$65 then VerStr:='DR-DOS 5.00'
    else if regs.al=$67 then VerStr:='DR-DOS 6.00'
    else if regs.al=$70 then VerStr:='PalmDos'
    else if regs.al=$71 then VerStr:='DR-DOS 6.0 Update'
    else if regs.al=$72 then VerStr:='Novell DOS 7.0';
  end else
    VerStr:='Concurrent DOS';
end;

begin                               { About }
  if UseMouse then WaitForRelease(255);
  BaseRow:=5;
  tmp1:='BibDB - An interactive BibTeX database manager';
  tmp2:=Concat('Version ',ProgramVersion,', ',ProgramDate^);
  tmp3:='Written by Eyal Doron';
  MaxWidth:=48;
  MaxWidth:=imax(MaxWidth,length(tmp1)+4);
  l:=MaxWidth+2;
  fst:=(ScrWidth-MaxWidth) div 2;
  h:=11;
  if XmsExists then inc(h);
  if EmsExists then inc(h);
  if MultiTasking then inc(h);
  MakeWindow(BaseRow,fst,h,l,MessageNorm,MessageNorm,2,RNorm,shadow,1);
  MaxMemAvail;
  PrtWindow(1,(l-2-length(tmp1)) div 2+1,tmp1);
  PrtWindow(3,(l-2-length(tmp2)) div 2+1,tmp2);
  PrtWindow(5,(l-2-length(tmp3)) div 2+1,tmp3);
  tmp1:=''; tmp2:=''; tmp3:='';
  if XmsExists then
  begin
    Str(Xms_MaxAvail div K1,tmp1); ChrPadL(tmp1,' ',6);
    tmp1:=Concat('Available XMS memory: ',tmp1,' K.');
  end;
  if EmsExists then
  begin
    Str(Ems_MaxAvail div K1,tmp2); ChrPadL(tmp2,' ',6);
    tmp2:=Concat('Available EMS memory: ',tmp2,' K.');
  end;
  Str(MaxAvail,tmp3); ChrPadL(tmp3,' ',6);
  tmp3:=Concat('Available heap space: ',tmp3,' bytes.');
  h:=7;
  if tmp1<>'' then
  begin
    PrtWindow(h,(l-2-length(tmp3)) div 2+1,tmp1); inc(h);
  end;
  if tmp2<>'' then
  begin
    PrtWindow(h,(l-2-length(tmp3)) div 2+1,tmp2); inc(h);
  end;
  PrtWindow(h,(l-2-length(tmp3)) div 2+1,tmp3);

  if MultiTasking then
  begin
    tmp1:='unknown multitasker';
    case MultiTasker of
      DesqView:  GetDVVer(tmp1);
      DoubleDOS: tmp1:='DoubleDOS';
      Windows:   GetWinVer(tmp1);
      OS2:       GetOS2Ver(tmp1);
      NetWare:   tmp1:='NetWare';
      DRDOS:     GetDRDOSVer(tmp1);
      NoTasker:  tmp1:='';
    end;
    tmp1:='Running under '+tmp1+'.';
    h:=h+2;
    PrtWindow(h,(l-2-length(tmp1)) div 2+1,tmp1);
  end;
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor;
  end;
  CLB;
  ch := ReadKeyMouse; if ch=#0 then ch:=ReadKey;
  if UseMouse then HideMouseCursor;
  RemoveWindow;
  if UseMouse then WaitForRelease(255);
end;                                { About }

Procedure Preferences;
Const
  Nlabels = 15;
  IndexFileInd   = 1;  BuildIndexInd    = 2;  AutoCacheInd  = 3;
  BracesInd      = 4;
  AutoCapInd     = 5;  WrapInd          = 6;  StickyListInd = 7;
  AlwaysReadInd  = 8;  CheckDupInd      = 9;  PreambleInd   = 10;
  SortedByDefInd = 11; SortNewInd       = 12; AddSortEnvInd = 13;
  LabelModeInd   = 14; LabelTemplateInd = 15;
Var
  NalreadF,Nautocap,NSortNewFiles,accept,NSortingOn: Boolean;
  Nsticky,Esc,Enter,Space,change,NAutoBuildIndex: Boolean;
  NUseIndexFile,NUsePreamble,NAutoCache,NAutoSCache: boolean;
  NSortedByDefault,WasModified,NWrap,NStripExtraBraces: boolean;
  NAddSort2New: AddSort2NewType;
  AltPress: char;
  NLabelMode: LabelModeType;
  NLabelTemplate: string;
  NPreambleName: string;
  Ncheckdup: byte;
  wid,x0,y0,i,x,y,yy,MaxWid,Current,OCur,WinHeight,nbr: integer;
  xfirst,att: Byte;
  labels: array[1..Nlabels] of string[20];
  positions: array[1..Nlabels] of byte;
  ch: Char;
  line,tmp,spaces: string;

procedure GetPreambleName(Var S: string; y0,maxlen,linelen: Byte;
                          var accept,UsePreamble: boolean);
var
  xstart,xm,ym,i: integer;
  line: string;
  AltPress: char;
  xfirst,att: byte;
  first,OrigUsePreamble: boolean;
  OrigS: string;
begin
  OrigS:=S; OrigUsePreamble:=UsePreamble;
  if UseMouse then WaitForRelease(255);
  xstart:=(ScrWidth-linelen-2) div 2+1;
  first:=true;
  MakeWindow(y0,xstart,3,linelen+2,DialogNorm,DialogNorm,2,RNorm,Shadow,1);
  repeat
    AltPress:=#255;
    if UsePreamble then line:='[use Preamble]'#205#205#205#205#205#205
    else line:='[don''t use Preamble]';
    TitleWindow(4,DialogNorm,line);
    TpwAttr(y0+2,xstart+Pos('P',line)+1,1,1,EditBright);
    ReadEdit(' Preamble file: ',S,y0+1,xstart+1,maxlen,linelen,
             [#0..#255]-FileNameSet,'P',accept,AltPress,first);
    First:=false;
    if AltPress='P' then UsePreamble:=not UsePreamble
    else if AltPress=#255 then
    begin
      i:=length(line); line:='';
      xm:=Event.x-xstart; ym:=Event.y-y0;
      if (ym=2) and (xm>1) and (xm<i+2) then
          ReadScrStr(line,xm+xstart,ym+y0,xfirst,att,
            ['[','u','s','e',' ','P','r','a','m','b','l','d','o','n','t','''',']']);
      if (line='[use Preamble]') or (line='[don''t use Preamble]') then
        UsePreamble:=not UsePreamble;
    end;
  until AltPress=#0;
  RemoveWindow;
  if not accept then
  begin
    UsePreamble:=OrigUsePreamble; S:=OrigS;
  end;
end;                            { GetPreambleName }

begin
  MaxMemAvail;
  
  ncheckdup:=CheckDuplicate;
  nalreadF:=AlwaysRead;
  Nautocap:=UseAutoCap;
  Nsticky:=StickyList;
  NUseIndexFile:=UseIndexFile;
  NAutoBuildIndex:=AutoBuildIndex;
  NAutoCache:=AutoLoadCache;
  NAutoSCache:=AutoSaveCache;
  NAddSort2New:=AddSort2New;
  NSortNewFiles:=SortNewFiles;
  NSortedByDefault:=SortedByDefault;
  NLabelMode:=LabelMode;
  NLabelTemplate:=LabelTemplate^;
  NWrap:=WrapEOF2BOF;
  NStripExtraBraces:=StripExtraBraces;
  NUsePreamble:=UsePreamble; NPreambleName:=PreambleName^;

  labels[IndexFileInd]  :='UseIndexFile:';     positions[IndexFileInd]  :=2;
  labels[BuildIndexInd] :='AutoBuildIndex:';   positions[BuildIndexInd] :=3;
  labels[AutoCacheInd]  :='AutoCacheFiles:';   positions[AutoCacheInd]  :=4;
  
  labels[BracesInd]     :='HideExtraBraces:';  positions[BracesInd]     :=6;
  labels[AutoCapInd]    :='AutoCapitalize:';   positions[AutoCapInd]    :=7;
  labels[WrapInd]       :='WrapEOF2BOF:';      positions[WrapInd]       :=8;
  labels[StickyListInd] :='StickyList:';       positions[StickyListInd] :=9;

  labels[AlwaysReadInd] :='AlwaysReadFields:'; positions[AlwaysReadInd] :=11;
  labels[CheckDupInd]   :='CheckDuplicate:';   positions[CheckDupInd]   :=12;
  labels[PreambleInd]   :='Preamble file:';    positions[PreambleInd]   :=13;

  labels[SortedByDefInd]:='SortedByDefault';   positions[SortedByDefInd]:=15;
  labels[SortNewInd]    :='SortNewFiles:';     positions[SortNewInd]    :=16;
  labels[AddSortEnvInd] :='AddSortEnv:';       positions[AddSortEnvInd] :=17;

  labels[LabelModeInd]    :='LabelMode';       positions[LabelModeInd]    :=19;
  labels[LabelTemplateInd]:='LabelTemplate';   positions[LabelTemplateInd]:=20;

  MaxWid:=0;
  for i:=1 to Nlabels do if length(labels[i])>MaxWid then
                                 MaxWid:=length(labels[i]);
  wid:=70; y0:=2;
  x0:=(ScrWidth-wid) div 2 + 1;
  if ScrLen>25 then
  begin
    if ScrLen=28 then y0:=4
    else y0:=5;
  end;
  ChrFill(spaces,' ',80);
  WinHeight:=positions[Nlabels]+3;
  MakeWindow(y0,x0,WinHeight,wid,DialogNorm,DialogNorm,2,RNorm,Shadow,0);
  Titlewindow(2,DialogBright,'Preferences');
  TitleWindow(1,DialogNorm,'['+#254+']');
  TitleWindow(6,DialogNorm,'[ok]');
  if UseMouse then
  begin
    ShowMouseCursor;ShowMouseCursor;
    HideMouseCursor;
  end;
  for i:=1 to Nlabels do
    Tpwprint(y0+positions[i],x0+maxWid-length(Labels[i])+2,Labels[i],DialogBright);
  Current:=1; change:=true;
  Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
          length(labels[current]),DialogRev);
  WasModified:=false;
  repeat
    if change then
    begin
      if NUseIndexFile then tmp:='Use index files      '
      else                  tmp:='Don''t use index files';
      PStrCat(tmp,spaces,wid-MaxWid-5);
      Tpwprint(y0+positions[IndexFileInd],x0+MaxWid+3,tmp,DialogNorm);

      if NAutoBuildIndex then tmp:='Auto-build index files      '
      else                    tmp:='Don''t auto-build index files';
      PStrCat(tmp,spaces,wid-MaxWid-5);
      Tpwprint(y0+positions[BuildIndexInd],x0+MaxWid+3,tmp,DialogNorm);

      if NAutoCache and NAutoSCache then
        tmp:='Auto load and save cached entry lists'
      else if NAutoCache then
        tmp:='Auto load cached entry lists         '
      else if NAutoSCache then
        tmp:='Auto save cached entry lists         '
      else
        tmp:='Do not use cached entry list files   ';
      PStrCat(tmp,spaces,wid-MaxWid-5);
      Tpwprint(y0+positions[AutoCacheInd],x0+MaxWid+3,tmp,DialogNorm);

      if NStripExtraBraces then
        tmp:='Hide top-level extraneous braces      '
      else
        tmp:='Don''t hide top-level extraneous braces';
      Tpwprint(y0+positions[BracesInd],x0+MaxWid+3,tmp,DialogNorm);

      if nAutoCap then
           tmp:='Automatically capitalize specified fields'
      else tmp:='Leave fields as they are                 ';
      Tpwprint(y0+positions[AutoCapInd],x0+MaxWid+3,tmp,DialogNorm);

      if nsticky then
           tmp:='Start entry lists from current entry'
      else tmp:='Start entry lists from first entry  ';
      Tpwprint(y0+positions[StickyListInd],x0+MaxWid+3,tmp,DialogNorm);

      if NWrap then tmp:='Wrap around end-of-file      '
      else          tmp:='Don''t wrap around end-of-file';
      Tpwprint(y0+positions[WrapInd],x0+MaxWid+3,tmp,DialogNorm);

      if NcheckDup=AllowDuplicate then
        tmp:='Allow duplicate names                        '
      else if NcheckDup=DuplicateCaseOn then
        tmp:='No duplicate names, case sensitive           '
      else if NcheckDup=DuplicateCaseOff then
        tmp:='No duplicate names, case insensitive         '
      else if NcheckDup=DuplicateCaseWarn then
        tmp:='No duplicate names, warn of case similarities';
      Tpwprint(y0+positions[CheckDupInd],x0+MaxWid+3,tmp,DialogNorm);
      
      if NalreadF then
           tmp:='Always read the whole entry           '
      else tmp:='Read whole entries only when necessary';
      Tpwprint(y0+positions[AlwaysReadInd],x0+MaxWid+3,tmp,DialogNorm);

      if not NUsePreamble then tmp:='<none>'
      else tmp:=NPreambleName; CanonicalFname(tmp);
      TpwprintW(y0+positions[PreambleInd],x0+MaxWid+3,tmp+spaces,DialogNorm);
      
      if NSortedByDefault then tmp:='Files with no Sort env. are sorted  '
      else                     tmp:='Files with no Sort env. are unsorted';
      Tpwprint(y0+positions[SortedByDefInd],x0+MaxWid+3,tmp,DialogNorm);
      
      if NSortNewFiles then tmp:='Sort new files      '
      else                  tmp:='Don''t sort new files';
      Tpwprint(y0+positions[SortNewInd],x0+MaxWid+3,tmp,DialogNorm);

      case NAddSort2New of
        AddToNoNew:     tmp:='Don''t add Sort env. to new files ';
        AddToAllNew:    tmp:='Add Sort env. to all new files   ';
        AddToSortedNew: tmp:='Add Sort env. to sorted new files';
      end;
      Tpwprint(y0+positions[AddSortEnvInd],x0+MaxWid+3,tmp,DialogNorm);

      if NLabelMode=OffLabelMode         then tmp:='Manual                      '
      else if NLabelMode=VerifyLabelMode then tmp:='Automatic, with verification'
      else if NLabelMode=AutoLabelMode   then tmp:='Automatic                   ';
      Tpwprint(y0+positions[LabelModeInd],x0+MaxWid+3,tmp,DialogNorm);

      DecompTemplate(tmp,NLabelTemplate); tmp:=tmp+spaces;
      TpwprintW(y0+positions[LabelTemplateInd],x0+MaxWid+3,tmp,DialogNorm);
      
      change:=false;
    end;
    OCur:=Current;
    Esc:=False; Enter:=false; Space:=false;
    if UseMouse then
    begin
      WaitForRelease(255);
      ShowMouseCursor;
    end;
    ch:=ReadKeyMouse;
    if UseMouse then HideMouseCursor;
    if Event.mpress then                      { Mouse }
    begin
      x:=Event.x-x0; y:=Event.y-y0;
      yy:=0;
      if (y>0) and (x>0) and (x<60) then
        for i:=1 to Nlabels do if y=positions[i] then yy:=i;
      if yy>0 then
      begin
        if x>MaxWid then Space:=true;
        current:=yy;
      end else if (y>=0) and (y<=WinHeight) and (x>=0) and (x<=Wid) then
      begin
        tmp:='';
        ReadScrStr(tmp,x+x0,y+y0,xfirst,att,
                      ['[','o','k',#254,']'] );
        if tmp='[ok]' then Enter:=true
        else if tmp=Concat('[',#254,']') then Esc:=true;
      end;
    end else if ch=#0 then           { Arrows }
    begin
      ch:=ReadKey;
      if (ch=#72) then Dec(Current)
      else if (ch=#80) then Inc(Current)
      else if (ch=#59) then ContextHelp('Options Screen');
      if Current=0 then Current:=Nlabels
      else if Current=Nlabels+1 then Current:=1;
    end else                         { Others }
    begin
      if ch=#27 then Esc:=true
      else if ch=#13 then Enter:=true
      else if ch=' ' then Space:=true;
    end;
    if Current<>OCur then
    begin
      Tpwattr(y0+positions[OCur],x0+maxWid-length(Labels[OCur])+2,1,
              length(labels[OCur]),DialogBright);
      Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
              length(labels[current]),DialogRev);
    end;
    if space then
    begin
      if Current=IndexFileInd       then NUseIndexFile:=not NUseIndexFile
      else if Current=BuildIndexInd then NAutoBuildIndex:=not NAutoBuildIndex
      else if Current=BracesInd     then NStripExtraBraces:=not NStripExtraBraces
      else if Current=AutoCapInd    then Nautocap:=not NautoCap
      else if current=StickyListInd then Nsticky:=not Nsticky
      else if current=WrapInd       then NWrap:=not NWrap
      else if Current=AutoCacheInd  then
      begin
        if NAutoCache and NAutoSCache then
        begin
          NAutoCache:=false; NAutoSCache:=false;
        end else if NAutoCache then
        begin
          NAutoCache:=false; NAutoSCache:=true;
        end else if NAutoSCache then NAutoCache:=true
        else NAutoCache:=true;
      end else if Current=CheckDupInd then
      begin
        inc(NcheckDup);
        if NCheckDup>DuplicateCaseWarn then NcheckDup:=AllowDuplicate;
      end
      else if current=AlwaysReadInd then NalReadF:=not NalReadF
      else if current=PreambleInd then
      begin
        GetPreambleName(NPreambleName,Positions[current],
                        sizeof(string)-1,Wid,accept,NUsePreamble);
      end
      else if current=SortedByDefInd then NSortedByDefault:=not NSortedByDefault
      else if current=SortNewInd then NSortNewFiles:=not NSortNewFiles
      else if current=AddSortEnvInd then
      begin
        case NAddSort2New of
          AddToNoNew: NAddSort2New:=AddToSortedNew;
          AddToSortedNew: NAddSort2New:=AddToAllNew;
          AddToAllNew: NAddSort2New:=AddToNoNew;
        end;
      end else if current=LabelModeInd then
      begin
        if NLabelMode=OffLabelMode then NLabelMode:=VerifyLabelMode
        else if NLabelMode=VerifyLabelMode then NLabelMode:=AutoLabelMode
        else if NLabelMode=AutoLabelMode then NLabelMode:=OffLabelMode;
      end else if current=LabelTemplateInd then
      begin
        Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
                length(labels[current]),DialogBright);
        DecompTemplate(tmp,NLabelTemplate);
        repeat
          AltPress:=#0;
          ReadEdit('',tmp,Positions[current]+y0,x0+MaxWid+3,
                   255,Wid-(MaxWid+4),NameForbid-[lbrace,',','\',rbrace],
                   '',accept,AltPress,false);
          nbr:=ChrQty(tmp,lbrace)-ChrQty(tmp,rbrace);
          if accept and (nbr<>0) then ErrorMessage(' Unbalanced braces! ');
        until (not accept) or (nbr=0);
        TpwAttr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
                length(labels[current]),DialogRev);
        if accept then
        begin
          PrepareTemplate(tmp); NLabelTemplate:=tmp;
        end;
      end;
      
      change:=true;
    end;
    if change then WasModified:=true;
  until Enter or Esc;
  if Enter then
  begin
    CheckDuplicate := NcheckDup;
    AlwaysRead := NalReadF;
    UseAutoCap:=NautoCap;
    if NUseIndexFile<>UseIndexFile then
    begin
      UseIndexFile:=NUseIndexFile;
      CheckForIndexFile(bib,bibname);
    end;
    StickyList:=NSticky;
    AutoBuildIndex:=NAutoBuildIndex;
    AutoLoadCache:=NAutoCache;
    AutoSaveCache:=NAutoSCache;
    SortedByDefault:=NSortedByDefault;
    SortNewFiles:=NSortNewFiles;
    AddSort2New:=NAddSort2New;
    LabelMode:=NLabelMode;
    LabelTemplate^:=NLabelTemplate;
    WrapEOF2BOF:=NWrap;
    StripExtraBraces:=NStripExtraBraces;
    UsePreamble:=NUsePreamble; PreambleName^:=NPreambleName;
    if WasModified then OptionsModified.Preferences:=true;
  end;
  RemoveWindow;
  if UseMouse then WaitForRelease(255);
end;                                    { Preferences }

procedure EncodingsOptions;
const
  NLabels = 4;
  Prog_Mode = 1; Prog_Encoding = 2; File_Mode = 3; File_Encoding = 4;
var
  wid,x0,y0,i,j,x,xx,y,yy,MaxWid,Current,OCur,WinHeight,nspec,nbr: integer;
  xfirst,att,CForm: Byte;
  labels: array[1..Nlabels] of string[24];
  positions: array[1..Nlabels] of byte;
  ch,AltPress: Char;
  spaces,tmp: string;
  Change,Esc,Enter,Space,finish,accept,WasModified: boolean;
  List: ListArrPtr;
  Spec: SpecArr;
  {}
  ProgBits,FileBits: integer;
  Bits: array[1..3] of string;
  NProg8Bit,NProg7Bit,NFile8Bit,NFile7Bit: boolean;
  NDispEncoding,NFileEncoding,MaxEncLen: integer;
begin
  if EncodingsList.Count<3 then
  begin
    ErrorMessageRC(Str_NoEncodingsFound,''); Exit;
  end;
  if Prog8Bit then ProgBits:=3
  else if Prog7Bit then ProgBits:=2
  else ProgBits:=1;
  if File8Bit then FileBits:=3
  else if File7Bit then FileBits:=2
  else FileBits:=1;

  GetMem(list,(EncodingsList.Count+1)*sizeof(ListArrRec));
  MaxEncLen:=0;
  for i:=0 to EncodingsList.Count-1 do
  begin
    tmp:='';
    if PEncoding(EncodingsList.at(i))^.Comment<>Nil then
        tmp:=' '+PEncoding(EncodingsList.at(i))^.Comment^;
    List^[i+1]:=PEncoding(EncodingsList.at(i))^.Name^+tmp;
    if MaxEncLen<length(List^[i+1]) then MaxEncLen:=length(List^[i+1]);
  end;
  NDispEncoding:=DispEncoding+1;
  NFileEncoding:=FReadEncoding+1;
  if NFileEncoding<1 then NFileEncoding:=NDispEncoding;

  labels[Prog_Mode]    :='Mode:';     positions[Prog_Mode]    :=4;
  labels[Prog_Encoding]:='Encoding:'; positions[Prog_Encoding]:=5;
  
  labels[File_Mode]    :='Mode:';     positions[File_Mode]    :=9;
  labels[File_Encoding]:='Encoding:'; positions[File_Encoding]:=10;

  Bits[1]:='no translation             ';
  Bits[2]:='Use 7-bit TeX codes        ';
  Bits[3]:='Use the 8-bit character set';
  
  MaxWid:=0;
  for i:=1 to Nlabels do if length(labels[i])>MaxWid then
                                 MaxWid:=length(labels[i]);
  wid:=45; y0:=4;
  x0:=(ScrWidth-wid) div 2 + 1;
  if ScrLen>25 then y0:=5;
  ChrFill(spaces,' ',80);
  WinHeight:=positions[Nlabels]+3;
  MakeWindow(y0,x0,WinHeight,wid,DialogNorm,DialogNorm,2,RNorm,Shadow,0);
  TitleWindow(1,DialogNorm,'['+#254+']');
  TitleWindow(2,DialogNorm,'Multilingual Support');
  TitleWindow(6,DialogNorm,'[ok]');
  if UseMouse then
  begin
    ShowMouseCursor;ShowMouseCursor;
    HideMouseCursor;
  end;
  MaxMemAvail;

  for i:=1 to Nlabels do
    Tpwprint(y0+positions[i],x0+maxWid-length(Labels[i])+4,Labels[i],DialogBright);

  TpwPrint(y0+2,x0+2,'On the screen:',DialogBright);
  TpwPrint(y0+3,x0+2,'--------------',DialogBright);
  TpwPrint(y0+7,x0+2,'In files:',DialogBright);
  TpwPrint(y0+8,x0+2,'---------',DialogBright);
  Current:=1; change:=true;
  Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+4,1,
          length(labels[current]),DialogRev);

  WasModified:=false; Change:=true;
  repeat
    if change then
    begin
      TpwPrint(y0+positions[Prog_Mode],x0+MaxWid+5,Bits[ProgBits],DialogNorm);

      tmp:=List^[NDispEncoding]+spaces;
      TpwPrintW(y0+positions[Prog_Encoding],x0+MaxWid+5,tmp,DialogNorm);
      
      TpwPrint(y0+positions[File_Mode],x0+MaxWid+5,Bits[FileBits],DialogNorm);

      tmp:=List^[NFileEncoding]+spaces;
      TpwPrintW(y0+positions[File_Encoding],x0+MaxWid+5,tmp,DialogNorm);
    end;
    
    OCur:=Current;
    Esc:=False; Enter:=false; Space:=false;
    if UseMouse then
    begin
      WaitForRelease(255);
      ShowMouseCursor;
    end;
    ch:=ReadKeyMouse;
    if UseMouse then HideMouseCursor;
    if Event.mpress then                      { Mouse }
    begin
      x:=Event.x-x0; y:=Event.y-y0;
      yy:=0;
      if (y>0) and (x>0) and (x<60) then
        for i:=1 to Nlabels do if y=positions[i] then yy:=i;
      if yy>0 then
      begin
        if x>MaxWid then Space:=true;
        current:=yy;
      end else if (y>=0) and (y<=WinHeight) and (x>=0) and (x<=Wid) then
      begin
        tmp:='';
        ReadScrStr(tmp,x+x0,y+y0,xfirst,att,['[','o','k',#254,']'] );
        if tmp='[ok]' then Enter:=true
        else if tmp=Concat('[',#254,']') then Esc:=true;
      end;
    end else if ch=#0 then           { Arrows and Alt keys }
    begin
      ch:=ReadKey;
      if (ch=#72) then Dec(Current)
      else if (ch=#80) then Inc(Current)
      else if (ch=#59) then ContextHelp('Options Screen');
      if Current=0 then Current:=Nlabels
      else if Current=Nlabels+1 then Current:=1;
    end else                         { Others }
    begin
      if ch=#27 then Esc:=true
      else if ch=#13 then Enter:=true
      else if ch=' ' then Space:=true;
    end;
    if Current<>OCur then
    begin
      Tpwattr(y0+positions[OCur],x0+maxWid-length(Labels[OCur])+4,1,
              length(labels[OCur]),DialogBright);
      Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+4,1,
              length(labels[current]),DialogRev);
    end;
    
    if space then
    begin
      x:=x0+MaxWid+3;
      y:=Positions[current]+y0;

      if current=Prog_Mode then
      begin
        inc(ProgBits); if ProgBits>3 then ProgBits:=1;
      end else if current=Prog_Encoding then
      begin
        nspec:=0; Spec[1]:=NDispEncoding;
        FieldChoose(List^,EncodingsList.count,1,
                    MaxEncLen+1,Spec,nspec,
                    true,false,1,0,true,true);
        if nspec>0 then NDispEncoding:=spec[1];
      end else if current=File_Mode then
      begin
        inc(FileBits); if FileBits>3 then FileBits:=1;
      end else if current=File_Encoding then
      begin
        nspec:=0; Spec[1]:=NFileEncoding;
        FieldChoose(List^,EncodingsList.count,1,
                    MaxEncLen+1,Spec,nspec,
                    true,false,1,0,true,true);
        if nspec>0 then NFileEncoding:=spec[1];
      end;
      change:=true;
    end;
    if change then WasModified:=true;
  until Enter or Esc;
  RemoveWindow;
  FreeMem(list,(EncodingsList.Count+1)*sizeof(ListArrRec));
  if Enter then
  begin
    Prog8Bit:=(ProgBits=3);
    Prog7Bit:=(ProgBits=2);
    File8Bit:=(FileBits=3);
    File7Bit:=(FileBits=2);
    DispEncoding:=NDispEncoding-1;
    FReadEncoding:=NFileEncoding-1;
    HighBits(DispEncoding,FReadEncoding,-1);
    if WasModified then OptionsModified.Preferences:=true;
  end;
  if UseMouse then WaitForRelease(255);
end;                           { EncodingsOptions }

procedure FileFormatOptions;
const
  Nlabels = 10;
  LBibVerify = 1; LBibWidth = 2;
  LTibVerify = 3; LTibWidth = 4; LTibLabel = 5; LTibMacros = 6;
  LRefVerify = 7; LRefWidth = 8; LRefLabel = 9; 
  LComVerify = 10;
  FVers: array[1..LastImportFormat] of byte = (1,10,3,7);
  FWids: array[1..LastImportFormat] of byte = (2,0,4,8);
Var
  wid,x0,y0,i,j,x,xx,y,yy,MaxWid,Current,OCur,WinHeight,nspec,nbr: integer;
  xfirst,att,Skip,CForm: Byte;
  labels: array[1..Nlabels] of string[24];
  positions: array[1..Nlabels] of byte;
  ch,AltPress: Char;
  spaces,tmp: string;
  Change,Esc,Enter,Space,finish,accept,WasModified: boolean;
  NTibLabels,NReferLabels: string;
  NTibMacros: TibMacrosType;
  NVerify: array[1..LastImportFormat] of VerificationType;
  NWidth: array[1..LastImportFormat] of longint;

begin                                    { SortOptions }

  NTibLabels:=TibLabels; NReferLabels:=ReferLabels;
  NTibMacros:=TibMacros;
  for i:=1 to LastImportFormat do
  begin
    NVerify[i]:=Verify[i]; NWidth[i]:=LineWidth[i];
  end;

  labels[LBibVerify]:='BibTeX - Import Verify:'; positions[LBibVerify]:=2;
  labels[LBibWidth] :=          'Max line len:'; positions[LBibWidth] :=3;
  
  labels[LTibVerify]:='Tib    - Import Verify:'; positions[LTibVerify]:=5;
  labels[LTibWidth] :=          'Max line len:'; positions[LTibWidth] :=6;
  labels[LTibLabel] :=          'Label Fields:'; positions[LTibLabel] :=7;
  labels[LTibMacros]:=                'Macros:'; positions[LTibMacros]:=8;
  
  labels[LRefVerify]:='Refer  - Import Verify:'; positions[LRefVerify]:=10;
  labels[LRefWidth] :=          'Max line len:'; positions[LRefWidth] :=11;
  labels[LRefLabel] :=          'Label Fields:'; positions[LRefLabel] :=12;
  
  labels[LComVerify]:='Comma  - Import Verify:'; positions[LComVerify]:=14;
  MaxWid:=0;
  for i:=1 to Nlabels do if length(labels[i])>MaxWid then
                                 MaxWid:=length(labels[i]);
  wid:=60; y0:=4;
  x0:=(ScrWidth-wid) div 2 + 1;
  if ScrLen>25 then y0:=5;
  ChrFill(spaces,' ',80);
  WinHeight:=positions[Nlabels]+3;
  MakeWindow(y0,x0,WinHeight,wid,DialogNorm,DialogNorm,2,RNorm,Shadow,0);
  TitleWindow(1,DialogNorm,'['+#254+']');
  TitleWindow(2,DialogNorm,'Specific File Format Options');
  TitleWindow(6,DialogNorm,'[ok]');
  if UseMouse then
  begin
    ShowMouseCursor;ShowMouseCursor;
    HideMouseCursor;
  end;
  MaxMemAvail;

  for i:=1 to Nlabels do
    Tpwprint(y0+positions[i],x0+maxWid-length(Labels[i])+2,Labels[i],DialogBright);
  Current:=1; change:=true;
  Skip:=Pos(' - ',Labels[current]); if Skip>0 then Skip:=Skip+2;
  Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2+Skip,1,
          length(labels[current])-Skip,DialogRev);

  WasModified:=false;
  repeat
    if change then
    begin

      for i:=1 to LastImportFormat do
      begin
        if NVerify[i]=VerifyOff then        tmp:='Off        '
        else if NVerify[i]=VerifyLabel then tmp:='Labels only'
        else if NVerify[i]=VerifyEntry then tmp:='On         ';
        Tpwprint(y0+positions[FVers[i]],x0+MaxWid+3,tmp,DialogNorm);

        if Fwids[i]>0 then
          TpwPrint(y0+positions[FWids[i]],x0+MaxWid+3,
            num2str(NWidth[i])+'            ',DialogNorm);
      end;

      tmp:='';
      for i:=1 to length(NTibLabels) do
      begin
        if tmp<>'' then tmp:=tmp+',';
        tmp:=tmp+'%'+NTibLabels[i];
      end;
      tmp:=tmp+spaces; StrCut(tmp,wid-(MaxWid+4));      
      Tpwprint(y0+positions[LTibLabel],x0+MaxWid+3,tmp,DialogNorm);

      if NTibMacros=NotImpOrExp then
        tmp:='No conversion                '
      else if NTibMacros=ImpOnly then
        tmp:='Convert Tib -> BibTeX macros '
      else if NTibMacros=ExpOnly then
        tmp:='Convert Tib <- BibTeX macros '
      else
        tmp:='Convert Tib <-> BibTeX macros';
      Tpwprint(y0+positions[LTibMacros],x0+MaxWid+3,tmp,DialogNorm);

      tmp:='';
      for i:=1 to length(NReferLabels) do
      begin
        if tmp<>'' then tmp:=tmp+',';
        tmp:=tmp+'%'+NReferLabels[i];
      end;
      tmp:=tmp+spaces; StrCut(tmp,wid-(MaxWid+4));      
      Tpwprint(y0+positions[LRefLabel],x0+MaxWid+3,tmp,DialogNorm);

      change:=false;
    end;
    OCur:=Current;
    Esc:=False; Enter:=false; Space:=false;
    if UseMouse then
    begin
      WaitForRelease(255);
      ShowMouseCursor;
    end;
    ch:=ReadKeyMouse;
    if UseMouse then HideMouseCursor;
    if Event.mpress then                      { Mouse }
    begin
      x:=Event.x-x0; y:=Event.y-y0;
      yy:=0;
      if (y>0) and (x>0) and (x<60) then
        for i:=1 to Nlabels do if y=positions[i] then yy:=i;
      if yy>0 then
      begin
        if x>MaxWid then Space:=true;
        current:=yy;
      end else if (y>=0) and (y<=WinHeight) and (x>=0) and (x<=Wid) then
      begin
        tmp:='';
        ReadScrStr(tmp,x+x0,y+y0,xfirst,att,['[','o','k',#254,']'] );
        if tmp='[ok]' then Enter:=true
        else if tmp=Concat('[',#254,']') then Esc:=true;
      end;
    end else if ch=#0 then           { Arrows and Alt keys }
    begin
      ch:=ReadKey;
      if (ch=#72) then Dec(Current)
      else if (ch=#80) then Inc(Current)
      else if (ch=#59) then ContextHelp('Options Screen');
      if Current=0 then Current:=Nlabels
      else if Current=Nlabels+1 then Current:=1;
    end else                         { Others }
    begin
      if ch=#27 then Esc:=true
      else if ch=#13 then Enter:=true
      else if ch=' ' then Space:=true;
    end;
    if Current<>OCur then
    begin
      Tpwattr(y0+positions[OCur],x0+maxWid-length(Labels[OCur])+2,1,
              length(labels[OCur]),DialogBright);
      Skip:=Pos(' - ',Labels[current]); if Skip>0 then Skip:=Skip+2;
      Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2+Skip,1,
              length(labels[current])-Skip,DialogRev);
    end;
    
    if space then
    begin
      x:=x0+MaxWid+3;
      y:=Positions[current]+y0;
      if Current<LTibVerify      then CForm:=BibTeXFormat
      else if Current<LRefVerify then CForm:=TibFormat
      else if Current<LComVerify then CForm:=ReferFormat
      else                            CForm:=CommaDelimited;
      
      if current in [LBibVerify,LTibVerify,LRefVerify,LComVerify] then
      begin
        if NVerify[CForm]=VerifyEntry then
           NVerify[CForm]:=VerifyOff
        else NVerify[CForm]:=Succ(NVerify[CForm]);
      end else if current in [LBibWidth,LTibWidth,LRefWidth] then
      begin
        tmp:=num2str(NWidth[CForm]);
        Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
                length(labels[current]),DialogBright);
        AltPress:=#0;
        ReadEdit('',tmp,y,x,5,5,[#0..#255]-['0'..'9'],
                 '',accept,AltPress,false);
        Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
                length(labels[current]),DialogRev);
        if accept then
        begin
          Val(tmp,i,j); if j=0 then NWidth[CForm]:=i;
        end;
      end else if Current=LTibLabel then
      begin
        tmp:='';
        for i:=1 to length(NTibLabels) do
        begin
          if tmp<>'' then tmp:=tmp+',';
          tmp:=tmp+'%'+NTibLabels[i];
        end;
        Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
                length(labels[current]),DialogBright);
        AltPress:=#0;
        ReadEdit('',tmp,y,x,255,Wid-(MaxWid+4),[#0..#255]-
                ['A'..'Z','a'..'z','%',',',' ','\'],'',accept,AltPress,false);
        Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
                length(labels[current]),DialogRev);
        if accept then
        begin
          ChrDel(tmp,'%'); ChrDel(tmp,' '); ChrDel(tmp,',');
          NTibLabels:=tmp;
        end;
      end else if current=LTibMacros then
      begin
        if NTibMacros=ImpAndExp then NTibMacros:=NotImpOrExp
        else NTibMacros:=Succ(NTibMacros);
      end else if current=LRefLabel then
      begin
        tmp:='';
        for i:=1 to length(NReferLabels) do
        begin
          if tmp<>'' then tmp:=tmp+',';
          tmp:=tmp+'%'+NReferLabels[i];
        end;
        i:=(ScrWidth-52) div 2;
        Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
                length(labels[current]),DialogBright);
        AltPress:=#0;
        ReadEdit('',tmp,y,x,255,Wid-(MaxWid+4),[#0..#255]-
                ['A'..'Z','a'..'z','%',',',' ','\'],'',accept,AltPress,false);
        Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
                length(labels[current]),DialogRev);
        if accept then
        begin
          ChrDel(tmp,'%'); ChrDel(tmp,' '); ChrDel(tmp,',');
          StrUpr(tmp);
          NReferLabels:=tmp;
        end;
      end;
      change:=true;
    end;
    if change then WasModified:=true;
  until Enter or Esc;
  if Enter then
  begin
    TibLabels:=NTibLabels; ReferLabels:=NReferLabels;
    TibMacros:=NTibMacros;
    for i:=1 to LastImportFormat do
    begin
      Verify[i]:=NVerify[i]; LineWidth[i]:=NWidth[i];
    end;
    if WasModified then OptionsModified.Formats:=true;
  end;
  RemoveWindow;
  if UseMouse then WaitForRelease(255);
end;                                    { FileFormatOptions }




end.
