/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     January 2002
 *
 */

#include  <stdio.h>
#include  <string.h>
#include  <gtk/gtk.h>

#define  SIZE  20


GtkWidget  *searchlabel, *searchword;
GtkWidget  *text, *textblock, *scrollblock;
GtkWidget  *summary;
GtkTextBuffer  *textpad;
GtkTextIter  iter;

char  holder[200], temp[200], report[30], seek[100];
char  type[20], tag[30], title[100];

void  alluplinks(GtkWidget *widget)
{
  GtkTooltips  *tooltips;
  GtkWidget  *window, *panel, *description, *selector, *controls;
  GtkWidget  *key0, *key1;

  extern  void  close_window(GtkWidget *);    /* defined in file cleanup.c */
  void  put_all_uplinks();

  tooltips = gtk_tooltips_new();

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL); 
  gtk_window_set_title(GTK_WINDOW(window), "XBibFile inspect");
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_window_set_default_size(GTK_WINDOW(window), 300, 470);
  panel = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), panel);
  description = gtk_label_new("All dependency fields in database");
  gtk_box_pack_start(GTK_BOX(panel), description, FALSE, TRUE, 10);

                          /* create the text display part of the window */
  textblock = gtk_scrolled_window_new(NULL, NULL);
  textpad = gtk_text_buffer_new(NULL);
  text = gtk_text_view_new_with_buffer(textpad);
  gtk_container_add(GTK_CONTAINER(textblock), text);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(textblock),
                                 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start_defaults(GTK_BOX(panel), textblock); 

                           /* put the window control buttons in place */
  controls = gtk_hbox_new(FALSE, 0);
  key0 = gtk_button_new_with_label("CANCEL");
  gtk_widget_set_usize(GTK_WIDGET(key0), 90, -1);
  g_signal_connect(GTK_OBJECT(key0), "clicked",
                   G_CALLBACK(close_window), NULL);
  gtk_tooltips_set_tip(tooltips, key0,
                       "Finish this reference probe", NULL);
  gtk_box_pack_end(GTK_BOX(controls), key0, FALSE, FALSE, 10);
                           /* and put the summary line in place */
  summary = gtk_entry_new();
  gtk_editable_set_editable(GTK_EDITABLE(summary), FALSE);
  gtk_widget_set_usize(GTK_WIDGET(summary), 150, 20);
  gtk_box_pack_start(GTK_BOX(controls), summary, FALSE, FALSE, 10);
  gtk_box_pack_end(GTK_BOX(panel), controls, FALSE, TRUE, 20);

                          /* now put the 'style' for the text output */
  gtk_text_buffer_create_tag(textpad, "blackface",
                             "foreground", "black", NULL);
  gtk_text_buffer_create_tag(textpad, "emphasis",
                             "foreground", "red", NULL);
  gtk_text_buffer_create_tag(textpad, "target",
                             "foreground", "green", NULL);
  gtk_text_buffer_create_tag(textpad, "point",
                             "size", 11 * PANGO_SCALE, NULL);
  gtk_text_buffer_create_tag(textpad, "font",
                             "style", PANGO_STYLE_NORMAL, NULL);

  put_all_uplinks(widget);

                          /* put the composite window on the screen */
  gtk_widget_show_all(window);
}



/* This procedure performs the searching of the BibTeX database and returns
 * its results to the text window created in the procedure  alluplinks()  above
 */

void  put_all_uplinks(GtkWidget *widget)
{
  int  i, count, flag, k, pass;
  char  *start, *end;
  struct tag_list {
            char  item[90];
	    int   total;
	 };
  struct tag_list  links[20];

  extern  void  error();                      /* defined in file error.c */
  extern  FILE  *refFile;                     /* defined in xbibfile.c */


                           /* first, find all the uplink fields present */
  i = 0;
  count = 0;
  rewind(refFile);
  gtk_text_buffer_get_iter_at_offset(textpad, &iter, 0);
  while ( ( holder[i] = getc(refFile) ) != EOF )  {
    if ( holder[i] == '\n' )  {
      holder[i+1] = '\0';
      i = 0;
	                   /* if the line starts with 'uplink = {' */
      if ( start = strstr(holder, "  uplink = {") )  {
        end = strstr(holder, "}");
        *end = '\0';
	                   /* find where this uplink is to be stored */
	flag = 0;
	for (k=0; k<count; k++) 
	  if ( strstr(links[k].item, start+12) )  {
	    links[k].total++;
	    flag = 1;
	  }
	if ( !flag )  {
	  strcpy(links[count].item, start+12);
	  links[count].total = 1;
	  count++;
	}
      }
    }
    i++;
  }
                           /* display all the uplanks and their sources */
  for (k=0; k<count; k++)  {
    i = 0;
    rewind(refFile);
    gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
                links[k].item, -1,
		"emphasis", "point", "font", NULL);
    gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
                "\n", -1,
		"blackface", "point", "font", NULL);
    while ( ( holder[i] = getc(refFile) ) != EOF )  {
      if ( holder[i] == '\n' )  {
        holder[i+1] = '\0';
        i = 0;
                           /* if the line starts with '@' */
        if ( holder[1] == '@' ) 
          if ( start = strstr(holder, "{") )
	    if ( end = strstr(holder, ",") )  {
	      *end = '\0';
	      strcpy(tag, start+1);
	    }
	    else {
	      error(widget, GINT_TO_POINTER(9));
	      g_print("Format error found in BibTeX file - no terminating ,");
	    }
	  else  {
	    error(widget, GINT_TO_POINTER(9));
	    g_print("Format error found in BibTeX file - no { after @");
	  }
	                   /* if the line starts with 'uplink = {' */
        if ( start = strstr(holder, "  uplink = {") )  {
          end = strstr(holder, "}");
          *end = '\0';
	  strcpy(temp, start+12);
	  if ( strstr(links[k].item, start+12) )  {
	    gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                "    ", -1,
			"blackface", "point", "font", NULL);
	    gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                tag, -1,
			"blackface", "point", "font", NULL);
	    gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                "\n", -1,
			"blackface", "point", "font", NULL);
	  }
	}
      }
      i++;
    }
  }
  sprintf(report, "%d link chains found", count);
  gtk_entry_set_text(GTK_ENTRY(summary), report);
}
