/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pudl;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.pudl.Destination;
import de.tu_darmstadt.sp.pudl.FitBDestination;
import de.tu_darmstadt.sp.pudl.FitBHDestination;
import de.tu_darmstadt.sp.pudl.FitBVDestination;
import de.tu_darmstadt.sp.pudl.FitDestination;
import de.tu_darmstadt.sp.pudl.FitHDestination;
import de.tu_darmstadt.sp.pudl.FitRDestination;
import de.tu_darmstadt.sp.pudl.FitVDestination;
import de.tu_darmstadt.sp.pudl.NamedDestination;
import de.tu_darmstadt.sp.pudl.UnknownDestination;
import de.tu_darmstadt.sp.pudl.XYZDestination;

public class DestinationFactory {
    static DestinationFactory currentFactory = new DestinationFactory();

    public static Destination createDestination(PDFObject obj) {
        return DestinationFactory.getFactory().doCreateDestination(obj);
    }

    protected Destination doCreateDestination(PDFObject obj) {
        if (obj instanceof PDFName) {
            return new NamedDestination((PDFName)obj);
        }
        if (obj instanceof PDFArray) {
            PDFArray arr = (PDFArray)obj;
            PDFName subtype = (PDFName)arr.get(1);
            if (subtype.equals(PDFName.XYZ)) {
                return new XYZDestination(arr);
            }
            if (subtype.equals(PDFName.FIT)) {
                return new FitDestination(arr);
            }
            if (subtype.equals(PDFName.FITB)) {
                return new FitBDestination(arr);
            }
            if (subtype.equals(PDFName.FITBH)) {
                return new FitBHDestination(arr);
            }
            if (subtype.equals(PDFName.FITBV)) {
                return new FitBVDestination(arr);
            }
            if (subtype.equals(PDFName.FITH)) {
                return new FitHDestination(arr);
            }
            if (subtype.equals(PDFName.FITR)) {
                return new FitRDestination(arr);
            }
            if (subtype.equals(PDFName.FITV)) {
                return new FitVDestination(arr);
            }
            return new UnknownDestination(arr);
        }
        return null;
    }

    public static DestinationFactory getFactory() {
        return currentFactory;
    }

    public static void setFactory(DestinationFactory factory) {
        currentFactory = factory;
    }
}

