/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.widget.AdvancedLabel;
import megamek.client.ui.Messages;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.actions.EntityAction;
import megamek.common.actions.TriggerAPPodAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerAPPodDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = 161017051720020010L;
    private Button butOkay = new Button(Messages.getString("Okay"));
    private AdvancedLabel labMessage;
    private Vector<TriggerPodTracker> trackers = new Vector();
    private int entityId = -1;

    public TriggerAPPodDialog(Frame frame, Entity entity) {
        super(frame, Messages.getString("TriggerAPPodDialog.title"), true);
        Serializable serializable;
        this.entityId = entity.getId();
        this.labMessage = new AdvancedLabel(Messages.getString("TriggerAPPodDialog.selectPodsToTrigger", new Object[]{entity.getDisplayName()}));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 1));
        for (Mounted serializable22 : entity.getMisc()) {
            if (!serializable22.getType().hasFlag(0x800000L)) continue;
            serializable = new StringBuffer();
            serializable.append(entity.getLocationName(serializable22.getLocation())).append(" ").append(serializable22.getName());
            Checkbox bl = new Checkbox(serializable.toString());
            panel.add(bl);
            if (serializable22.canFire()) {
                TriggerPodTracker triggerPodTracker = new TriggerPodTracker(bl, entity.getEquipmentNum(serializable22));
                this.trackers.addElement(triggerPodTracker);
                continue;
            }
            bl.setEnabled(false);
        }
        this.butOkay.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labMessage, gridBagConstraints);
        this.add(this.labMessage);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.add(this.butOkay);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TriggerAPPodDialog.this.setVisible(false);
            }
        });
        this.pack();
        serializable = this.getSize();
        boolean bl = false;
        if (((Dimension)serializable).width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            ((Dimension)serializable).width = GUIPreferences.getInstance().getMinimumSizeWidth();
        }
        if (((Dimension)serializable).height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            ((Dimension)serializable).height = GUIPreferences.getInstance().getMinimumSizeHeight();
        }
        if (bl) {
            this.setSize((Dimension)serializable);
            serializable = this.getSize();
        }
        this.setResizable(false);
        this.setLocation(frame.getLocation().x + frame.getSize().width / 2 - ((Dimension)serializable).width / 2, frame.getLocation().y + frame.getSize().height / 2 - ((Dimension)serializable).height / 2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public Enumeration<EntityAction> getActions() {
        Vector<TriggerAPPodAction> vector = new Vector<TriggerAPPodAction>();
        Enumeration<TriggerPodTracker> enumeration = this.trackers.elements();
        while (enumeration.hasMoreElements()) {
            TriggerPodTracker triggerPodTracker = enumeration.nextElement();
            if (!triggerPodTracker.isTriggered()) continue;
            vector.addElement(new TriggerAPPodAction(this.entityId, triggerPodTracker.getNum()));
        }
        return vector.elements();
    }

    private class TriggerPodTracker {
        private int podNum = -1;
        private Checkbox checkbox = null;

        public TriggerPodTracker(Checkbox checkbox, int n) {
            this.podNum = n;
            this.checkbox = checkbox;
        }

        public boolean isTriggered() {
            return this.checkbox.getState();
        }

        public int getNum() {
            return this.podNum;
        }
    }
}

