/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.boardview3d.ArrowModel;
import megamek.client.ui.AWT.boardview3d.BoardModel;
import megamek.client.ui.AWT.boardview3d.C;
import megamek.client.ui.AWT.boardview3d.LabelModel;
import megamek.client.ui.AWT.boardview3d.ViewTransform;
import megamek.client.ui.Messages;
import megamek.common.IHex;
import megamek.common.MoveStep;
import megamek.common.Tank;

class MoveStepModel
extends ArrowModel {
    public MoveStepModel(MoveStep moveStep, int n, IHex iHex, ViewTransform viewTransform) {
        StringBuffer stringBuffer;
        Color color;
        switch (moveStep.getMovementType()) {
            case 2: 
            case 5: {
                if (moveStep.isUsingMASC()) {
                    color = GUIPreferences.getInstance().getColor("AdvancedMoveMASCColor");
                    break;
                }
                color = GUIPreferences.getInstance().getColor("AdvancedMoveRunColor");
                break;
            }
            case 3: {
                color = GUIPreferences.getInstance().getColor("AdvancedMoveJumpColor");
                break;
            }
            case -1: {
                color = GUIPreferences.getInstance().getColor("AdvancedMoveIllegalColor");
                break;
            }
            default: {
                color = moveStep.getType() == 2 ? GUIPreferences.getInstance().getColor("AdvancedMoveBackColor") : GUIPreferences.getInstance().getColor("AdvancedMoveDefaultColor");
            }
        }
        Color3f color3f = new Color3f(color);
        Appearance appearance = new Appearance();
        appearance.setMaterial(new Material(color3f, C.black, color3f, C.white, 64.0f));
        appearance.setColoringAttributes(new ColoringAttributes(color3f, 2));
        appearance.setPolygonAttributes(C.noCull);
        appearance.setLineAttributes(C.defLine);
        Shape3D shape3D = new Shape3D((Geometry)polygon, appearance);
        Shape3D shape3D2 = new Shape3D((Geometry)border, appearance);
        this.anim.addChild((Node)shape3D);
        this.anim.addChild((Node)shape3D2);
        String string = null;
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.addChild((Node)this.anim);
        Transform3D transform3D = new Transform3D();
        double d = 0.0;
        switch (moveStep.getType()) {
            case 26: {
                string = moveStep.getParent().getEntity().getMovementMode() == 15 ? Messages.getString("BoardView1.WIGEClimbOff") : Messages.getString("BoardView1.ClimbOff");
                if (moveStep.isPastDanger()) {
                    string = "(" + string + ")";
                }
                this.anim.removeChild((Node)shape3D);
            }
            case 6: 
            case 21: 
            case 24: 
            case 28: 
            case 29: {
                transform3D.rotX(-1.5707963267948966);
                break;
            }
            case 25: {
                string = moveStep.getParent().getEntity().getMovementMode() == 15 ? Messages.getString("BoardView1.WIGEClimb") : Messages.getString("BoardView1.Climb");
                if (moveStep.isPastDanger()) {
                    string = "(" + string + ")";
                }
                this.anim.removeChild((Node)shape3D);
            }
            case 5: 
            case 20: {
                transform3D.rotX(1.5707963267948966);
                break;
            }
            case 16: {
                transformGroup.removeChild((Node)this.anim);
                string = Messages.getString("BoardView1.Load");
                if (!moveStep.isPastDanger()) break;
                string = "(" + string + ")";
                break;
            }
            case 17: {
                transformGroup.removeChild((Node)this.anim);
                string = Messages.getString("BoardView1.Unload");
                if (!moveStep.isPastDanger()) break;
                string = "(" + string + ")";
                break;
            }
            case 3: 
            case 4: {
                this.anim.removeChild((Node)shape3D);
                d = 5.0;
                transform3D.rotZ(-1.0471975511965976 * (double)moveStep.getFacing());
                break;
            }
            default: {
                d = -10.0;
                transform3D.rotZ(-1.0471975511965976 * (double)moveStep.getFacing());
            }
        }
        Vector3d vector3d = new Vector3d(0.0, d, -6.0 - (double)n * 0.1);
        transform3D.transform(vector3d);
        transform3D.setTranslation(vector3d);
        if (string == null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(moveStep.getMpUsed());
            if (moveStep.isOnlyPavement() && moveStep.getParent().getEntity() instanceof Tank) {
                stringBuffer.append("+");
            }
            if (moveStep.isDanger()) {
                stringBuffer.append("*");
            }
            if (moveStep.isPastDanger()) {
                stringBuffer.insert(0, "(");
                stringBuffer.append(")");
            }
            if (moveStep.isUsingMASC()) {
                stringBuffer.append("[");
                stringBuffer.append(moveStep.getTargetNumberMASC());
                stringBuffer.append("+]");
            }
            if (moveStep.getMovementType() == 4 || moveStep.getMovementType() == 5 || moveStep.getMovementType() == 6 || moveStep.getMovementType() == 7 || moveStep.getElevation() != 0) {
                stringBuffer.append("{").append(moveStep.getElevation()).append("}");
            }
            string = stringBuffer.toString();
        }
        transformGroup.setTransform(transform3D);
        stringBuffer = new Vector3d((Tuple3d)BoardModel.getHexLocation(moveStep.getPosition(), moveStep.getElevation() + iHex.getElevation() + 1));
        ((Vector3d)stringBuffer).z += 6.0 + (double)n * 0.1;
        TransformGroup transformGroup2 = new TransformGroup(new Transform3D(C.nullRot, (Vector3d)stringBuffer, 1.0));
        transformGroup2.addChild(viewTransform.makeViewRelative((Node)new LabelModel(string, C.black, color3f, LabelModel.BIGBOLD), (double)n * 0.1));
        transformGroup2.addChild((Node)transformGroup);
        this.addChild((Node)transformGroup2);
    }
}

