/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.IGame;

public class BattleArmorEncoder {
    public static void encode(Entity entity, Writer writer) throws IOException {
        BattleArmor battleArmor = (BattleArmor)entity;
        if (null == entity) {
            throw new IllegalArgumentException("The entity is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<bv value=\"");
        int n = (int)((double)battleArmor.calculateBattleValue() / battleArmor.getCrew().getBVSkillMultiplier());
        writer.write(n);
        writer.write("\" /><shootingStrength value=\"");
        n = battleArmor.getShootingStrength();
        writer.write(String.valueOf(n));
        writer.write("\" />");
    }

    public static Entity decode(ParsedXML parsedXML, IGame iGame) {
        BattleArmor battleArmor = null;
        if (null == parsedXML) {
            throw new IllegalArgumentException("The BattleArmor node is null.");
        }
        String string = parsedXML.getAttribute("name");
        if (!parsedXML.getName().equals("class") || null == string || !string.equals("BattleArmor")) {
            throw new IllegalStateException("Not passed an BattleArmor node.");
        }
        battleArmor = new BattleArmor();
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            String string2 = parsedXML2.getName();
            if (null == string2 || !string2.equals("shootingStrength")) continue;
            string = parsedXML2.getAttribute("value");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode the shootingStrength for an BattleArmor unit.");
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Couldn't get an integer from " + string);
            }
            n = battleArmor.locations() - n - 1;
            battleArmor.autoSetInternal();
            for (int i = 1; i <= n; ++i) {
                battleArmor.setInternal(-1, battleArmor.locations() - i);
            }
            battleArmor.applyDamage();
        }
        return battleArmor;
    }
}

