/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Soundscape;

public class SoundscapeState
extends LeafState {
    private int boundingLeaf;
    private int auralAttributes;

    public SoundscapeState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)((Soundscape)this.node).getApplicationBoundingLeaf()));
        this.control.writeBounds(dataOutput, ((Soundscape)this.node).getApplicationBounds());
        dataOutput.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)((Soundscape)this.node).getAuralAttributes()));
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.boundingLeaf = dataInput.readInt();
        ((Soundscape)this.node).setApplicationBounds(this.control.readBounds(dataInput));
        this.auralAttributes = dataInput.readInt();
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.auralAttributes);
    }

    public void buildGraph() {
        ((Soundscape)this.node).setApplicationBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        ((Soundscape)this.node).setAuralAttributes((AuralAttributes)this.control.getSymbolTable().getJ3dNode(this.auralAttributes));
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Soundscape();
    }
}

