/*
 * Decompiled with CFR 0.152.
 */
package jrm.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.zip.CRC32;
import jrm.misc.Log;

public class Settings {
    public static Properties settings = new Properties();
    public static boolean multiuser = false;
    public static boolean noupdate = false;

    public static Path getWorkPath() {
        if (multiuser) {
            Path work = Paths.get(System.getProperty("user.home"), ".jrommanager").toAbsolutePath().normalize();
            if (!Files.exists(work, new LinkOption[0])) {
                try {
                    Files.createDirectories(work, new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return work;
        }
        return Paths.get(".", new String[0]).toAbsolutePath().normalize();
    }

    public static File getWorkFile(File parent, String name, String ext) {
        if (!parent.getAbsoluteFile().toPath().startsWith(Settings.getWorkPath().toAbsolutePath())) {
            CRC32 crc = new CRC32();
            crc.update(new File(parent, name).getAbsolutePath().getBytes());
            File work = Settings.getWorkPath().resolve("work").toFile();
            work.mkdirs();
            return new File(work, String.format("%08x", crc.getValue()) + ext);
        }
        return new File(parent, name + ext);
    }

    public static Path getTmpPath(boolean local) {
        if (local) {
            if (multiuser) {
                try {
                    return Files.createDirectories(Settings.getWorkPath().resolve("tmp"), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                return Files.createTempDirectory("JRM", new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    private static File getSettingsFile() {
        File workdir = Settings.getWorkPath().toAbsolutePath().normalize().toFile();
        File cachedir = new File(workdir, "settings");
        File settingsfile = new File(cachedir, "JRomManager.properties");
        settingsfile.getParentFile().mkdirs();
        return settingsfile;
    }

    public static void saveSettings() {
        if (settings == null) {
            settings = new Properties();
        }
        try (FileOutputStream os = new FileOutputStream(Settings.getSettingsFile());){
            settings.storeToXML(os, null);
        }
        catch (IOException e) {
            Log.err("IO", e);
        }
    }

    public static void loadSettings() {
        if (settings == null) {
            settings = new Properties();
        }
        if (Settings.getSettingsFile().exists()) {
            try (FileInputStream is = new FileInputStream(Settings.getSettingsFile());){
                settings.loadFromXML(is);
            }
            catch (IOException e) {
                Log.err("IO", e);
            }
        }
    }

    public static void setProperty(String property, boolean value) {
        settings.setProperty(property, Boolean.toString(value));
    }

    public static void setProperty(String property, int value) {
        settings.setProperty(property, Integer.toString(value));
    }

    public static void setProperty(String property, String value) {
        settings.setProperty(property, value);
    }

    public static boolean getProperty(String property, boolean def) {
        return Boolean.parseBoolean(settings.getProperty(property, Boolean.toString(def)));
    }

    public static int getProperty(String property, int def) {
        return Integer.parseInt(settings.getProperty(property, Integer.toString(def)));
    }

    public static String getProperty(String property, String def) {
        return settings.getProperty(property, def);
    }
}

