/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.gentyref;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.spockframework.gentyref.GenericArrayTypeImpl;
import org.spockframework.gentyref.ParameterizedTypeImpl;
import org.spockframework.gentyref.WildcardTypeImpl;

class VarMap {
    private final Map<TypeVariable<?>, Type> map = new HashMap();

    VarMap() {
    }

    void add(TypeVariable<?> variable, Type value) {
        this.map.put(variable, value);
    }

    void addAll(TypeVariable<?>[] variables, Type[] values) {
        assert (variables.length == values.length);
        for (int i = 0; i < variables.length; ++i) {
            this.map.put(variables[i], values[i]);
        }
    }

    VarMap(TypeVariable<?>[] variables, Type[] values) {
        this.addAll(variables, values);
    }

    Type map(Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            Type result = this.map.get(type);
            return result == null ? Object.class : result;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return new ParameterizedTypeImpl((Class)pType.getRawType(), this.map(pType.getActualTypeArguments()), pType.getOwnerType() == null ? pType.getOwnerType() : this.map(pType.getOwnerType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            return new WildcardTypeImpl(this.map(wType.getUpperBounds()), this.map(wType.getLowerBounds()));
        }
        if (type instanceof GenericArrayType) {
            return GenericArrayTypeImpl.createArrayType(this.map(((GenericArrayType)type).getGenericComponentType()));
        }
        throw new RuntimeException("not implemented: mapping " + type.getClass() + " (" + type + ")");
    }

    Type[] map(Type[] types) {
        Type[] result = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.map(types[i]);
        }
        return result;
    }
}

