#!/usr/local/bin/perl

use FileHandle;

my @masters = ("master10.txt",
	       "master20.txt",
	       "master30.txt",
	       "master40.txt");

my $maxmaps = 40;

my $config = "maplist.txt";
my $mapdefaults = "mapdefaults.txt";
my $fourteam = 0;
my %default = ("HEALTH" => 9999999,
	       "MESSAGE" => "Unavailable",
	       "MAPNAME" => ""	# eventually, fill this in with map0
	      );
my $defbias = 5000;

my $mapno = 0;
my $cycledir = "qwmcycle";

my $singleteam = "\"maxammo_shells\" \"1022\"\n\"ammo_medikit\" \"0\"\n\"noise1\" \"1-Select-1\\n\\nShoot the Door to Your Favorite Map!\\n\"\n\"team_broadcast\" \"1-Select-1\\n\"";

my $cells = 0;

sub usage {
  die("$0 [-testing] [-team] [-map <maplist.txt>] [-nocells]\n");
}

sub read_config {
  open CONFIG, "<$mapdefaults" || die("Couldn't open map defaults $mapdefaults");
  $defaults = join("", <CONFIG>);
  close CONFIG;
  
  open CONFIG, "<$config" || die("Couldn't open map config file $config!");
  while (<CONFIG>) {
    next if (/^(;|\#)/ || /^\s*$/);
    if (/^(\S+)\s+"(.*)"\s+(\d*)$/) { 
      $maps[$mapno++] = {"MAPNAME" => $1,
			 "MESSAGE" => $2, 
			 "HEALTH" => $3 || $defbias
			};
      if (!$maps[$mapno - 1]{"CFGFILE"}) {
	$cfgfile = "$cycledir/" . $maps[$mapno - 1]{"MAPNAME"} . ".cfg";
	$maps[$mapno - 1]{"CFGFILE"} = new FileHandle ">$cfgfile";
	$maps[$mapno - 1]{"CFGFILE"}->print($defaults);
      }
      
      last if ($mapno == $maxmaps);
    } elsif (/^(\S+)\s+(\d*)$/) { 
      $maps[$mapno++] = {"MAPNAME" => $1,
			 "MESSAGE" => $1, 
			 "HEALTH" => $2 || $defbias
			};
      if (!$maps[$mapno - 1]{"CFGFILE"}) {
	$cfgfile = "$cycledir/" . $maps[$mapno - 1]{"MAPNAME"} . ".cfg";
	$maps[$mapno - 1]{"CFGFILE"} = new FileHandle ">$cfgfile";
	$maps[$mapno - 1]{"CFGFILE"}->print($defaults);
      }
      
      last if ($mapno == $maxmaps);
    } elsif (/^(localinfo .*)\s*$/ || /^(serverinfo .*)\s*$/) {
      
      $maps[$mapno - 1]{"CFGFILE"}->print($_);
      
    } else {
      print "WARNING: Couldn't parse line:\n\t$_\n";
      print "Did it wrap from the previous line?\n";
    }
  }
  close CONFIG;
  $default{"MAPNAME"} = $maps[0]{"MAPNAME"};
}

sub process_ent {
  my $mapfile = $masters[($mapno - 1)/ 10];
  open MAPFILE, "<$mapfile" || die("Couldn't open master file $mapfile!");
  open ENTFILE, ">vote40.ent" || die("Couldn't open vote40.ent!");
  
  print "Opened $mapfile\n" if ($testing);
  
  while (<MAPFILE>) {
    s/DOOR([0-9]+)_([A-Z]+)/$maps[$1 - 1]{$2} || $default{$2}/eg;
    # some random patterns for niceness. blech. 
    s/NUMMAPS/$mapno/g;
    s/SINGLETEAM/$singleteam/g;
    s/TEAM([1-4])/$1/g if ($fourteam);
    s/TEAM[1-4]/1/g unless ($fourteam);
    s/NUMCELLS/$cells/g;
    print ENTFILE;
    #	print if ($testing);
  }
  
  close ENTFILE;
  close MAPFILE;
}

sub main {
  while (@ARGV) {
    $_ = shift @ARGV;
    (/map/) && do {
      $config = shift @ARGV;
      next;
    };
    (/team/ || /4/) && do {
      $fourteam = 1;
      $singleteam = "";
      print "Selecting 4 Teams mode\n" if ($testing);
      next;
    };
    (/testing/) && do {
      $testing = 1;
      next;
    };
    (/cells/) && do {
      $cells = -15;
      next;
    };
    (/health/) && do {
      $defbias = shift @ARGV;
      next;
    };
    (/cycle/) && do {
      $cycledir = shift @ARGV;
      next;
    };
    print "Unknown option: $_\n";
    usage();
    }

    read_config();
    process_ent();
}


main();
