/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.kapt.AbstractKaptExtension;
import org.jetbrains.kotlin.kapt.EfficientProcessorLoader;
import org.jetbrains.kotlin.kapt.base.KaptFlag;
import org.jetbrains.kotlin.kapt.base.KaptOptions;
import org.jetbrains.kotlin.kapt.base.LoadedProcessors;
import org.jetbrains.kotlin.kapt.base.ProcessorLoader;
import org.jetbrains.kotlin.kapt.util.MessageCollectorBackedKaptLogger;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J0\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/kapt/ClasspathBasedKaptExtension;", "Lorg/jetbrains/kotlin/kapt/AbstractKaptExtension;", "options", "Lorg/jetbrains/kotlin/kapt/base/KaptOptions;", "logger", "Lorg/jetbrains/kotlin/kapt/util/MessageCollectorBackedKaptLogger;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "<init>", "(Lorg/jetbrains/kotlin/kapt/base/KaptOptions;Lorg/jetbrains/kotlin/kapt/util/MessageCollectorBackedKaptLogger;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "analyzePartially", "", "getAnalyzePartially", "()Z", "processorLoader", "Lorg/jetbrains/kotlin/kapt/base/ProcessorLoader;", "loadProcessors", "Lorg/jetbrains/kotlin/kapt/base/LoadedProcessors;", "analysisCompleted", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "clearJavacZipCaches", "", "kotlin-annotation-processing"})
public final class ClasspathBasedKaptExtension
extends AbstractKaptExtension {
    @Nullable
    private ProcessorLoader processorLoader;

    public ClasspathBasedKaptExtension(@NotNull KaptOptions options, @NotNull MessageCollectorBackedKaptLogger logger, @NotNull CompilerConfiguration compilerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)compilerConfiguration, (String)"compilerConfiguration");
        super(options, logger, compilerConfiguration);
    }

    @Override
    public boolean getAnalyzePartially() {
        return this.getOptions().get(KaptFlag.USE_LIGHT_ANALYSIS) && super.getAnalyzePartially();
    }

    @Override
    @NotNull
    protected LoadedProcessors loadProcessors() {
        ProcessorLoader processorLoader = this.processorLoader = (ProcessorLoader)new EfficientProcessorLoader(this.getOptions(), this.getLogger());
        Intrinsics.checkNotNull((Object)processorLoader);
        return ProcessorLoader.loadProcessors$default(processorLoader, null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AnalysisResult analysisCompleted(@NotNull Project project, @NotNull ModuleDescriptor module, @NotNull BindingTrace bindingTrace, @NotNull Collection<? extends KtFile> files) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        try {
            AnalysisResult analysisResult = super.analysisCompleted(project, module, bindingTrace, files);
            return analysisResult;
        }
        finally {
            ProcessorLoader processorLoader = this.processorLoader;
            if (processorLoader != null) {
                processorLoader.close();
            }
            this.clearJavacZipCaches();
        }
    }

    private final void clearJavacZipCaches() {
        try {
            Class<?> zipFileIndexCacheClass = Class.forName("com.sun.tools.javac.file.ZipFileIndexCache");
            Object zipFileIndexCacheInstance = zipFileIndexCacheClass.getMethod("getSharedInstance", new Class[0]).invoke(null, new Object[0]);
            zipFileIndexCacheClass.getMethod("clearCache", new Class[0]).invoke(zipFileIndexCacheInstance, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

