/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Dice;
import gmgen.plugin.Effect;
import gmgen.plugin.InitHolder;
import gmgen.plugin.State;
import gmgen.plugin.SystemHP;
import gmgen.plugin.SystemInitiative;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class Combatant
implements InitHolder {
    public SystemInitiative init;
    protected List<Effect> effects = new ArrayList<Effect>();
    protected String comType = "Enemy";
    protected State status = State.Nothing;
    protected SystemHP hitPoints;
    protected int duration;
    protected int number;

    public abstract void setCR(float var1);

    public abstract float getCR();

    public void setCombatantType(String comType) {
        this.comType = comType;
    }

    public String getCombatantType() {
        return this.comType;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public List<Effect> getEffects() {
        return this.effects;
    }

    public SystemHP getHP() {
        return this.hitPoints;
    }

    @Override
    public SystemInitiative getInitiative() {
        return this.init;
    }

    public abstract void setName(String var1);

    public void setNumber(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public Vector<Object> getRowVector(List<String> columnOrder) {
        Vector<Object> rowVector = new Vector<Object>();
        for (String columnName : columnOrder) {
            if (columnName.equals("Name")) {
                rowVector.add(this.getName());
                continue;
            }
            if (columnName.equals("Player")) {
                rowVector.add(this.getPlayer());
                continue;
            }
            if (columnName.equals("Status")) {
                rowVector.add((Object)this.getStatus());
                continue;
            }
            if (columnName.equals("+")) {
                rowVector.add(this.init.getModifier());
                continue;
            }
            if (columnName.equals("Init")) {
                rowVector.add(this.init.getCurrentInitiative());
                continue;
            }
            if (columnName.equals("Dur")) {
                if (this.duration == 0) {
                    rowVector.add("");
                    continue;
                }
                rowVector.add(this.getDuration());
                continue;
            }
            if (columnName.equals("#")) {
                rowVector.add(this.number);
                continue;
            }
            if (columnName.equals("HP")) {
                int hp = this.hitPoints.getCurrent();
                int sub = this.hitPoints.getSubdual();
                if (sub == 0) {
                    rowVector.add(hp);
                    continue;
                }
                if (sub <= 0) continue;
                rowVector.add(hp + "/" + sub + "s");
                continue;
            }
            if (columnName.equals("HP Max")) {
                rowVector.add(this.hitPoints.getMax());
                continue;
            }
            if (!columnName.equals("Type")) continue;
            rowVector.add(this.comType);
        }
        return rowVector;
    }

    @Override
    public void setStatus(State status) {
        this.status = status;
    }

    @Override
    public State getStatus() {
        return this.status;
    }

    public abstract void setXP(int var1);

    public abstract int getXP();

    public void addEffect(Effect effect) {
        this.effects.add(effect);
    }

    public void bleed() {
        this.setStatus(this.hitPoints.bleed());
    }

    public void damage(int damage) {
        this.setStatus(this.hitPoints.damage(damage));
    }

    public int decDuration() {
        if (this.duration > 0) {
            --this.duration;
            if (this.duration == 0) {
                this.setStatus(this.hitPoints.endDurationedStatus());
            }
        }
        return this.duration;
    }

    @Override
    public void endRound() {
        this.hitPoints.endRound();
    }

    public void heal(int heal) {
        this.setStatus(this.hitPoints.heal(heal));
    }

    public void kill() {
        this.setStatus(this.hitPoints.kill());
    }

    public void nonLethalDamage(boolean type) {
        this.setStatus(this.hitPoints.nonLethalDamage(type));
        if (type) {
            this.setDuration(new Dice(4, 1).roll() + 1);
        } else {
            this.setDuration(1);
        }
    }

    public void raise() {
        this.setStatus(this.hitPoints.raise());
    }

    public void stabilize() {
        this.setStatus(this.hitPoints.stabilize());
    }

    public void subdualDamage(int damage) {
        this.setStatus(this.hitPoints.subdualDamage(damage));
    }

    public String toString() {
        return this.getName();
    }

    public abstract String toHtmlString();
}

