/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PlayerCharacter;

public class ReferenceChoiceSet<T>
implements PrimitiveChoiceSet<T> {
    private final Collection<CDOMReference<T>> refCollection;

    public ReferenceChoiceSet(Collection<? extends CDOMReference<T>> col) {
        if (col == null) {
            throw new IllegalArgumentException("Choice Collection cannot be null");
        }
        if (col.isEmpty()) {
            throw new IllegalArgumentException("Choice Collection cannot be empty");
        }
        this.refCollection = new WeightedCollection<CDOMReference<T>>(col);
    }

    @Override
    public String getLSTformat(boolean useAny) {
        WeightedCollection sortedSet = new WeightedCollection(ReferenceUtilities.REFERENCE_SORTER);
        sortedSet.addAll(this.refCollection);
        return ReferenceUtilities.joinLstFormat(sortedSet, ",", useAny);
    }

    @Override
    public Class<T> getChoiceClass() {
        return this.refCollection == null ? null : this.refCollection.iterator().next().getReferenceClass();
    }

    @Override
    public Set<T> getSet(PlayerCharacter pc) {
        HashSet<T> returnSet = new HashSet<T>();
        for (CDOMReference<T> ref : this.refCollection) {
            returnSet.addAll(ref.getContainedObjects());
        }
        return returnSet;
    }

    public int hashCode() {
        return this.refCollection.size();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReferenceChoiceSet) {
            ReferenceChoiceSet other = (ReferenceChoiceSet)obj;
            return this.refCollection.equals(other.refCollection);
        }
        return false;
    }

    @Override
    public GroupingState getGroupingState() {
        GroupingState state = GroupingState.EMPTY;
        for (CDOMReference<T> ref : this.refCollection) {
            state = ref.getGroupingState().add(state);
        }
        return state.compound(GroupingState.ALLOWS_UNION);
    }
}

