/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;

public class HitDie
extends ConcretePrereqObject
implements Comparable<HitDie> {
    public static final HitDie ZERO = new HitDie(0);
    private final int die;

    public HitDie(int dieSize) {
        if (dieSize < 0) {
            throw new IllegalArgumentException("HitDie can not have a negative die size");
        }
        this.die = dieSize;
    }

    public int getDie() {
        return this.die;
    }

    public HitDie getNext() {
        int[] dieSizes = SettingsHandler.getGame().getDieSizes();
        int length = dieSizes.length;
        for (int i = 0; i < length; ++i) {
            if (this.die != dieSizes[i]) continue;
            if (i == length - 1) {
                if (Logging.isDebugMode()) {
                    Logging.debugPrint("Hit Die: " + this.die + " is Highest Hit Die in Die Sizes");
                }
                return this;
            }
            return new HitDie(dieSizes[i + 1]);
        }
        Logging.errorPrint("Cannot find Hit Die: " + this.die + " in Global Die Sizes");
        return this;
    }

    public HitDie getPrevious() {
        int[] dieSizes = SettingsHandler.getGame().getDieSizes();
        int length = dieSizes.length;
        for (int i = 0; i < length; ++i) {
            if (this.die != dieSizes[i]) continue;
            if (i == 0) {
                if (!Logging.isDebugMode()) continue;
                Logging.debugPrint("Hit Die: " + this.die + " is Lowest Hit Die in Die Sizes");
                continue;
            }
            return new HitDie(dieSizes[i - 1]);
        }
        Logging.errorPrint("Cannot find Hit Die: " + this.die + " in Global Die Sizes");
        return this;
    }

    public int hashCode() {
        return this.die;
    }

    public boolean equals(Object obj) {
        return obj instanceof HitDie && ((HitDie)obj).die == this.die;
    }

    public String toString() {
        return "HitDie: " + this.die;
    }

    @Override
    public int compareTo(HitDie other) {
        return this.die == other.die ? 0 : (this.die < other.die ? -1 : 1);
    }
}

