/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Collection;
import java.util.List;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.analysis.AgeSetFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.fact.AgeFacet;
import pcgen.cdom.facet.model.BioSetFacet;
import pcgen.core.AgeSet;
import pcgen.core.BioSet;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;

public class AgeSetKitFacet
extends AbstractStorageFacet<CharID>
implements DataFacetChangeListener<CharID, Integer> {
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private AgeFacet ageFacet;
    private AgeSetFacet ageSetFacet;
    private BioSetFacet bioSetFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, Integer> dfce) {
        CharID id = dfce.getCharID();
        AgeSet ageSet = (AgeSet)((AbstractItemFacet)this.ageSetFacet).get(id);
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (ageSet == null || pc.isImporting()) {
            return;
        }
        int ageSetIndex = this.ageSetFacet.getAgeSetIndex(id);
        if (!pc.hasMadeKitSelectionForAgeSet(ageSetIndex)) {
            CacheInfo cache = this.getConstructingClassInfo(id);
            List<Kit> kits = cache.get(ageSet);
            if (kits != null) {
                BioSet bioSet = (BioSet)this.bioSetFacet.get(id);
                for (TransitionChoice<Kit> kit : ageSet.getKits()) {
                    Collection<Kit> choice = kit.driveChoice(pc);
                    cache.put(ageSet, choice);
                    kit.act(choice, bioSet, pc);
                }
            }
            pc.setHasMadeKitSelectionForAgeSet(ageSetIndex, true);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, Integer> dfce) {
    }

    private CacheInfo getClassInfo(CharID id) {
        return (CacheInfo)this.getCache(id);
    }

    private CacheInfo getConstructingClassInfo(CharID id) {
        CacheInfo info = this.getClassInfo(id);
        if (info == null) {
            info = new CacheInfo();
            this.setCache(id, info);
        }
        return info;
    }

    public void setAgeFacet(AgeFacet ageFacet) {
        this.ageFacet = ageFacet;
    }

    public void setAgeSetFacet(AgeSetFacet ageSetFacet) {
        this.ageSetFacet = ageSetFacet;
    }

    public void setBioSetFacet(BioSetFacet bioSetFacet) {
        this.bioSetFacet = bioSetFacet;
    }

    public void init() {
        this.ageFacet.addDataFacetChangeListener(this);
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        CacheInfo ci = this.getClassInfo(source);
        if (ci != null) {
            CacheInfo copyci = this.getConstructingClassInfo(copy);
            copyci.kitMap.addAllLists((MapToList)ci.kitMap);
        }
    }

    private static class CacheInfo {
        private HashMapToList<AgeSet, Kit> kitMap = new HashMapToList();

        private CacheInfo() {
        }

        public List<Kit> get(AgeSet ageSet) {
            return this.kitMap.getListFor((Object)ageSet);
        }

        public void put(AgeSet ageSet, Collection<? extends Kit> choice) {
            this.kitMap.addAllToListFor((Object)ageSet, choice);
        }
    }
}

