/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.List;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.DeityFacet;
import pcgen.core.Deity;
import pcgen.core.WeaponProf;

public class DeityWeaponProfFacet
extends AbstractSourcedListFacet<CharID, WeaponProf>
implements DataFacetChangeListener<CharID, Deity> {
    private DeityFacet deityFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, Deity> dfce) {
        Deity deity = dfce.getCDOMObject();
        List<CDOMReference<WeaponProf>> weaponList = deity.getListFor(ListKey.DEITYWEAPON);
        if (weaponList != null) {
            for (CDOMReference<WeaponProf> ref : weaponList) {
                for (WeaponProf wp : ref.getContainedObjects()) {
                    if (wp.isType("Natural")) continue;
                    this.add(dfce.getCharID(), wp, dfce.getCDOMObject());
                }
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, Deity> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public void setDeityFacet(DeityFacet deityFacet) {
        this.deityFacet = deityFacet;
    }

    public void init() {
        this.deityFacet.addDataFacetChangeListener(this);
    }
}

