/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.ClassSource;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.analysis.BonusActivation;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.character.CharacterSpell;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;

public class DomainApplication {
    public static void applyDomain(PlayerCharacter pc, Domain d) {
        ClassSource source = pc.getDomainSource(d);
        PCClass aClass = pc.getClassKeyed(source.getPcclass().getKeyName());
        if (aClass != null) {
            int maxLevel;
            for (maxLevel = 0; maxLevel < 10 && pc.getSpellSupport(aClass).getCastForLevel(maxLevel, pc) != 0; ++maxLevel) {
            }
            if (maxLevel > 0) {
                DomainApplication.addSpellsToClassForLevels(pc, d, aClass, 0, maxLevel - 1);
            }
            if (maxLevel > 1 && aClass.getSafe(IntegerKey.KNOWN_SPELLS_FROM_SPECIALTY) == 0) {
                DomainSpellList domainSpellList = d.get(ObjectKey.DOMAIN_SPELLLIST);
                List<Spell> aList = pc.getAllSpellsInLists(Collections.singletonList(domainSpellList));
                for (Spell gcs : aList) {
                    if (SpellLevel.getFirstLvlForKey(gcs, domainSpellList, pc) >= maxLevel) continue;
                    pc.setDomainSpellCount(aClass, 1);
                    break;
                }
            }
        }
        Collection mods = d.getSafeListMods(Spell.SPELLS);
        for (CDOMReference ref : mods) {
            Collection spells = ref.getContainedObjects();
            Collection<AssociatedPrereqObject> assoc = d.getListAssociations(Spell.SPELLS, ref);
            for (AssociatedPrereqObject apo : assoc) {
                if (!PrereqHandler.passesAll(apo.getPrerequisiteList(), pc, d)) continue;
                for (Spell s : spells) {
                    String book;
                    List<CharacterSpell> aList = pc.getCharacterSpells(aClass, s, book = apo.getAssociation(AssociationKey.SPELLBOOK), -1);
                    if (!aList.isEmpty()) continue;
                    Formula times = apo.getAssociation(AssociationKey.TIMES_PER_UNIT);
                    CharacterSpell cs = new CharacterSpell(d, s);
                    int resolvedTimes = times.resolve(pc, d.getQualifiedKey()).intValue();
                    cs.addInfo(1, resolvedTimes, book);
                    pc.addCharacterSpell(aClass, cs);
                }
            }
        }
    }

    public static void removeDomain(PlayerCharacter pc, Domain domain) {
        ClassSource source = pc.getDomainSource(domain);
        PCClass aClass = pc.getClassKeyed(source.getPcclass().getKeyName());
        if (aClass != null) {
            int maxLevel;
            for (maxLevel = 0; maxLevel < 10 && pc.getSpellSupport(aClass).getCastForLevel(maxLevel, pc) != 0; ++maxLevel) {
            }
            if (maxLevel > 0) {
                DomainApplication.removeSpellsFromClassForLevels(pc, domain, aClass);
            }
            if (maxLevel > 1 && aClass.getSafe(IntegerKey.KNOWN_SPELLS_FROM_SPECIALTY) == 0) {
                DomainSpellList domainSpellList = domain.get(ObjectKey.DOMAIN_SPELLLIST);
                List<Spell> aList = pc.getAllSpellsInLists(Collections.singletonList(domainSpellList));
                for (Spell gcs : aList) {
                    if (SpellLevel.getFirstLvlForKey(gcs, domainSpellList, pc) >= maxLevel) continue;
                    pc.removeDomainSpellCount(aClass);
                    break;
                }
            }
        }
        if (!pc.isImporting()) {
            BonusActivation.deactivateBonuses(domain, pc);
        }
    }

    public static void removeSpellsFromClassForLevels(PlayerCharacter pc, Domain domain, PCClass aClass) {
        if (aClass == null) {
            return;
        }
        Collection<? extends CharacterSpell> characterSpells = pc.getCharacterSpells(aClass);
        for (CharacterSpell characterSpell : characterSpells) {
            if (characterSpell.getOwner() != domain) continue;
            pc.removeCharacterSpell(aClass, characterSpell);
        }
    }

    public static void addSpellsToClassForLevels(PlayerCharacter pc, Domain d, PCClass aClass, int minLevel, int maxLevel) {
        if (aClass == null) {
            return;
        }
        for (int aLevel = minLevel; aLevel <= maxLevel; ++aLevel) {
            Collection<Spell> domainSpells = pc.getSpellsIn(d.get(ObjectKey.DOMAIN_SPELLLIST), aLevel);
            for (Spell spell : domainSpells) {
                CharacterSpell cs1;
                List<CharacterSpell> slist = pc.getCharacterSpells(aClass, spell, Globals.getDefaultSpellBook(), aLevel);
                boolean flag = true;
                Iterator<CharacterSpell> i$ = slist.iterator();
                while (i$.hasNext() && (flag = !(cs1 = i$.next()).getOwner().equals(d))) {
                }
                if (!flag) continue;
                CharacterSpell cs = new CharacterSpell(d, spell);
                cs.addInfo(aLevel, 1, Globals.getDefaultSpellBook());
                pc.addCharacterSpell(aClass, cs);
            }
        }
    }

    private static void addDomain(PlayerCharacter aPC, PCClass cl, Domain d) {
        if (d.qualifies(aPC, d)) {
            ClassSource cs = new ClassSource(cl, aPC.getLevel(cl));
            aPC.addDomain(d, cs);
            DomainApplication.applyDomain(aPC, d);
        }
    }

    public static void addDomainsUpToLevel(PCClass cl, int aLevel, PlayerCharacter aPC) {
        if (aPC.isImporting()) {
            return;
        }
        for (QualifiedObject<CDOMSingleRef<Domain>> qo : cl.getSafeListFor(ListKey.DOMAIN)) {
            CDOMSingleRef<Domain> ref = qo.getObject(aPC, cl);
            if (ref == null) continue;
            DomainApplication.addDomain(aPC, cl, ref.resolvesTo());
        }
        for (int i = 0; i <= aLevel; ++i) {
            PCClassLevel pcl = aPC.getActiveClassLevel(cl, i);
            for (QualifiedObject<CDOMSingleRef<Domain>> qo : pcl.getSafeListFor(ListKey.DOMAIN)) {
                CDOMSingleRef<Domain> ref = qo.getObject(aPC, cl);
                if (ref == null) continue;
                DomainApplication.addDomain(aPC, cl, ref.resolvesTo());
            }
        }
    }

    public static void removeDomainsForLevel(PCClass cl, int removedLevel, PlayerCharacter aPC) {
        for (QualifiedObject<CDOMSingleRef<Domain>> qo : cl.getSafeListFor(ListKey.DOMAIN)) {
            CDOMSingleRef<Domain> ref = qo.getObject(aPC, cl);
            if (ref != null) continue;
            ref = qo.getRawObject();
            aPC.removeDomain(ref.resolvesTo());
        }
        for (int i = 0; i <= removedLevel; ++i) {
            PCClassLevel pcl = aPC.getActiveClassLevel(cl, i);
            for (QualifiedObject<CDOMSingleRef<Domain>> qo : pcl.getSafeListFor(ListKey.DOMAIN)) {
                CDOMSingleRef<Domain> ref = qo.getObject(aPC, cl);
                if (ref != null && i != removedLevel) continue;
                ref = qo.getRawObject();
                aPC.removeDomain(ref.resolvesTo());
            }
        }
    }
}

