/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCBaseSpellStatTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    private final String source;

    public PCBaseSpellStatTermEvaluator(String originalText, String source) {
        this.originalText = originalText;
        this.source = source;
    }

    @Override
    public Float resolve(PlayerCharacter pc) {
        PCClass pcClass = pc.getClassKeyed(this.source);
        if (pcClass == null) {
            pcClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, this.source);
        }
        return Float.valueOf(this.getBaseSpellStatBonus(pc, pcClass));
    }

    private int getBaseSpellStatBonus(PlayerCharacter pc, PCClass pcClass) {
        if (pcClass == null) {
            return 0;
        }
        int baseSpellStat = 0;
        CDOMSingleRef<PCStat> ssref = pcClass.get(ObjectKey.SPELL_STAT);
        if (ssref != null) {
            PCStat ss = ssref.resolvesTo();
            baseSpellStat = pc.getTotalStatFor(ss);
            baseSpellStat += (int)pc.getTotalBonusTo("STAT", "BASESPELLSTAT");
            baseSpellStat += (int)pc.getTotalBonusTo("STAT", "BASESPELLSTAT;CLASS=" + pcClass.getKeyName());
            baseSpellStat += (int)pc.getTotalBonusTo("STAT", "CAST." + ss.getKeyName());
            baseSpellStat = pc.getModForNumber(baseSpellStat, ss);
        }
        return baseSpellStat;
    }

    @Override
    public boolean isSourceDependant() {
        return true;
    }

    public boolean isStatic() {
        return false;
    }
}

