/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class UnstretchingGridLayout
extends GridLayout {
    public UnstretchingGridLayout() {
    }

    public UnstretchingGridLayout(int arg0, int arg1) {
        super(arg0, arg1);
    }

    public UnstretchingGridLayout(int arg0, int arg1, int arg2, int arg3) {
        super(arg0, arg1, arg2, arg3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int componentCount = parent.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            int rowCount = this.getRows();
            int columnCount = this.getColumns();
            if (rowCount > 0) {
                columnCount = (componentCount + rowCount - 1) / rowCount;
            } else {
                rowCount = (componentCount + columnCount - 1) / columnCount;
            }
            int[] rowHeight = new int[rowCount];
            int[] columnWidth = new int[columnCount];
            for (int i = 0; i < componentCount; ++i) {
                int row = i / columnCount;
                int column = i % columnCount;
                Component component = parent.getComponent(i);
                Dimension d = component.getPreferredSize();
                rowHeight[row] = Math.max(rowHeight[row], d.height);
                columnWidth[column] = Math.max(columnWidth[column], d.width);
            }
            boolean leftToRight = parent.getComponentOrientation().isLeftToRight();
            int xGutter = this.getHgap();
            int yGutter = this.getVgap();
            Insets insets = parent.getInsets();
            int yLoc = insets.top;
            for (int row = 0; row < rowHeight.length; ++row) {
                int xLoc = insets.left;
                for (int column = 0; column < columnCount; ++column) {
                    int i = row * columnCount + column;
                    if (i < componentCount) {
                        Component component = parent.getComponent(i);
                        Dimension d = component.getPreferredSize();
                        int x = leftToRight ? xLoc : xLoc - d.width;
                        component.setBounds(x, yLoc, d.width, d.height);
                    }
                    if (leftToRight) {
                        xLoc += columnWidth[column] + xGutter;
                        continue;
                    }
                    xLoc -= columnWidth[column] + xGutter;
                }
                yLoc += rowHeight[row] + yGutter;
            }
        }
    }
}

