/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.enumeration.DataSetID;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.MasterAvailableSpellFacet;
import pcgen.cdom.helper.AvailableSpell;
import pcgen.cdom.identifier.SpellSchool;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.spell.Spell;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.SpellBuilderFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.util.Logging;

public class SpellBuilderFacadeImpl
implements SpellBuilderFacade {
    private DefaultReferenceFacade<InfoFacade> pcClass;
    private DefaultReferenceFacade<Integer> spellLevel;
    private DefaultReferenceFacade<InfoFacade> spell;
    private DefaultReferenceFacade<String> variant;
    private DefaultReferenceFacade<Integer> casterLevel;
    private DefaultReferenceFacade<String> spellType;
    private DefaultListFacade<InfoFacade> availClasses;
    private DefaultListFacade<Integer> availSpellLevels;
    private DefaultListFacade<InfoFacade> availSpells;
    private DefaultListFacade<String> availVariants;
    private DefaultListFacade<Integer> availCasterlevels;
    private DefaultListFacade<String> availSpellTypes;
    private DefaultListFacade<AbilityFacade> availMetamagicFeats;
    private DefaultListFacade<AbilityFacade> selMetamagicFeats;
    private List<String> classList;
    private List<String> levelList;
    private boolean metaAllowed;
    private Boolean spellBooks;
    private int minSpellLevel = 0;
    private int maxSpellLevel = 9;
    private String reqSpellType = "";
    private List<String> subTypeList = new ArrayList<String>();
    private PlayerCharacter character;
    private Type requiredType;
    private List<AvailableSpell> classSpells;
    private CDOMList<Spell> spellList;
    private MasterAvailableSpellFacet masterAvailableSpellFacet;
    private DataSetID datasetID;

    public SpellBuilderFacadeImpl(String choiceValue, PlayerCharacter character, Equipment equip) {
        this.character = character;
        this.masterAvailableSpellFacet = FacetLibrary.getFacet(MasterAvailableSpellFacet.class);
        this.datasetID = character.getCharID().getDatasetID();
        this.availClasses = new DefaultListFacade();
        this.availSpellLevels = new DefaultListFacade();
        this.availSpells = new DefaultListFacade();
        this.availVariants = new DefaultListFacade();
        this.availCasterlevels = new DefaultListFacade();
        this.availSpellTypes = new DefaultListFacade();
        this.availMetamagicFeats = new DefaultListFacade();
        this.pcClass = new DefaultReferenceFacade();
        this.spellLevel = new DefaultReferenceFacade();
        this.spell = new DefaultReferenceFacade();
        this.variant = new DefaultReferenceFacade();
        this.casterLevel = new DefaultReferenceFacade();
        this.spellType = new DefaultReferenceFacade();
        this.selMetamagicFeats = new DefaultListFacade();
        this.requiredType = Type.NONE;
        if (equip != null) {
            Type[] knownTypes;
            for (Type itemType : knownTypes = new Type[]{Type.POTION, Type.SCROLL, Type.WAND, Type.RING}) {
                if (!equip.isType(itemType.toString())) continue;
                this.requiredType = itemType;
                break;
            }
        }
        this.parseChoiceValue(choiceValue);
        this.buildLists();
        if (this.availClasses.getSize() > 0) {
            this.setClass(this.availClasses.getElementAt(0));
        }
    }

    private void parseChoiceValue(String choiceValue) {
        this.classList = null;
        this.levelList = null;
        this.metaAllowed = true;
        this.spellBooks = null;
        if (StringUtils.isNotEmpty(choiceValue) && !this.parseClassLevelSyntax(choiceValue)) {
            this.parseTypeSyntax(choiceValue);
        }
        if (this.requiredType == Type.POTION) {
            this.maxSpellLevel = Math.min(this.maxSpellLevel, SettingsHandler.getMaxPotionSpellLevel());
        } else if (this.requiredType == Type.WAND) {
            this.maxSpellLevel = Math.min(this.maxSpellLevel, SettingsHandler.getMaxWandSpellLevel());
        }
    }

    private boolean parseClassLevelSyntax(String choiceValue) {
        StringTokenizer aTok = new StringTokenizer(choiceValue, "|", false);
        block4: while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            if (aString.startsWith("CLASS=")) {
                if (this.classList == null) {
                    this.classList = new ArrayList<String>();
                }
                this.classList.add(aString.substring(6));
                continue;
            }
            if (aString.startsWith("LEVEL=")) {
                if (this.levelList == null) {
                    this.levelList = new ArrayList<String>();
                }
                this.levelList.add(aString.substring(6));
                continue;
            }
            if (aString.startsWith("SPELLBOOKS=")) {
                switch (aString.charAt(11)) {
                    case 'Y': {
                        this.spellBooks = true;
                        continue block4;
                    }
                    case 'N': {
                        this.spellBooks = false;
                        continue block4;
                    }
                }
                this.spellBooks = null;
                continue;
            }
            if (aString.equals("METAMAGIC=N")) {
                this.metaAllowed = false;
                continue;
            }
            return false;
        }
        return true;
    }

    private void parseTypeSyntax(String choiceValue) {
        StringTokenizer aTok = new StringTokenizer(choiceValue, "|");
        if (aTok.hasMoreTokens()) {
            this.reqSpellType = aTok.nextToken();
            if (this.reqSpellType.equalsIgnoreCase("ANY") || this.reqSpellType.equalsIgnoreCase("ALL")) {
                this.reqSpellType = "";
            }
        }
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            try {
                this.minSpellLevel = Integer.parseInt(aString);
                break;
            }
            catch (NumberFormatException nfe) {
                this.subTypeList.add(aString);
            }
        }
        if (aTok.hasMoreTokens()) {
            this.maxSpellLevel = Integer.parseInt(aTok.nextToken());
        }
    }

    private void buildLists() {
        int i;
        ArrayList<PCClass> classes = new ArrayList<PCClass>();
        ArrayList<Domain> domains = new ArrayList<Domain>();
        if (this.classList != null) {
            for (String classKey : this.classList) {
                PObject obj = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classKey);
                if (obj == null) {
                    obj = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Domain.class, classKey);
                    if (obj == null) continue;
                    domains.add((Domain)obj);
                    continue;
                }
                classes.add((PCClass)obj);
            }
        } else {
            for (Spell spell : Globals.getSpellMap().values()) {
                if (!this.isSpellOfSubType(spell)) continue;
                this.addSpellInfoToList(spell, classes, domains, this.reqSpellType);
            }
            for (PCClass aClass : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCClass.class)) {
                if (aClass.getSpellType().equals("None") || this.character.getSpellSupport(aClass).canCastSpells(this.character) || !"".equals(this.reqSpellType) && this.reqSpellType.indexOf(aClass.getSpellType()) < 0 || classes.contains(aClass)) continue;
                classes.add(aClass);
            }
        }
        if (this.spellBooks != null) {
            for (int i2 = classes.size() - 1; i2 >= 0; --i2) {
                PCClass obj = (PCClass)classes.get(i2);
                if (!this.spellBooks.booleanValue()) {
                    if (!obj.getSafe(ObjectKey.SPELLBOOK).booleanValue()) continue;
                    classes.remove(i2);
                    continue;
                }
                if (obj instanceof PCClass && obj.getSafe(ObjectKey.SPELLBOOK).booleanValue()) continue;
                classes.remove(i2);
            }
            if (this.spellBooks.booleanValue()) {
                domains.clear();
            }
        }
        ArrayList<PObject> allObjects = new ArrayList<PObject>();
        Globals.sortPObjectListByName(classes);
        allObjects.addAll(classes);
        Globals.sortPObjectListByName(domains);
        allObjects.addAll(domains);
        this.availClasses.setContents(allObjects);
        ArrayList<Integer> spellLevelValues = new ArrayList<Integer>();
        if (this.levelList != null && this.levelList.size() > 0) {
            for (i = this.minSpellLevel; i < this.levelList.size(); ++i) {
                spellLevelValues.add(Integer.valueOf(this.levelList.get(i)));
            }
        } else {
            for (i = this.minSpellLevel; i <= this.maxSpellLevel; ++i) {
                spellLevelValues.add(i);
            }
        }
        this.availSpellLevels.setContents(spellLevelValues);
        this.updateAvailCasterLevels(1, 20);
        if (this.metaAllowed) {
            ArrayList<Ability> metamagicFeats = new ArrayList<Ability>();
            for (Ability anAbility : Globals.getContext().getReferenceContext().getManufacturer(Ability.class, AbilityCategory.FEAT).getAllObjects()) {
                if (!anAbility.isType("Metamagic")) continue;
                metamagicFeats.add(anAbility);
            }
            Globals.sortPObjectListByName(metamagicFeats);
            this.availMetamagicFeats.setContents(metamagicFeats);
        }
    }

    private void addSpellInfoToList(Spell aSpell, List<PCClass> classes, List<Domain> domains, String spellType) {
        HashSet<String> unfoundItems = new HashSet<String>();
        HashMapToList<CDOMList<Spell>, Integer> levelInfo = this.character.getSpellLevelInfo(aSpell);
        if (levelInfo == null || levelInfo.size() == 0) {
            return;
        }
        for (CDOMList spellList : levelInfo.getKeySet()) {
            String key;
            if (spellList instanceof ClassSpellList) {
                key = spellList.getKeyName();
                PCClass aClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, key);
                if (aClass != null) {
                    if (!"".equals(spellType) && spellType.indexOf(aClass.getSpellType()) < 0 || classes.contains(aClass)) continue;
                    classes.add(aClass);
                    continue;
                }
                key = 'C' + key;
                if (unfoundItems.contains(key)) continue;
                unfoundItems.add(key);
                Logging.errorPrint("Class " + key.substring(1) + " not found. Was used in spell " + aSpell);
                continue;
            }
            if (spellList instanceof DomainSpellList) {
                if (!"".equals(spellType) && spellType.indexOf("Divine") < 0) continue;
                key = spellList.getKeyName();
                Domain aDomain = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Domain.class, key);
                if (aDomain != null) {
                    if (domains.contains(aDomain)) continue;
                    domains.add(aDomain);
                    continue;
                }
                key = 'D' + key;
                if (unfoundItems.contains(key)) continue;
                unfoundItems.add(key);
                Logging.errorPrint("Domain " + key.substring(1) + " not found. Was used in spell " + aSpell);
                continue;
            }
            Logging.errorPrint("Unknown spell source: " + spellList);
        }
    }

    private boolean isSpellOfSubType(Spell aSpell) {
        if (this.subTypeList.size() == 0) {
            return true;
        }
        boolean finalIsOfType = false;
        for (String s : this.subTypeList) {
            boolean isOfType = true;
            StringTokenizer aTok = new StringTokenizer(s, ";,");
            while (aTok.hasMoreTokens()) {
                String descriptor;
                SpellSchool ss;
                String subType = aTok.nextToken();
                if (subType.startsWith("SCHOOL.") && ((ss = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(SpellSchool.class, subType.substring(7))) == null || !aSpell.containsInList(ListKey.SPELL_SCHOOL, ss))) {
                    isOfType = false;
                    break;
                }
                if (subType.startsWith("SUBSCHOOL.") && !aSpell.containsInList(ListKey.SPELL_SUBSCHOOL, subType.substring(10))) {
                    isOfType = false;
                    break;
                }
                if (!subType.startsWith("DESCRIPTOR.") || aSpell.containsInList(ListKey.SPELL_DESCRIPTOR, descriptor = subType.substring(11))) continue;
                isOfType = false;
                break;
            }
            if (!isOfType) continue;
            finalIsOfType = true;
            break;
        }
        return finalIsOfType;
    }

    private void updateAvailCasterLevels(int min, int max) {
        ArrayList<Integer> levelsForCasting = new ArrayList<Integer>(20);
        for (int i = min; i <= max; ++i) {
            levelsForCasting.add(i);
        }
        this.availCasterlevels.setContents(levelsForCasting);
    }

    private void processLevelChange() {
        int baseSpellLevel = this.spellLevel.getReference();
        ArrayList<Spell> spellsOfLevel = new ArrayList<Spell>();
        for (AvailableSpell availSpell : this.classSpells) {
            if (availSpell.getLevel() != baseSpellLevel) continue;
            spellsOfLevel.add(availSpell.getSpell());
        }
        Globals.sortPObjectListByName(spellsOfLevel);
        this.availSpells.setContents(spellsOfLevel);
        InfoFacade selSpell = this.spell.getReference();
        if (selSpell == null || !spellsOfLevel.contains(selSpell)) {
            Spell newSpell = null;
            if (!spellsOfLevel.isEmpty()) {
                newSpell = (Spell)spellsOfLevel.get(0);
            }
            this.selectSpell(newSpell);
        }
        List<String> spellTypeList = this.getSpellTypeList();
        this.availSpellTypes.setContents(spellTypeList);
        this.spellType.setReference(spellTypeList.get(0));
    }

    private void selectSpell(Spell newSpell) {
        this.spell.setReference(newSpell);
        List<Object> variants = new ArrayList();
        if (newSpell != null) {
            variants = newSpell.getSafeListFor(ListKey.VARIANTS);
        }
        Collections.sort(variants);
        this.availVariants.setContents(variants);
        if (variants.isEmpty()) {
            this.variant.setReference(null);
        } else {
            String currVariant = this.variant.getReference();
            if (currVariant != null && !variants.contains(currVariant)) {
                this.variant.setReference(null);
            }
        }
        this.recalcCasterLevelDetails();
    }

    private void recalcCasterLevelDetails() {
        int currCasterLevel;
        PCClass aClass;
        int levelAdjust = 0;
        for (AbilityFacade feat : this.selMetamagicFeats) {
            levelAdjust += ((Ability)feat).getSafe(IntegerKey.ADD_SPELL_LEVEL);
        }
        int minClassLevel = 1;
        int maxClassLevel = 20;
        InfoFacade castingClass = this.pcClass.getReference();
        if (castingClass instanceof PCClass) {
            aClass = (PCClass)castingClass;
        } else if (castingClass instanceof Domain) {
            aClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, "Cleric");
        } else {
            Logging.errorPrint("Found Casting Class in recalc that was not a Class or Domain: " + castingClass.getClass());
            return;
        }
        if (aClass != null) {
            minClassLevel = this.character.getSpellSupport(aClass).getMinLevelForSpellLevel(this.spellLevel.getReference() + levelAdjust, true);
            minClassLevel = Math.max(1, minClassLevel);
            if (aClass.hasMaxLevel()) {
                maxClassLevel = aClass.getSafe(IntegerKey.LEVEL_LIMIT);
            }
        }
        this.updateAvailCasterLevels(minClassLevel, maxClassLevel);
        int n = currCasterLevel = this.casterLevel.getReference() == null ? 0 : this.casterLevel.getReference();
        if (currCasterLevel < minClassLevel) {
            this.casterLevel.setReference(minClassLevel);
        } else if (currCasterLevel > maxClassLevel) {
            this.casterLevel.setReference(maxClassLevel);
        }
    }

    private List<String> getSpellTypeList() {
        ArrayList<String> spellTypes = new ArrayList<String>();
        InfoFacade castingClass = this.pcClass.getReference();
        if (castingClass instanceof PCClass) {
            spellTypes.add(((PCClass)castingClass).getSpellType());
        } else if (castingClass instanceof Domain) {
            spellTypes.add("Divine");
        } else {
            Logging.errorPrint("Found Casting Class that was not a Class or Domain: " + castingClass.getClass());
        }
        return spellTypes;
    }

    private boolean canCreateItem(Spell aSpell) {
        if (this.requiredType == Type.NONE) {
            return true;
        }
        return aSpell.isAllowed(this.requiredType);
    }

    @Override
    public void setClass(InfoFacade classFacade) {
        this.pcClass.setReference(classFacade);
        this.spellList = classFacade instanceof Domain ? (CDOMList)((Domain)classFacade).get(ObjectKey.DOMAIN_SPELLLIST) : (CDOMList)((PCClass)classFacade).get(ObjectKey.CLASS_SPELLLIST);
        this.classSpells = new ArrayList<AvailableSpell>();
        for (AvailableSpell availSpell : this.masterAvailableSpellFacet.getAllSpellsInList(this.spellList, this.datasetID)) {
            if (!this.canCreateItem(availSpell.getSpell())) continue;
            this.classSpells.add(availSpell);
        }
        if (this.spellLevel.getReference() == null) {
            this.spellLevel.setReference(this.availSpellLevels.getElementAt(0));
        }
        this.processLevelChange();
    }

    @Override
    public ReferenceFacade<InfoFacade> getClassRef() {
        return this.pcClass;
    }

    @Override
    public ListFacade<InfoFacade> getClasses() {
        return this.availClasses;
    }

    @Override
    public void setSpellLevel(Integer newSpellLevel) {
        this.spellLevel.setReference(newSpellLevel);
        this.processLevelChange();
    }

    @Override
    public ListFacade<Integer> getLevels() {
        return this.availSpellLevels;
    }

    @Override
    public ReferenceFacade<Integer> getSpellLevelRef() {
        return this.spellLevel;
    }

    @Override
    public void setSpell(InfoFacade spellFacade) {
        if (spellFacade instanceof Spell) {
            this.selectSpell((Spell)spellFacade);
        }
    }

    @Override
    public ReferenceFacade<InfoFacade> getSpellRef() {
        return this.spell;
    }

    @Override
    public ListFacade<InfoFacade> getSpells() {
        return this.availSpells;
    }

    @Override
    public void setVariant(String newVariant) {
        this.variant.setReference(newVariant);
    }

    @Override
    public ReferenceFacade<String> getVariantRef() {
        return this.variant;
    }

    @Override
    public ListFacade<String> getVariants() {
        return this.availVariants;
    }

    @Override
    public void setCasterLevel(Integer newCasterLevel) {
        this.casterLevel.setReference(newCasterLevel);
    }

    @Override
    public ReferenceFacade<Integer> getCasterLevelRef() {
        return this.casterLevel;
    }

    @Override
    public ListFacade<Integer> getCasterLevels() {
        return this.availCasterlevels;
    }

    @Override
    public void setSpellType(String newSpellType) {
        this.spellType.setReference(newSpellType);
    }

    @Override
    public ReferenceFacade<String> getSpellTypeRef() {
        return this.spellType;
    }

    @Override
    public ListFacade<String> getSpellTypes() {
        return this.availSpellTypes;
    }

    @Override
    public void setSelectedMetamagicFeats(Object[] newFeats) {
        ArrayList<AbilityFacade> chosenFeats = new ArrayList<AbilityFacade>();
        for (Object choice : newFeats) {
            if (!(choice instanceof AbilityFacade)) continue;
            chosenFeats.add((AbilityFacade)choice);
        }
        this.selMetamagicFeats.setContents(chosenFeats);
        this.recalcCasterLevelDetails();
    }

    @Override
    public ListFacade<AbilityFacade> getSelectedMetamagicFeats() {
        return this.selMetamagicFeats;
    }

    @Override
    public ListFacade<AbilityFacade> getAvailMetamagicFeats() {
        return this.availMetamagicFeats;
    }
}

