/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.filter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JToggleButton;
import org.apache.commons.lang.StringUtils;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.filter.DisplayableFilter;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterHandler;
import pcgen.system.PropertyContext;

public class FilterButton<C, E>
extends JToggleButton
implements DisplayableFilter<C, E>,
ActionListener {
    private FilterHandler filterHandler;
    private Filter<C, E> filter;
    private PropertyContext filterContext;

    public FilterButton(String prefKey) {
        this(prefKey, false);
    }

    public FilterButton(String prefKey, boolean defaultSelectedState) {
        if (StringUtils.isEmpty(prefKey)) {
            throw new NullPointerException("prefKey cannot be null");
        }
        this.addActionListener(this);
        UIPropertyContext baseContext = UIPropertyContext.createContext("filterPrefs");
        this.filterContext = ((PropertyContext)baseContext).createChildContext(prefKey);
        this.setSelected(this.filterContext.initBoolean("active", defaultSelectedState));
    }

    @Override
    public Component getFilterComponent() {
        return this;
    }

    @Override
    public void setFilterHandler(FilterHandler handler) {
        this.filterHandler = handler;
    }

    public void setFilter(Filter<C, E> filter) {
        this.filter = filter;
    }

    @Override
    public boolean accept(C context, E element) {
        return !this.isEnabled() || !this.isSelected() || this.filter.accept(context, element);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.filterHandler.refilter();
        this.filterContext.setBoolean("active", this.isSelected());
    }
}

