/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.StateEditable;
import pcgen.cdom.enumeration.Nature;
import pcgen.facade.core.AbilityCategoryFacade;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DelegatingListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilterHandler;
import pcgen.gui2.filter.FilterUtilities;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.TodoHandler;
import pcgen.gui2.tabs.ability.AbilityTreeTableModel;
import pcgen.gui2.tabs.ability.AbilityTreeViews;
import pcgen.gui2.tabs.ability.CategoryTableModel;
import pcgen.gui2.tabs.models.CharacterTreeCellRenderer;
import pcgen.gui2.tabs.models.ConcurrentDataView;
import pcgen.gui2.tabs.models.QualifiedTreeCellRenderer;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.JTreeTable;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.system.LanguageBundle;

public class AbilityChooserTab
extends FlippingSplitPane
implements StateEditable,
TodoHandler {
    private final FilteredTreeViewTable<CharacterFacade, AbilityFacade> availableTreeViewPanel = new FilteredTreeViewTable();
    private final JTreeTable selectedTreeViewPanel = new JTreeTable();
    private final JTable categoryTable = new JTable();
    private final InfoPane infoPane = new InfoPane();
    private final JButton addButton = new JButton();
    private final JButton removeButton = new JButton();
    private final FilterBar<CharacterFacade, AbilityCategoryFacade> categoryBar = new FilterBar();
    private final FilterButton<CharacterFacade, AbilityFacade> qFilterButton = new FilterButton("AbilityQualified");
    private final QualifiedTreeCellRenderer qualifiedRenderer = new QualifiedTreeCellRenderer();
    private final AbilityRenderer abilityRenderer = new AbilityRenderer();

    public AbilityChooserTab() {
        super("ability");
        this.initComponents();
    }

    private void initComponents() {
        this.setOrientation(0);
        this.availableTreeViewPanel.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.availableTreeViewPanel.setTreeCellRenderer(this.qualifiedRenderer);
        this.selectedTreeViewPanel.setTreeCellRenderer(this.abilityRenderer);
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        this.qFilterButton.setText(LanguageBundle.getString("in_igQualFilter"));
        filterBar.addDisplayableFilter(this.qFilterButton);
        JPanel availPanel = FilterUtilities.configureFilteredTreeViewPane(this.availableTreeViewPanel, filterBar);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.addButton.setHorizontalTextPosition(10);
        box.add(this.addButton);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        availPanel.add((Component)box, "South");
        JPanel selPanel = new JPanel(new BorderLayout());
        selPanel.add((Component)new JScrollPane(this.selectedTreeViewPanel), "Center");
        AbilityTreeTableModel.initializeTreeTable(this.selectedTreeViewPanel);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(this.removeButton);
        box.add(Box.createHorizontalGlue());
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        selPanel.add((Component)box, "South");
        FlippingSplitPane topPane = new FlippingSplitPane(1, true, availPanel, selPanel, "abilityTop");
        this.setTopComponent(topPane);
        FilterButton<CharacterFacade, AbilityCategoryFacade> gainedFilterButton = new FilterButton<CharacterFacade, AbilityCategoryFacade>("AbilityGained", true);
        gainedFilterButton.setText(LanguageBundle.getString("in_gained"));
        gainedFilterButton.setEnabled(true);
        gainedFilterButton.setFilter(new Filter<CharacterFacade, AbilityCategoryFacade>(){

            @Override
            public boolean accept(CharacterFacade context, AbilityCategoryFacade element) {
                return context.getActiveAbilityCategories().containsElement(element);
            }
        });
        this.categoryBar.addDisplayableFilter(gainedFilterButton);
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.add(this.categoryBar, "North");
        filterPanel.add((Component)new JScrollPane(this.categoryTable), "Center");
        FlippingSplitPane bottomPane = new FlippingSplitPane(1, "abilityBottom");
        bottomPane.setLeftComponent(filterPanel);
        bottomPane.setRightComponent(this.infoPane);
        this.setBottomComponent(bottomPane);
    }

    public Hashtable<Object, Object> createState(CharacterFacade character, ListFacade<AbilityCategoryFacade> categories, ListFacade<AbilityCategoryFacade> fullCategoryList, String title) {
        Hashtable<Object, Object> state = new Hashtable<Object, Object>();
        CategoryTableModel categoryTableModel = new CategoryTableModel(character, fullCategoryList, this.categoryBar, this.categoryTable);
        state.put(CategoryTableModel.class, categoryTableModel);
        DefaultListSelectionModel listModel = new DefaultListSelectionModel();
        listModel.setSelectionMode(0);
        state.put(ListSelectionModel.class, listModel);
        state.put(AbilityTreeTableModel.class, new AbilityTreeTableModel(character, categories));
        state.put(AvailableAbilityTreeViewModel.class, new AvailableAbilityTreeViewModel(character, fullCategoryList, listModel, title));
        state.put(InfoHandler.class, new InfoHandler(character, categories));
        state.put(TreeRendererHandler.class, new TreeRendererHandler(character));
        state.put(AddAction.class, new AddAction(character));
        state.put(RemoveAction.class, new RemoveAction(character));
        state.put(AbilityFilterHandler.class, new AbilityFilterHandler(character));
        state.put(CategoryFilterHandler.class, new CategoryFilterHandler(categoryTableModel));
        return state;
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        ((InfoHandler)state.get(InfoHandler.class)).uninstall();
        ((AvailableAbilityTreeViewModel)state.get(AvailableAbilityTreeViewModel.class)).uninstall();
        this.categoryTable.setSelectionModel(new DefaultListSelectionModel());
        ((CategoryTableModel)state.get(CategoryTableModel.class)).uninstall();
        ((AddAction)state.get(AddAction.class)).uninstall();
        ((RemoveAction)state.get(RemoveAction.class)).uninstall();
        ((TreeRendererHandler)state.get(TreeRendererHandler.class)).uninstall();
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        ((CategoryFilterHandler)state.get(CategoryFilterHandler.class)).install();
        ((AbilityFilterHandler)state.get(AbilityFilterHandler.class)).install();
        this.categoryTable.setModel((CategoryTableModel)state.get(CategoryTableModel.class));
        this.categoryTable.setSelectionModel((ListSelectionModel)state.get(ListSelectionModel.class));
        ((TreeRendererHandler)state.get(TreeRendererHandler.class)).install();
        this.selectedTreeViewPanel.setTreeTableModel((AbilityTreeTableModel)state.get(AbilityTreeTableModel.class));
        this.selectedTreeViewPanel.sortModel();
        ((AvailableAbilityTreeViewModel)state.get(AvailableAbilityTreeViewModel.class)).install();
        this.addButton.setAction((AddAction)state.get(AddAction.class));
        this.removeButton.setAction((RemoveAction)state.get(RemoveAction.class));
        ((InfoHandler)state.get(InfoHandler.class)).install();
        ((CategoryTableModel)state.get(CategoryTableModel.class)).install();
        ((AddAction)state.get(AddAction.class)).install();
        ((RemoveAction)state.get(RemoveAction.class)).install();
        this.ensureCategorySelected();
    }

    private void ensureCategorySelected() {
        if (this.categoryTable.getSelectedRowCount() == 0) {
            CategoryTableModel model = (CategoryTableModel)this.categoryTable.getModel();
            model.refilter();
            if (model.getRowCount() > 0) {
                this.categoryTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    }

    @Override
    public void adviseTodo(String fieldName) {
        CategoryTableModel model = (CategoryTableModel)this.categoryTable.getModel();
        model.refilter();
        for (int i = 0; i < model.getRowCount(); ++i) {
            AbilityCategoryFacade category = model.getCategory(i);
            if (!category.getName().equals(fieldName)) continue;
            this.categoryTable.getSelectionModel().setSelectionInterval(i, i);
            return;
        }
    }

    private static class AbilityRenderer
    extends CharacterTreeCellRenderer {
        private AbilityRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            Object abilityObj = ((DefaultMutableTreeNode)value).getUserObject();
            if (abilityObj instanceof AbilityFacade) {
                AbilityFacade ability = (AbilityFacade)abilityObj;
                Nature nature = this.character.getAbilityNature(ability);
                if (nature == Nature.VIRTUAL) {
                    this.setForeground(UIPropertyContext.getVirtualColor());
                } else if (!this.character.isQualifiedFor(ability)) {
                    this.setForeground(UIPropertyContext.getNotQualifiedColor());
                } else if (nature == Nature.AUTOMATIC) {
                    this.setForeground(UIPropertyContext.getAutomaticColor());
                }
            }
            return this;
        }
    }

    private class TreeRendererHandler {
        private final CharacterFacade character;

        public TreeRendererHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            AbilityChooserTab.this.abilityRenderer.setCharacter(this.character);
            AbilityChooserTab.this.qualifiedRenderer.setCharacter(this.character);
        }

        public void uninstall() {
            AbilityChooserTab.this.abilityRenderer.setCharacter(null);
            AbilityChooserTab.this.qualifiedRenderer.setCharacter(null);
        }
    }

    private class CategoryFilterHandler
    implements FilterHandler {
        private final CategoryTableModel model;

        public CategoryFilterHandler(CategoryTableModel model) {
            this.model = model;
        }

        public void install() {
            AbilityChooserTab.this.categoryBar.setFilterHandler(this);
            this.refilter();
        }

        @Override
        public void refilter() {
            this.model.refilter();
        }

        @Override
        public void scrollToTop() {
        }

        @Override
        public void setSearchEnabled(boolean enable) {
        }
    }

    private class AbilityFilterHandler {
        private final Filter<CharacterFacade, AbilityFacade> qFilter = new Filter<CharacterFacade, AbilityFacade>(){

            @Override
            public boolean accept(CharacterFacade context, AbilityFacade element) {
                return AbilityFilterHandler.this.character.isQualifiedFor(element);
            }
        };
        private final CharacterFacade character;

        public AbilityFilterHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            AbilityChooserTab.this.qFilterButton.setFilter(this.qFilter);
        }
    }

    private class RemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        private CharacterFacade character;
        private AbilityCategoryFacade abilityCat;

        public RemoveAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_removeSelected"));
            this.character = character;
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path;
            DefaultMutableTreeNode node;
            Object category;
            if (!this.abilityCat.isEditable()) {
                return;
            }
            int selectedRow = AbilityChooserTab.this.selectedTreeViewPanel.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            Object data = AbilityChooserTab.this.selectedTreeViewPanel.getModel().getValueAt(selectedRow, 0);
            if (data != null && data instanceof AbilityFacade && (category = (node = (DefaultMutableTreeNode)(path = AbilityChooserTab.this.selectedTreeViewPanel.getTree().getPathForRow(selectedRow)).getParentPath().getLastPathComponent()).getUserObject()) instanceof AbilityCategoryFacade) {
                this.character.removeAbility((AbilityCategoryFacade)category, (AbilityFacade)data);
                AbilityChooserTab.this.availableTreeViewPanel.refilter();
            }
        }

        public void install() {
            AbilityChooserTab.this.selectedTreeViewPanel.addActionListener(this);
            AbilityChooserTab.this.categoryTable.getSelectionModel().addListSelectionListener(this);
        }

        public void uninstall() {
            AbilityChooserTab.this.selectedTreeViewPanel.removeActionListener(this);
            AbilityChooserTab.this.categoryTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index;
            if (!e.getValueIsAdjusting() && (index = AbilityChooserTab.this.categoryTable.getSelectionModel().getMinSelectionIndex()) != -1) {
                this.abilityCat = (AbilityCategoryFacade)AbilityChooserTab.this.categoryTable.getValueAt(index, 0);
                this.setEnabled(this.abilityCat.isEditable());
                this.putValue("ShortDescription", this.abilityCat.isEditable() ? null : LanguageBundle.getString("in_abCatNotEditable"));
            }
        }
    }

    private class AddAction
    extends AbstractAction
    implements ListSelectionListener {
        private CharacterFacade character;
        private AbilityCategoryFacade abilityCat;

        public AddAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_addSelected"));
            this.character = character;
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.abilityCat.isEditable()) {
                return;
            }
            Object data = AbilityChooserTab.this.availableTreeViewPanel.getSelectedObject();
            int index = AbilityChooserTab.this.categoryTable.getSelectedRow();
            if (data != null && data instanceof AbilityFacade && index != -1) {
                AbilityCategoryFacade category = (AbilityCategoryFacade)AbilityChooserTab.this.categoryTable.getValueAt(index, 0);
                this.character.addAbility(category, (AbilityFacade)data);
                AbilityChooserTab.this.availableTreeViewPanel.refilter();
                JTree tree = AbilityChooserTab.this.selectedTreeViewPanel.getTree();
                for (int i = 0; i < tree.getRowCount(); ++i) {
                    TreePath pathForRow = tree.getPathForRow(i);
                    if (!category.toString().equals(pathForRow.getLastPathComponent().toString())) continue;
                    tree.expandRow(i);
                }
            }
        }

        public void install() {
            AbilityChooserTab.this.availableTreeViewPanel.addActionListener(this);
            AbilityChooserTab.this.categoryTable.getSelectionModel().addListSelectionListener(this);
        }

        public void uninstall() {
            AbilityChooserTab.this.availableTreeViewPanel.removeActionListener(this);
            AbilityChooserTab.this.categoryTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index;
            if (!e.getValueIsAdjusting() && (index = AbilityChooserTab.this.categoryTable.getSelectionModel().getMinSelectionIndex()) != -1) {
                this.abilityCat = (AbilityCategoryFacade)AbilityChooserTab.this.categoryTable.getValueAt(index, 0);
                this.setEnabled(this.abilityCat.isEditable());
                this.putValue("ShortDescription", this.abilityCat.isEditable() ? null : LanguageBundle.getString("in_abCatNotEditable"));
            }
        }
    }

    private class InfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;
        private final ListFacade<AbilityCategoryFacade> categories;
        private String text;
        private String title;

        public InfoHandler(CharacterFacade character, ListFacade<AbilityCategoryFacade> categories) {
            this.character = character;
            this.categories = categories;
            this.text = "";
            this.title = LanguageBundle.getString("in_abInfo");
        }

        public void install() {
            AbilityChooserTab.this.availableTreeViewPanel.getSelectionModel().addListSelectionListener(this);
            AbilityChooserTab.this.selectedTreeViewPanel.getSelectionModel().addListSelectionListener(this);
            AbilityChooserTab.this.categoryTable.getSelectionModel().addListSelectionListener(this);
            AbilityChooserTab.this.infoPane.setTitle(this.title);
            AbilityChooserTab.this.infoPane.setText(this.text);
        }

        public void uninstall() {
            AbilityChooserTab.this.availableTreeViewPanel.getSelectionModel().removeListSelectionListener(this);
            AbilityChooserTab.this.selectedTreeViewPanel.getSelectionModel().removeListSelectionListener(this);
            AbilityChooserTab.this.categoryTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object data = null;
                if (e.getSource() == AbilityChooserTab.this.availableTreeViewPanel.getSelectionModel()) {
                    data = AbilityChooserTab.this.availableTreeViewPanel.getSelectedObject();
                } else if (e.getSource() == AbilityChooserTab.this.selectedTreeViewPanel.getSelectionModel()) {
                    int index = AbilityChooserTab.this.selectedTreeViewPanel.getSelectedRow();
                    if (index != -1) {
                        data = AbilityChooserTab.this.selectedTreeViewPanel.getModel().getValueAt(index, 0);
                    }
                } else {
                    int index = AbilityChooserTab.this.categoryTable.getSelectionModel().getMinSelectionIndex();
                    if (index != -1) {
                        data = AbilityChooserTab.this.categoryTable.getValueAt(index, 0);
                    }
                }
                if (data != null) {
                    if (data instanceof AbilityFacade) {
                        this.text = this.character.getInfoFactory().getHTMLInfo((AbilityFacade)data);
                        AbilityChooserTab.this.infoPane.setText(this.text);
                    }
                    if (data instanceof AbilityCategoryFacade) {
                        this.title = LanguageBundle.getFormattedString("in_abCatInfo", ((AbilityCategoryFacade)data).getName());
                        AbilityChooserTab.this.infoPane.setTitle(this.title);
                    }
                } else {
                    this.text = "";
                    AbilityChooserTab.this.infoPane.setText("");
                }
            }
        }
    }

    private class AvailableAbilityTreeViewModel
    extends ConcurrentDataView<AbilityFacade>
    implements TreeViewModel<AbilityFacade>,
    ListSelectionListener,
    DataView<AbilityFacade> {
        private final ListFacade<? extends TreeView<AbilityFacade>> treeviews;
        private final CharacterFacade character;
        private final ListFacade<AbilityCategoryFacade> categories;
        private final ListSelectionModel selectionModel;
        private final List<? extends DataViewColumn> dataColumns;
        private final InfoFactory infoFactory;
        private final String title;
        private final DelegatingListFacade<AbilityFacade> delegate;

        public AvailableAbilityTreeViewModel(CharacterFacade character, ListFacade<AbilityCategoryFacade> categories, ListSelectionModel selectionModel, String tableTitle) {
            this.character = character;
            this.title = tableTitle;
            this.treeviews = new DefaultListFacade<TreeView<AbilityFacade>>(AbilityTreeViews.createTreeViewList(character));
            this.categories = categories;
            this.selectionModel = selectionModel;
            this.infoFactory = character.getInfoFactory();
            this.delegate = new DelegatingListFacade();
            this.delegate.setDelegate(new DefaultListFacade());
            selectionModel.addListSelectionListener(this);
            this.dataColumns = Arrays.asList(new DefaultDataViewColumn("in_type", String.class), new DefaultDataViewColumn("in_abColumnsMultiples", Boolean.class), new DefaultDataViewColumn("in_abColumnsStacks", Boolean.class), new DefaultDataViewColumn("in_abColumnsDescription", String.class), new DefaultDataViewColumn("in_abColumnsCost", Float.class), new DefaultDataViewColumn("in_abColumnsSource", String.class));
        }

        @Override
        public ListFacade<? extends TreeView<AbilityFacade>> getTreeViews() {
            return this.treeviews;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<AbilityFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<AbilityFacade> getDataModel() {
            return this.delegate;
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.dataColumns;
        }

        private String getTypes(List<String> types) {
            if (types.isEmpty()) {
                return "";
            }
            String ret = types.get(0);
            for (int x = 1; x < types.size(); ++x) {
                ret = ret + ", " + types.get(x);
            }
            return ret;
        }

        @Override
        public void install() {
            super.install();
            AbilityChooserTab.this.availableTreeViewPanel.setTreeViewModel(this);
            AbilityChooserTab.this.selectedTreeViewPanel.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void uninstall() {
            super.uninstall();
            AbilityChooserTab.this.selectedTreeViewPanel.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (e.getSource() == this.selectionModel) {
                int index = this.selectionModel.getMinSelectionIndex();
                if (index != -1) {
                    this.delegate.setDelegate(this.character.getDataSet().getAbilities().getValue((AbilityCategoryFacade)AbilityChooserTab.this.categoryTable.getValueAt(index, 0)));
                }
            } else {
                Object data;
                int index = AbilityChooserTab.this.selectedTreeViewPanel.getSelectedRow();
                if (index != -1 && index < AbilityChooserTab.this.selectedTreeViewPanel.getRowCount() && (data = AbilityChooserTab.this.selectedTreeViewPanel.getValueAt(index, 0)) instanceof AbilityCategoryFacade) {
                    this.delegate.setDelegate(this.character.getDataSet().getAbilities().getValue((AbilityCategoryFacade)data));
                    for (int i = 0; i < AbilityChooserTab.this.categoryTable.getRowCount(); ++i) {
                        Object catData = AbilityChooserTab.this.categoryTable.getValueAt(i, 0);
                        if (catData != data) continue;
                        AbilityChooserTab.this.categoryTable.setRowSelectionInterval(i, i);
                    }
                }
            }
        }

        @Override
        public String getPrefsKey() {
            return this.title;
        }

        @Override
        protected List<?> getDataList(AbilityFacade obj) {
            return Arrays.asList(this.getTypes(obj.getTypes()), obj.isMult(), obj.isStackable(), this.infoFactory.getDescription(obj), (int)obj.getCost(), obj.getSource());
        }

        @Override
        protected void refreshTableData() {
            AbilityChooserTab.this.availableTreeViewPanel.refreshModelData();
        }
    }

    private static final class BooleanRenderer
    extends DefaultTableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        protected void setValue(Object value) {
            if (value == Boolean.TRUE) {
                this.setText(LanguageBundle.getString("in_yes"));
            } else if (value == Boolean.FALSE) {
                this.setText(LanguageBundle.getString("in_no"));
            } else {
                this.setText("");
            }
        }
    }
}

