/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.bio;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

class ThumbnailPane
extends JComponent {
    private BufferedImage portrait;
    private Rectangle cropRect;

    public ThumbnailPane() {
        this.setDoubleBuffered(true);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    public void setPortraitImage(BufferedImage portrait) {
        this.portrait = portrait;
        this.refreshImage();
    }

    public void setCropRectangle(Rectangle cropRect) {
        this.cropRect = new Rectangle(cropRect);
        this.refreshImage();
    }

    private void refreshImage() {
        if (this.cropRect != null) {
            if (this.cropRect.x + this.cropRect.width > this.portrait.getWidth()) {
                this.cropRect.x = this.portrait.getWidth() - this.cropRect.width;
            }
            if (this.cropRect.y + this.cropRect.height > this.portrait.getHeight()) {
                this.cropRect.y = this.portrait.getHeight() - this.cropRect.height;
            }
            if (this.cropRect.x < 0 || this.cropRect.y < 0) {
                this.cropRect = null;
            }
        }
        if (this.cropRect != null) {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int width = 0;
        int height = 0;
        if (insets != null) {
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
        }
        return new Dimension(width += 100, height += 100);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.portrait == null || this.cropRect == null) {
            return;
        }
        Insets insets = this.getInsets();
        g.drawImage(this.portrait.getSubimage(this.cropRect.x, this.cropRect.y, this.cropRect.width, this.cropRect.height), insets.left, insets.top, 100, 100, this);
    }
}

