/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import pcgen.gui2.util.JTableEx;
import pcgen.gui2.util.TreeColumnCellRenderer;
import pcgen.gui2.util.table.SortableTableModel;
import pcgen.gui2.util.treetable.DefaultSortableTreeTableModel;
import pcgen.gui2.util.treetable.SortableTreeTableModel;
import pcgen.gui2.util.treetable.TreeTableModel;
import pcgen.gui2.util.treetable.TreeTableNode;
import pcgen.util.Logging;

public class JTreeTable
extends JTableEx {
    private static final long serialVersionUID = -3571248405124682593L;
    private TreeTableCellRenderer tree = new TreeTableCellRenderer();
    private TreeTableModelAdapter adapter;

    public JTreeTable() {
        this((TreeTableModel)null);
    }

    public JTreeTable(TreeTableModel treeTableModel) {
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.adapter = new TreeTableModelAdapter(this.tree);
        this.setTreeTableModel(treeTableModel);
        super.setModel(this.adapter);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableNode.class, this.tree);
        this.setDefaultEditor(TreeTableNode.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        } else {
            this.setRowHeight(this.tree.getRowHeight());
        }
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.tree.getModel();
    }

    public void setTreeTableModel(TreeTableModel model) {
        if (model != null && !(model instanceof SortableTreeTableModel)) {
            model = new DefaultSortableTreeTableModel(model);
        }
        this.tree.setModel(model);
        this.adapter.setTreeTableModel((SortableTreeTableModel)model);
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableNode.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int aRowHeight) {
        super.setRowHeight(aRowHeight);
        if (this.tree != null && this.tree.getRowHeight() != aRowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.tree.getCellRenderer();
    }

    public void setTreeCellRenderer(TreeColumnCellRenderer renderer) {
        this.tree.setCellRenderer(renderer);
    }

    @Override
    public void scrollRectToVisible(Rectangle aRect) {
        Container parent;
        int dx = this.getX();
        int dy = this.getY();
        for (parent = this.getParent(); parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane); parent = parent.getParent()) {
            Rectangle bounds = parent.getBounds();
            dx += bounds.x;
            dy += bounds.y;
        }
        if (parent != null && !(parent instanceof CellRendererPane)) {
            aRect.x += dx;
            aRect.y += dy;
            ((JComponent)parent).scrollRectToVisible(aRect);
            aRect.x -= dx;
            aRect.y -= dy;
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    private void scrollPathToVisible(TreePath path) {
        if (path != null) {
            this.tree.makeVisible(path);
            Rectangle bounds = this.tree.getPathBounds(path);
            if (bounds != null) {
                this.scrollRectToVisible(bounds);
            }
        }
    }

    public void addPopupMenu(JPopupMenu aPopupMenu) {
        this.addMouseListener(new PopupListener(this, aPopupMenu));
    }

    private class PopupListener
    extends MouseAdapter {
        private JPopupMenu theMenu;
        private JTree theTree;

        private PopupListener(JTreeTable treeTable, JPopupMenu aMenu) {
            this.theTree = treeTable.getTree();
            this.theMenu = aMenu;
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                TreePath selPath = this.theTree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (selPath == null) {
                    return;
                }
                if (this.theTree.isSelectionEmpty()) {
                    this.theTree.setSelectionPath(selPath);
                    this.theMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else if (!this.theTree.isPathSelected(selPath)) {
                    this.theTree.setSelectionPath(selPath);
                    this.theMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    this.theTree.addSelectionPath(selPath);
                    this.theMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        }
    }

    private final class TreeTableCellEditor
    implements TableCellEditor {
        private TreeTableCellEditor() {
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != TreeTableNode.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    int column = JTreeTable.this.columnAtPoint(me.getPoint());
                    Rectangle cell = JTreeTable.this.getCellRect(0, column, true);
                    MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger());
                    newME.translatePoint(-cell.x, 0);
                    JTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    private final class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        static final long serialVersionUID = -3571248405124682593L;
        private boolean updatingListSelectionModel;

        private ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        private ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        private ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int[] sRows = JTreeTable.this.getSelectedRows();
                    if (sRows == null || sRows.length == 0) {
                        return;
                    }
                    int count = 0;
                    for (int i = 0; i < sRows.length; ++i) {
                        if (JTreeTable.this.tree.getPathForRow(sRows[i]) == null) continue;
                        ++count;
                    }
                    if (count == 0) {
                        return;
                    }
                    TreePath[] tps = new TreePath[count];
                    count = 0;
                    for (int i = 0; i < sRows.length; ++i) {
                        TreePath tp = JTreeTable.this.tree.getPathForRow(sRows[i]);
                        if (tp == null) continue;
                        tps[count++] = tp;
                    }
                    this.setSelectionPaths(tps);
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        final class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    final class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private int visibleRow;
        private DefaultTableCellRenderer tableCellRenderer;

        public TreeTableCellRenderer() {
            this.tableCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public void setBounds(int x, int y, int width, int height) {
                    super.setBounds(x, y, width, height);
                    TreeTableCellRenderer.this.setBounds(x, y, width, height);
                }

                @Override
                public void paint(Graphics g) {
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    TreeTableCellRenderer.this.paint(g);
                    this.paintBorder(g);
                }

                @Override
                protected void setValue(Object value) {
                    super.setValue(value);
                    this.setToolTipText(this.getText());
                }
            };
            this.setCellRenderer(new TreeColumnCellRenderer());
            this.setOpaque(false);
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        @Override
        public void setRowHeight(int aRowHeight) {
            super.setRowHeight(aRowHeight);
            if (aRowHeight > 0 && JTreeTable.this != null && JTreeTable.this.getRowHeight() != aRowHeight) {
                JTreeTable.this.setRowHeight(aRowHeight);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.visibleRow = row;
            Component comp = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBackground(comp.getBackground());
            return comp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Rectangle rect = JTreeTable.this.getCellRect(this.visibleRow, 0, true);
            int offset = -rect.y;
            g.translate(0, offset);
            try {
                super.paint(g);
            }
            catch (Exception e) {
                Logging.errorPrint("Paint Exception", e);
            }
            finally {
                g.translate(0, -offset);
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }
    }

    private static class TreeTableModelAdapter
    extends AbstractTableModel
    implements SortableTableModel,
    TreeModelListener,
    TreeExpansionListener {
        private JTree tree;
        private SortableTreeTableModel treeTableModel;

        TreeTableModelAdapter(JTree tree) {
            this.tree = tree;
            tree.addTreeExpansionListener(this);
        }

        public void setTreeTableModel(SortableTreeTableModel model) {
            if (this.treeTableModel != null) {
                this.treeTableModel.removeTreeModelListener(this);
            }
            this.treeTableModel = model;
            if (this.treeTableModel != null) {
                this.treeTableModel.addTreeModelListener(this);
            }
            this.fireTableStructureChanged();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (this.treeTableModel == null) {
                return false;
            }
            return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (this.treeTableModel == null) {
                return Object.class;
            }
            return this.treeTableModel.getColumnClass(column);
        }

        @Override
        public int getColumnCount() {
            if (this.treeTableModel == null) {
                return 0;
            }
            return this.treeTableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            if (this.treeTableModel == null) {
                return null;
            }
            return this.treeTableModel.getColumnName(column);
        }

        @Override
        public int getRowCount() {
            return this.tree.getRowCount();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (this.treeTableModel == null) {
                return;
            }
            this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.treeTableModel == null) {
                return null;
            }
            return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
        }

        private Object nodeForRow(int row) {
            TreePath treePath = this.tree.getPathForRow(row);
            if (treePath != null) {
                return treePath.getLastPathComponent();
            }
            return null;
        }

        @Override
        public void sortModel(Comparator<List<?>> comparator) {
            if (this.treeTableModel == null) {
                return;
            }
            Enumeration<TreePath> paths = this.tree.getExpandedDescendants(new TreePath(this.treeTableModel.getRoot()));
            TreePath[] selectionPaths = this.tree.getSelectionPaths();
            this.treeTableModel.sortModel(comparator);
            if (paths != null) {
                while (paths.hasMoreElements()) {
                    this.tree.expandPath(paths.nextElement());
                }
            }
            this.tree.setSelectionPaths(selectionPaths);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreePath parentPath = e.getTreePath();
            int leadingRow = Integer.MAX_VALUE;
            int trailingRow = -1;
            if (e.getChildren() != null) {
                for (Object node : e.getChildren()) {
                    TreePath childPath = parentPath.pathByAddingChild(node);
                    int row = this.tree.getRowForPath(childPath);
                    leadingRow = Math.min(leadingRow, row);
                    trailingRow = Math.max(trailingRow, row);
                }
            }
            this.fireTableRowsUpdated(leadingRow, trailingRow);
        }

        private void fireDelayedTableDataChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeTableModelAdapter.this.fireTableDataChangedPreservingSelection();
                }
            });
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.fireDelayedTableDataChanged();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.fireDelayedTableDataChanged();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.fireDelayedTableDataChanged();
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            this.fireTableDataChangedPreservingSelection();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            this.fireTableDataChangedPreservingSelection();
        }

        private void fireTableDataChangedPreservingSelection() {
            TreeSelectionModel selModel = this.tree.getSelectionModel();
            TreePath leadSelectionPath = selModel.getLeadSelectionPath();
            this.fireTableDataChanged();
            if (leadSelectionPath != null) {
                selModel.setSelectionPath(leadSelectionPath);
            }
        }
    }
}

