/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.rules.context.LoadContext;

public class TraitLoader
extends LstLineFileLoader {
    private int traitType = -1;

    @Override
    public void loadLstFile(LoadContext context, URI fileName) throws PersistenceLayerException {
        this.traitType = -1;
        super.loadLstFile(context, fileName);
    }

    @Override
    public void parseLine(LoadContext context, String lstLine, URI sourceURI) {
        if (lstLine.charAt(0) != '[') {
            switch (this.traitType) {
                case 0: {
                    SystemCollections.addToTraitList(lstLine.intern(), this.gameMode);
                    break;
                }
                case 1: {
                    SystemCollections.addToSpeechList(lstLine.intern(), this.gameMode);
                    break;
                }
                case 2: {
                    SystemCollections.addToPhraseList(lstLine.intern(), this.gameMode);
                    break;
                }
                case 3: {
                    SystemCollections.addToPhobiaList(lstLine.intern(), this.gameMode);
                    break;
                }
                case 4: {
                    SystemCollections.addToInterestsList(lstLine.intern(), this.gameMode);
                    break;
                }
                case 5: {
                    SystemCollections.addToHairStyleList(lstLine.intern(), this.gameMode);
                    break;
                }
            }
        } else {
            this.traitType = lstLine.startsWith("[TRAIT]") ? 0 : (lstLine.startsWith("[SPEECH]") ? 1 : (lstLine.startsWith("[PHRASE]") ? 2 : (lstLine.startsWith("[PHOBIA]") ? 3 : (lstLine.startsWith("[INTERESTS]") ? 4 : (lstLine.startsWith("[HAIRSTYLE]") ? 5 : -1)))));
        }
    }
}

