/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.util.regex.Pattern;
import pcgen.core.term.TermEvaulatorException;

public class TermUtilities {
    public static final String dString = "(?:NOT|ADD|IS)";
    public static final Pattern dPat = Pattern.compile("(?:NOT|ADD|IS)");
    public static final String sString = "(?:EQUIPPED|NOTEQUIPPED)";
    public static final Pattern sPat = Pattern.compile("(?:EQUIPPED|NOTEQUIPPED)");

    public static void checkEqTypeTypesArray(String originalText, String[] types, int first) throws TermEvaulatorException {
        int cur = first + 1;
        while (cur < types.length) {
            if (dPat.matcher(types[cur]).matches()) {
                if (++cur >= types.length) {
                    StringBuilder sB = new StringBuilder();
                    sB.append(types[cur - 1]);
                    sB.append(" must be followed by a type in ");
                    sB.append(originalText);
                    throw new TermEvaulatorException(sB.toString());
                }
                ++cur;
                continue;
            }
            if (sPat.matcher(types[cur]).matches() || "".equalsIgnoreCase(types[cur])) {
                ++cur;
                continue;
            }
            StringBuilder sB = new StringBuilder();
            sB.append("Spurious type \"");
            sB.append(types[cur]);
            sB.append("\" in ");
            sB.append(originalText);
            throw new TermEvaulatorException(sB.toString());
        }
    }

    public static void checkEquipmentTypesArray(String originalText, String[] types, int first) throws TermEvaulatorException {
        int cur = first;
        while (cur < types.length) {
            if (dPat.matcher(types[cur]).matches()) {
                if (++cur >= types.length) {
                    StringBuilder sB = new StringBuilder();
                    sB.append(types[cur - 1]);
                    sB.append(" must be followed by a type in ");
                    sB.append(originalText);
                    throw new TermEvaulatorException(sB.toString());
                }
                ++cur;
                continue;
            }
            if ("".equalsIgnoreCase(types[cur])) {
                ++cur;
                continue;
            }
            StringBuilder sB = new StringBuilder();
            sB.append("Spurious type \"");
            sB.append(types[cur]);
            sB.append("\" in ");
            sB.append(originalText);
            throw new TermEvaulatorException(sB.toString());
        }
    }

    public static String extractContentsOfBrackets(String expressionString, String src, int fixed) throws TermEvaulatorException {
        int expEnd = expressionString.lastIndexOf("]");
        if (expEnd != expressionString.length() - 1) {
            StringBuilder sB = new StringBuilder();
            sB.append("Badly formed formula ");
            sB.append(expressionString);
            if (!"".equals(src)) {
                sB.append(" in ");
                sB.append(src);
            }
            sB.append(" following \"");
            sB.append(expressionString.substring(0, fixed));
            throw new TermEvaulatorException(sB.toString());
        }
        return expressionString.substring(fixed, expEnd);
    }

    public static int[] splitAndConvertIntegers(String expressionString, String clause, int numOfFields) throws TermEvaulatorException {
        String[] sA = clause.split("\\.", numOfFields);
        if (sA.length < numOfFields) {
            StringBuilder sB = new StringBuilder();
            sB.append("Invalid string ");
            sB.append(clause);
            sB.append(" following ");
            sB.append(expressionString);
            sB.append(" should be ");
            sB.append(numOfFields);
            sB.append(" integers separated by dots");
            throw new TermEvaulatorException(sB.toString());
        }
        int[] fields = new int[numOfFields];
        int index = 0;
        for (String field : clause.split("\\.", numOfFields)) {
            fields[index++] = Integer.parseInt(field);
        }
        return fields;
    }

    public static int[] convertToIntegers(String expressionString, String intString, int fixed, int numToExtract) throws TermEvaulatorException {
        int[] nums;
        try {
            nums = TermUtilities.splitAndConvertIntegers(expressionString, intString, numToExtract);
        }
        catch (NumberFormatException n) {
            StringBuilder sB = new StringBuilder();
            sB.append("Invalid string following ");
            sB.append(expressionString.substring(0, fixed));
            sB.append(" in ");
            sB.append(expressionString);
            throw new TermEvaulatorException(sB.toString());
        }
        return nums;
    }
}

