/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.PatternMatchingReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCClass;
import pcgen.core.Skill;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.rules.persistence.token.PostDeferredToken;

public class CskillToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass>,
PostDeferredToken<PCClass> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    @Override
    public String getTokenName() {
        return "CSKILL";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass obj, String value) {
        boolean first = true;
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            if (".CLEAR".equals(tokText)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item", context);
                }
                context.getObjectContext().removeList(obj, ListKey.CLASS_SKILL);
            } else if (tokText.startsWith(".CLEAR.")) {
                String clearText = tokText.substring(7);
                if ("ALL".equals(clearText)) {
                    context.getObjectContext().removeFromList(obj, ListKey.CLASS_SKILL, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS));
                } else {
                    CDOMReference<Skill> ref = TokenUtilities.getTypeOrPrimitive(context, SKILL_CLASS, clearText);
                    if (ref == null) {
                        return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                    }
                    context.getObjectContext().removeFromList(obj, ListKey.CLASS_SKILL, ref);
                }
            } else if ("ALL".equals(tokText)) {
                foundAny = true;
                context.getObjectContext().addToList(obj, ListKey.CLASS_SKILL, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS));
            } else {
                foundOther = true;
                CDOMReference<Skill> ref = this.getSkillReference(context, tokText);
                if (ref == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                }
                context.getObjectContext().addToList(obj, ListKey.CLASS_SKILL, ref);
            }
            first = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private CDOMReference<Skill> getSkillReference(LoadContext context, String tokText) {
        if (tokText.endsWith("%")) {
            return new PatternMatchingReference<Skill>(Skill.class, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS), tokText);
        }
        return TokenUtilities.getTypeOrPrimitive(context, SKILL_CLASS, tokText);
    }

    @Override
    public String[] unparse(LoadContext context, PCClass obj) {
        Collection<CDOMReference<Skill>> added;
        Changes<CDOMReference<Skill>> changes = context.getObjectContext().getListChanges(obj, ListKey.CLASS_SKILL);
        ArrayList<String> list = new ArrayList<String>();
        Collection<CDOMReference<Skill>> removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty()) {
            if (changes.includesGlobalClear()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat(removedItems, "|.CLEAR."));
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((added = changes.getAdded()) != null && !added.isEmpty()) {
            list.add(ReferenceUtilities.joinLstFormat(added, "|"));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }

    @Override
    public Class<PCClass> getDeferredTokenClass() {
        return PCClass.class;
    }

    @Override
    public boolean process(LoadContext context, PCClass obj) {
        List<CDOMReference<Skill>> list = obj.getListFor(ListKey.CLASS_SKILL);
        if (list != null) {
            ClassSkillList csl = obj.get(ObjectKey.CLASS_SKILLLIST);
            CDOMDirectSingleRef<ClassSkillList> listref = new CDOMDirectSingleRef<ClassSkillList>(csl);
            for (CDOMReference<Skill> ref : list) {
                for (Skill sk : ref.getContainedObjects()) {
                    context.getListContext().addToMasterList(this.getTokenName(), obj, listref, sk);
                    context.commit();
                }
            }
        }
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

