/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.StringTokenizer;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.PatternMatchingReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class MonccskillToken
extends AbstractTokenWithSeparator<Race>
implements CDOMPrimaryToken<Race> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    @Override
    public String getTokenName() {
        return "MONCCSKILL";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Race race, String value) {
        boolean firstToken = true;
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        CDOMGroupRef<ClassSkillList> monsterList = context.getReferenceContext().getCDOMTypeReference(ClassSkillList.class, "Monster");
        while (tok.hasMoreTokens()) {
            CDOMReference skill;
            String tokText = tok.nextToken();
            if (".CLEAR".equals(tokText)) {
                if (!firstToken) {
                    return new ParseResult.Fail("Non-sensical situation was encountered while parsing " + this.getTokenName() + ": When used, .CLEAR must be the first argument", context);
                }
                context.getListContext().removeAllFromList(this.getTokenName(), race, monsterList);
            } else if (tokText.startsWith(".CLEAR.")) {
                String clearText = tokText.substring(7);
                skill = "ALL".equals(clearText) ? context.getReferenceContext().getCDOMAllReference(SKILL_CLASS) : this.getSkillReference(context, clearText);
                if (skill == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                }
                context.getListContext().removeFromList(this.getTokenName(), race, monsterList, skill);
            } else {
                if ("ALL".equals(tokText)) {
                    foundAny = true;
                    skill = context.getReferenceContext().getCDOMAllReference(SKILL_CLASS);
                } else {
                    foundOther = true;
                    skill = this.getSkillReference(context, tokText);
                }
                if (skill == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                }
                AssociatedPrereqObject apo = context.getListContext().addToList(this.getTokenName(), race, monsterList, skill);
                apo.setAssociation(AssociationKey.SKILL_COST, SkillCost.CROSS_CLASS);
            }
            firstToken = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private CDOMReference<Skill> getSkillReference(LoadContext context, String tokText) {
        if (tokText.endsWith("%")) {
            return new PatternMatchingReference<Skill>(Skill.class, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS), tokText);
        }
        return TokenUtilities.getTypeOrPrimitive(context, SKILL_CLASS, tokText);
    }

    @Override
    public String[] unparse(LoadContext context, Race race) {
        MapToList map;
        CDOMGroupRef<ClassSkillList> monsterList = context.getReferenceContext().getCDOMTypeReference(ClassSkillList.class, "Monster");
        AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), race, monsterList);
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty()) {
            if (changes.includesGlobalClear()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat(removedItems, "|.CLEAR."));
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((map = changes.getAddedAssociations()) != null && !map.isEmpty()) {
            Set added = map.getKeySet();
            for (CDOMReference ab : added) {
                for (AssociatedPrereqObject assoc : map.getListFor((Object)ab)) {
                    if (SkillCost.CROSS_CLASS.equals((Object)assoc.getAssociation(AssociationKey.SKILL_COST))) continue;
                    context.addWriteMessage("Skill Cost must be CROSS_CLASS for Token " + this.getTokenName());
                    return null;
                }
            }
            list.add(ReferenceUtilities.joinLstFormat(added, "|"));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

