/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.spell;

import java.util.Collection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.PrimitiveToken;

public class DescriptorToken
implements PrimitiveToken<Spell>,
PrimitiveFilter<Spell> {
    private static final Class<Spell> SPELL_CLASS = Spell.class;
    private String school;
    private CDOMReference<Spell> allSpells;

    @Override
    public boolean initialize(LoadContext context, Class<Spell> cl, String value, String args) {
        if (args != null) {
            return false;
        }
        this.school = value;
        this.allSpells = context.getReferenceContext().getCDOMAllReference(SPELL_CLASS);
        return true;
    }

    @Override
    public String getTokenName() {
        return "DESCRIPTOR";
    }

    @Override
    public Class<Spell> getReferenceClass() {
        return SPELL_CLASS;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.getTokenName() + "=" + this.school;
    }

    @Override
    public boolean allow(PlayerCharacter pc, Spell spell) {
        return spell.containsInList(ListKey.SPELL_DESCRIPTOR, this.school);
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DescriptorToken) {
            DescriptorToken other = (DescriptorToken)obj;
            if (this.school == null) {
                return other.school == null;
            }
            return this.school.equals(other.school);
        }
        return false;
    }

    public int hashCode() {
        return this.school == null ? -7 : this.school.hashCode();
    }

    @Override
    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Spell, R> c) {
        return c.convert(this.allSpells, this);
    }
}

