/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.plugin.Combatant;
import gmgen.plugin.Dice;
import gmgen.plugin.PcgCombatant;
import gmgen.plugin.PlayerCharacterOutput;
import gmgen.plugin.SystemAttribute;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.PCCheck;
import pcgen.core.PlayerCharacter;
import plugin.initiative.SaveModel;
import plugin.initiative.XMLCombatant;
import plugin.initiative.gui.Utils;

public class SavingThrowDialog
extends JDialog {
    public static final int NULL_SAVE = 0;
    public static final int FORT_SAVE = 1;
    public static final int REF_SAVE = 2;
    public static final int WILL_SAVE = 3;
    public static final int CANCEL_OPTION = 0;
    public static final int PASS_OPTION = 1;
    public static final int FAIL_OPTION = 2;
    private ButtonGroup saveTypeGroup;
    private Combatant cbt;
    private JButton cancelButton;
    private JButton failButton;
    private JButton passButton;
    private JButton rollButton;
    private JLabel characterName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton fortitudeSelection;
    private JRadioButton reflexSelection;
    private JRadioButton willSelection;
    private JSeparator jSeparator1;
    private JSlider saveDCSlider;
    private JSlider saveMagicSlider;
    private JSlider saveTempSlider;
    private JTextField saveAbility;
    private JTextField saveBase;
    private JFormattedTextField saveDC;
    private JFormattedTextField saveMagic;
    private JTextField saveMisc;
    private JFormattedTextField saveTemp;
    private JTextField saveTotal;
    private int lastRoll = 0;
    private int retValue = 0;
    private SaveModel m_saveModel;

    public SavingThrowDialog(Frame parent, boolean modal, Combatant cbt) {
        this(parent, modal, cbt, 0, 0);
    }

    public SavingThrowDialog(Frame parent, boolean modal, Combatant cbt, int dc, int saveType) {
        super(parent, modal);
        this.initComponents();
        this.cbt = cbt;
        this.setLocation(parent.getX() + 100, parent.getY() + 100);
        this.setCharacterName(cbt);
        this.setSaveType(dc, saveType);
        this.setDefaults(saveType);
    }

    public SavingThrowDialog(Frame parent, boolean modal, Combatant cbt, SaveModel model) {
        super(parent, modal);
        this.initComponents();
        this.cbt = cbt;
        this.setLocation(parent.getX() + 100, parent.getY() + 100);
        this.setCharacterName(cbt);
        int saveType = "FORTITUDE".equals(model.getSaveType()) ? 1 : ("REFLEX".equals(model.getSaveType()) ? 2 : ("WILL".equals(model.getSaveType()) ? 3 : 0));
        this.setSaveModel(model);
        this.setSaveType(model.getDc(), saveType);
        this.setDefaults(saveType);
    }

    private void setSaveModel(SaveModel model) {
        this.m_saveModel = model;
    }

    public int getDC() {
        return this.getFieldValue(this.saveDC);
    }

    public int getReturnValue() {
        return this.retValue;
    }

    public int getRoll() {
        return this.lastRoll;
    }

    public String getSaveAbbrev(int save) {
        if (save == 1) {
            return "Fort";
        }
        if (save == 2) {
            return "Ref";
        }
        if (save == 3) {
            return "Will";
        }
        return "";
    }

    public int getSaveType() {
        if (this.fortitudeSelection.isSelected()) {
            return 1;
        }
        if (this.reflexSelection.isSelected()) {
            return 2;
        }
        if (this.willSelection.isSelected()) {
            return 3;
        }
        return 0;
    }

    public int getTotal() {
        return this.getFieldValue(this.saveTotal);
    }

    private void setCharacterName(Combatant cbt) {
        this.setCharacterName(cbt.getName());
    }

    private void setCharacterName(String name) {
        this.characterName.setText(name);
    }

    private void setDefaults(int saveType) {
        int base = 0;
        int ability = 0;
        int magic = 0;
        int misc = 0;
        if (this.cbt instanceof PcgCombatant) {
            PcgCombatant pcgcbt = (PcgCombatant)this.cbt;
            PlayerCharacter pc = pcgcbt.getPC();
            new PlayerCharacterOutput(pc);
            List checkList = Globals.getContext().getReferenceContext().getOrderSortedCDOMObjects(PCCheck.class);
            if (saveType == 1) {
                PCCheck fort = (PCCheck)checkList.get(0);
                base = pc.calculateSaveBonus(fort, "BASE");
                ability = pc.calculateSaveBonus(fort, "STATMOD");
                magic = pc.calculateSaveBonus(fort, "MAGIC");
                misc = pc.calculateSaveBonus(fort, "MISC.NOMAGIC.NOSTAT");
            } else if (saveType == 2) {
                PCCheck ref = (PCCheck)checkList.get(1);
                base = pc.calculateSaveBonus(ref, "BASE");
                ability = pc.calculateSaveBonus(ref, "STATMOD");
                magic = pc.calculateSaveBonus(ref, "MAGIC");
                misc = pc.calculateSaveBonus(ref, "MISC.NOMAGIC.NOSTAT");
            } else if (saveType == 3) {
                PCCheck will = (PCCheck)checkList.get(2);
                base = pc.calculateSaveBonus(will, "BASE");
                ability = pc.calculateSaveBonus(will, "STATMOD");
                magic = pc.calculateSaveBonus(will, "MAGIC");
                misc = pc.calculateSaveBonus(will, "MISC.NOMAGIC.NOSTAT");
            }
        } else if (this.cbt instanceof XMLCombatant) {
            XMLCombatant xmlcbt = (XMLCombatant)this.cbt;
            if (saveType == 1) {
                int mod;
                ability = mod = new SystemAttribute("Constitution", xmlcbt.getAttribute("Constitution")).getModifier();
                base = xmlcbt.getSave("Fortitude") - mod;
            } else if (saveType == 2) {
                int mod;
                ability = mod = new SystemAttribute("Dexterity", xmlcbt.getAttribute("Dexterity")).getModifier();
                base = xmlcbt.getSave("Reflex") - mod;
            } else if (saveType == 3) {
                int mod;
                ability = mod = new SystemAttribute("Wisdom", xmlcbt.getAttribute("Wisdom")).getModifier();
                base = xmlcbt.getSave("Will") - mod;
            }
            magic = this.parseInt(this.saveMagic.getText());
            misc = this.parseInt(this.saveMisc.getText());
        }
        this.setDefaults(base, ability, magic, misc, this.parseInt(this.saveTemp.getText()));
    }

    private void setDefaults(int base, int ability, int magic, int misc, int temp) {
        this.saveBase.setText(Integer.toString(base));
        this.saveAbility.setText(Integer.toString(ability));
        this.saveMagic.setValue(magic);
        this.saveMisc.setText(Integer.toString(misc));
        this.saveTemp.setValue(temp);
        this.calculate();
    }

    private int getFieldValue(JTextField field) {
        try {
            return Integer.parseInt(field.getText());
        }
        catch (NumberFormatException e) {
            field.setText("0");
            return 0;
        }
    }

    private void setSaveType(int dc, int saveType) {
        this.saveDC.setValue(dc);
        if (saveType == 1) {
            this.fortitudeSelection.setSelected(true);
        } else if (saveType == 2) {
            this.reflexSelection.setSelected(true);
        } else if (saveType == 3) {
            this.willSelection.setSelected(true);
        }
    }

    private void setXMLCache(int total) {
        if (this.cbt instanceof XMLCombatant) {
            XMLCombatant xmlcbt = (XMLCombatant)this.cbt;
            if (this.getSaveType() == 1) {
                xmlcbt.setSave("Fortitude", total);
            } else if (this.getSaveType() == 2) {
                xmlcbt.setSave("Reflex", total);
            } else if (this.getSaveType() == 3) {
                xmlcbt.setSave("Will", total);
            }
        }
    }

    private void calculate() {
        int total = 0;
        total += this.getFieldValue(this.saveBase);
        total += this.getFieldValue(this.saveAbility);
        total += this.getFieldValue(this.saveMagic);
        total += this.getFieldValue(this.saveMisc);
        this.saveTotal.setText(Integer.toString(total += this.getFieldValue(this.saveTemp)));
        this.setXMLCache(total);
    }

    private void roll() {
        int total = this.getFieldValue(this.saveTotal);
        int dc = this.getFieldValue(this.saveDC);
        int roll = new Dice(1, 20).roll();
        if (total + roll >= dc) {
            this.retValue = 1;
            JOptionPane.showMessageDialog(this, this.getSaveAbbrev(this.getSaveType()) + " DC " + dc + " Passed.  Save: " + total + " + Roll: " + roll + " = " + (total + roll), "Save Passed", 1);
        } else {
            this.retValue = 2;
            JOptionPane.showMessageDialog(this, this.getSaveAbbrev(this.getSaveType()) + " DC " + dc + " Failed.  Save: " + total + " + Roll: " + roll + " = " + (total + roll), "Save Failed", 1);
        }
        this.updateModel();
        this.lastRoll = roll;
        this.setVisible(false);
        this.dispose();
    }

    private JFormattedTextField buildIntegerField(int min, int max) {
        JFormattedTextField returnValue = Utils.buildIntegerField(min, max);
        returnValue.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("value".equals(evt.getPropertyName())) {
                    SavingThrowDialog.this.calculate();
                }
            }
        });
        return returnValue;
    }

    private int parseInt(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void updateModel() {
        if (this.m_saveModel != null) {
            this.m_saveModel.setDc(this.getFieldValue(this.saveDC));
            if (this.fortitudeSelection.isSelected()) {
                this.m_saveModel.setSaveType("FORTITUDE");
            } else if (this.reflexSelection.isSelected()) {
                this.m_saveModel.setSaveType("REFLEX");
            } else if (this.willSelection.isSelected()) {
                this.m_saveModel.setSaveType("WILL");
            } else {
                this.m_saveModel.setSaveType("NONE");
            }
        }
    }

    public SaveModel getSaveModel() {
        return this.m_saveModel;
    }

    private void initComponents() {
        this.saveTypeGroup = new ButtonGroup();
        this.fortitudeSelection = new JRadioButton();
        this.reflexSelection = new JRadioButton();
        this.willSelection = new JRadioButton();
        this.rollButton = new JButton();
        this.passButton = new JButton();
        this.failButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.characterName = new JLabel();
        this.jLabel9 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.saveTempSlider = Utils.buildSlider(-5, 20);
        this.saveMagicSlider = Utils.buildSlider(-5, 20);
        this.saveDCSlider = Utils.buildSlider(0, 50);
        this.saveBase = this.buildIntegerField(-50, 50);
        this.saveAbility = this.buildIntegerField(-50, 50);
        this.saveMisc = this.buildIntegerField(-50, 50);
        this.saveTotal = this.buildIntegerField(-50, 50);
        this.saveMagic = Utils.buildIntegerFieldWithSlider(this.saveMagicSlider);
        this.saveTemp = Utils.buildIntegerFieldWithSlider(this.saveTempSlider);
        this.saveDC = Utils.buildIntegerFieldWithSlider(this.saveDCSlider);
        this.setTitle("Saving Throw");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SavingThrowDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(0));
        this.rollButton.setText("Roll");
        this.rollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavingThrowDialog.this.rollButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rollButton);
        this.passButton.setText("Pass");
        this.passButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavingThrowDialog.this.passButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.passButton);
        this.failButton.setText("Fail");
        this.failButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavingThrowDialog.this.failButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.failButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavingThrowDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Base Save");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveBase, gridBagConstraints);
        this.jLabel2.setText("Ability Modifier");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveAbility, gridBagConstraints);
        this.jLabel3.setText("Magic Modifier");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveMagic, gridBagConstraints);
        this.jLabel4.setText("Misc Modifier");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveMisc, gridBagConstraints);
        this.jLabel5.setText("Temp Modifier");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveTemp, gridBagConstraints);
        this.jLabel6.setText("Total");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.saveTotal.setBackground(new Color(204, 204, 204));
        this.saveTotal.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.saveTotal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.jPanel2.add((Component)this.saveTempSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.jPanel2.add((Component)this.saveMagicSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.saveDC, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 2);
        this.jPanel2.add((Component)this.saveDCSlider, gridBagConstraints);
        this.jLabel7.setText("Difficulty Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel9.setText("Save Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.jLabel9, gridBagConstraints);
        this.jPanel3.setLayout(new FlowLayout(0));
        this.fortitudeSelection.setText("Fortitude");
        this.saveTypeGroup.add(this.fortitudeSelection);
        this.fortitudeSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavingThrowDialog.this.saveSelectedActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.fortitudeSelection);
        this.reflexSelection.setText("Reflex");
        this.saveTypeGroup.add(this.reflexSelection);
        this.reflexSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavingThrowDialog.this.saveSelectedActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.reflexSelection);
        this.willSelection.setText("Will");
        this.saveTypeGroup.add(this.willSelection);
        this.willSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavingThrowDialog.this.saveSelectedActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.willSelection);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.characterName.setFont(new Font("Dialog", 1, 14));
        this.characterName.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.jPanel2.add((Component)this.characterName, gridBagConstraints);
        this.saveAbility.addKeyListener(new EnterKeyAdapter());
        this.saveBase.addKeyListener(new EnterKeyAdapter());
        this.saveDC.addKeyListener(new EnterKeyAdapter());
        this.saveMagic.addKeyListener(new EnterKeyAdapter());
        this.saveMisc.addKeyListener(new EnterKeyAdapter());
        this.saveTemp.addKeyListener(new EnterKeyAdapter());
        this.saveTotal.addKeyListener(new EnterKeyAdapter());
        this.getContentPane().add((Component)this.jPanel2, "West");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.retValue = 0;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void failButtonActionPerformed(ActionEvent evt) {
        this.updateModel();
        this.retValue = 2;
        this.setVisible(false);
        this.dispose();
    }

    private void passButtonActionPerformed(ActionEvent evt) {
        this.updateModel();
        this.retValue = 1;
        this.setVisible(false);
        this.dispose();
    }

    private void rollButtonActionPerformed(ActionEvent evt) {
        this.roll();
    }

    private void saveSelectedActionPerformed(ActionEvent evt) {
        this.setDefaults(this.getSaveType());
    }

    private class EnterKeyAdapter
    extends KeyAdapter {
        private EnterKeyAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                SavingThrowDialog.this.roll();
            }
        }
    }
}

