/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.MapToList;
import pcgen.base.util.TripleKeyMap;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SpellsLst
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "SPELLS";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String sourceLine) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        if (sourceLine == null || sourceLine.length() == 0) {
            return new ParseResult.Fail("Argument in " + this.getTokenName() + " cannot be empty", context);
        }
        if (sourceLine.equals(".CLEARALL")) {
            context.getListContext().removeAllFromList(this.getTokenName(), obj, Spell.SPELLS);
            return ParseResult.SUCCESS;
        }
        ParsingSeparator sep = new ParsingSeparator(sourceLine, '|');
        String spellBook = sep.next();
        if (spellBook.length() == 0) {
            return new ParseResult.Fail("SpellBook in " + this.getTokenName() + " cannot be empty", context);
        }
        String casterLevel = null;
        String times = null;
        String timeunit = null;
        if (!sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + ": minimally requires a Spell Name", context);
        }
        String token = sep.next();
        while (true) {
            if (token.startsWith("TIMES=")) {
                if (times != null) {
                    return new ParseResult.Fail("Found two TIMES entries in " + this.getTokenName() + ": invalid: " + sourceLine, context);
                }
                times = token.substring(6);
                if (times.length() == 0) {
                    return new ParseResult.Fail("Error in Times in " + this.getTokenName() + ": argument was empty", context);
                }
                if (!sep.hasNext()) {
                    return new ParseResult.Fail(this.getTokenName() + ": minimally requires " + "a Spell Name (after TIMES=)", context);
                }
                token = sep.next();
                continue;
            }
            if (token.startsWith("TIMEUNIT=")) {
                if (timeunit != null) {
                    return new ParseResult.Fail("Found two TIMEUNIT entries in " + this.getTokenName() + ": invalid: " + sourceLine, context);
                }
                timeunit = token.substring(9);
                if (timeunit.length() == 0) {
                    return new ParseResult.Fail("Error in TimeUnit in " + this.getTokenName() + ": argument was empty", context);
                }
                if (!sep.hasNext()) {
                    return new ParseResult.Fail(this.getTokenName() + ": minimally requires " + "a Spell Name (after TIMEUNIT=)", context);
                }
                token = sep.next();
                continue;
            }
            if (!token.startsWith("CASTERLEVEL=")) break;
            if (casterLevel != null) {
                return new ParseResult.Fail("Found two CASTERLEVEL entries in " + this.getTokenName() + ": invalid: " + sourceLine, context);
            }
            casterLevel = token.substring(12);
            if (casterLevel.length() == 0) {
                return new ParseResult.Fail("Error in Caster Level in " + this.getTokenName() + ": argument was empty", context);
            }
            if (!sep.hasNext()) {
                return new ParseResult.Fail(this.getTokenName() + ": minimally requires a " + "Spell Name (after CASTERLEVEL=)", context);
            }
            token = sep.next();
        }
        if (times == null) {
            times = "1";
        }
        if (token.length() == 0) {
            return new ParseResult.Fail("Spell arguments may not be empty in " + this.getTokenName() + ": " + sourceLine, context);
        }
        if (token.charAt(0) == ',') {
            return new ParseResult.Fail(this.getTokenName() + " Spell arguments may not start with , : " + token, context);
        }
        if (token.charAt(token.length() - 1) == ',') {
            return new ParseResult.Fail(this.getTokenName() + " Spell arguments may not end with , : " + token, context);
        }
        if (token.indexOf(",,") != -1) {
            return new ParseResult.Fail(this.getTokenName() + " Spell arguments uses double separator ,, : " + token, context);
        }
        DoubleKeyMap dkm = new DoubleKeyMap(LinkedHashMap.class, HashMap.class);
        do {
            if (token.length() == 0) {
                return new ParseResult.Fail("Spell arguments may not end with comma or pipe in " + this.getTokenName() + ": " + sourceLine, context);
            }
            int commaLoc = token.indexOf(44);
            String name = commaLoc == -1 ? token : token.substring(0, commaLoc);
            CDOMSingleRef spell = context.getReferenceContext().getCDOMReference(Spell.class, name);
            dkm.put((Object)spell, (Object)AssociationKey.CASTER_LEVEL, (Object)casterLevel);
            Formula timesFormula = FormulaFactory.getFormulaFor((String)times);
            if (!timesFormula.isValid()) {
                return new ParseResult.Fail("Times in " + this.getTokenName() + " was not valid: " + timesFormula.toString(), context);
            }
            dkm.put((Object)spell, (Object)AssociationKey.TIMES_PER_UNIT, (Object)timesFormula);
            if (timeunit != null) {
                dkm.put((Object)spell, (Object)AssociationKey.TIME_UNIT, (Object)timeunit);
            }
            dkm.put((Object)spell, (Object)AssociationKey.SPELLBOOK, (Object)spellBook);
            if (commaLoc != -1) {
                dkm.put((Object)spell, (Object)AssociationKey.DC_FORMULA, (Object)token.substring(commaLoc + 1));
            }
            if (sep.hasNext()) continue;
            this.finish(context, obj, dkm, null);
            return ParseResult.SUCCESS;
        } while (!this.looksLikeAPrerequisite(token = sep.next()));
        ArrayList<Prerequisite> prereqs = new ArrayList<Prerequisite>();
        while (true) {
            Prerequisite prereq;
            if ((prereq = this.getPrerequisite(token)) == null) {
                return new ParseResult.Fail("   (Did you put spells after the PRExxx tags in SPELLS:?)", context);
            }
            prereqs.add(prereq);
            if (!sep.hasNext()) break;
            token = sep.next();
        }
        this.finish(context, obj, dkm, prereqs);
        return ParseResult.SUCCESS;
    }

    public void finish(LoadContext context, CDOMObject obj, DoubleKeyMap<CDOMReference<Spell>, AssociationKey<?>, Object> dkm, List<Prerequisite> prereqs) {
        for (CDOMReference spell : dkm.getKeySet()) {
            AssociatedPrereqObject edge = context.getListContext().addToList(this.getTokenName(), obj, Spell.SPELLS, spell);
            for (AssociationKey ak : dkm.getSecondaryKeySet((Object)spell)) {
                edge.setAssociation(ak, dkm.get((Object)spell, (Object)ak));
            }
            if (prereqs == null) continue;
            for (Prerequisite prereq : prereqs) {
                edge.addPrerequisite(prereq);
            }
        }
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        MapToList mtl;
        AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), obj, Spell.SPELLS);
        ArrayList<? extends String> list = new ArrayList<String>();
        if (changes.includesGlobalClear()) {
            list.add(".CLEARALL");
        }
        if ((mtl = changes.getAddedAssociations()) != null && !mtl.isEmpty()) {
            list.addAll(this.processAdds(context, (MapToList<CDOMReference<Spell>, AssociatedPrereqObject>)mtl));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private Collection<? extends String> processAdds(LoadContext context, MapToList<CDOMReference<Spell>, AssociatedPrereqObject> mtl) {
        TripleKeyMap m = new TripleKeyMap();
        for (CDOMReference lw : mtl.getKeySet()) {
            for (AssociatedPrereqObject assoc : mtl.getListFor((Object)lw)) {
                Map<AssociationKey, Object> am = new HashMap();
                String dc = null;
                for (AssociationKey ak : assoc.getAssociationKeys()) {
                    if (AssociationKey.DC_FORMULA.equals(ak)) {
                        dc = (String)assoc.getAssociation(AssociationKey.DC_FORMULA);
                        continue;
                    }
                    am.put(ak, assoc.getAssociation(ak));
                }
                m.put(new HashSet(assoc.getPrerequisiteList()), am, (Object)lw, dc);
            }
        }
        TreeSet<String> set = new TreeSet<String>();
        for (Set prereqs : m.getKeySet()) {
            for (Map<AssociationKey, Object> am : m.getSecondaryKeySet((Object)prereqs)) {
                String casterLvl;
                StringBuilder sb = new StringBuilder();
                sb.append(am.get(AssociationKey.SPELLBOOK));
                Formula times = (Formula)AssociationKey.TIMES_PER_UNIT.cast(am.get(AssociationKey.TIMES_PER_UNIT));
                sb.append("|").append("TIMES=").append(times);
                String timeunit = (String)AssociationKey.TIME_UNIT.cast(am.get(AssociationKey.TIME_UNIT));
                if (timeunit != null) {
                    sb.append("|").append("TIMEUNIT=").append(timeunit);
                }
                if ((casterLvl = (String)AssociationKey.CASTER_LEVEL.cast(am.get(AssociationKey.CASTER_LEVEL))) != null) {
                    sb.append("|").append("CASTERLEVEL=").append(casterLvl);
                }
                TreeSet<String> spellSet = new TreeSet<String>();
                for (CDOMReference spell : m.getTertiaryKeySet((Object)prereqs, am)) {
                    String spellString = spell.getLSTformat(false);
                    String dc = (String)m.get((Object)prereqs, am, (Object)spell);
                    if (dc != null) {
                        spellString = spellString + "," + dc;
                    }
                    spellSet.add(spellString);
                }
                sb.append("|");
                sb.append(StringUtil.join(spellSet, (String)"|"));
                if (prereqs != null && !prereqs.isEmpty()) {
                    sb.append("|");
                    sb.append(this.getPrerequisiteString(context, prereqs));
                }
                set.add(sb.toString());
            }
        }
        return set;
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

