#!/bin/sh
#***************************************************************************************************
#                                           charcnt.sh                                             *
#                                          ------------                                            *
# Description : This bash shell script measures the size of the source files which make up the     *
#               gSpiceUI project.                                                                  *
# Started     : 2003-11-25                                                                         *
# Updated     : 2021-11-27                                                                         *
# Author      : Mike Waters                                                                        *
#***************************************************************************************************
#                                                                                                  *
#       This program is free software; you can redistribute it and/or modify it under the          *
#       terms of the GNU General Public License as published by the Free Software Foundation;      *
#       either version 3 of the License, or (at your option) any later version.                    *
#                                                                                                  *
#***************************************************************************************************

set `date`

echo
echo "Total amount of sources for the GNU SPICE GUI Project :"
echo
echo "  As at $4 $3 $2 $6"
echo

ls -l ./src/Makefile ./src/*.?pp ./src/*/*.?pp ./src/*/*/*.?pp ./src/icons/*.xpm |
gawk 'BEGIN { chrcnt = 0; filecnt = 0 }
      { chrcnt += $5; filecnt++ }
      END { printf "  C/C++  : %6.1f KByte (%7s Bytes) in %3s files\n", chrcnt/1024, chrcnt, filecnt } '

ls -l ./doc/Makefile ./doc/tex/*.tex |
gawk 'BEGIN { chrcnt = 0; filecnt = 0 }
      { chrcnt += $5; filecnt++ }
      END { printf "  TEX    : %6.1f KByte (%7s Bytes) in %3s files\n", chrcnt/1024, chrcnt, filecnt } '

ls -l ./doc/svg/*.svg |
gawk 'BEGIN { chrcnt = 0; filecnt = 0 }
      { chrcnt += $5; filecnt++ }
      END { printf "  Diags  : %6.1f KByte (%7s Bytes) in %3s files\n", chrcnt/1024, chrcnt, filecnt } '

ls -Rl ./sch/Makefile ./sch/*/*.sch |
gawk 'BEGIN { chrcnt = 0; filecnt = 0 }
      { chrcnt += $5; filecnt++ }
      END { printf "  Schems : %6.1f KByte (%7s Bytes) in %3s files\n", chrcnt/1024, chrcnt, filecnt } '

ls -lR ./lib/Makefile ./lib/models/*.mod ./lib/symbols/*.sym |
gawk 'BEGIN { chrcnt = 0; filecnt = 0 }
      { chrcnt += $5; filecnt++ }
      END { printf "  Models : %6.1f KByte (%7s Bytes) in %3s files\n", chrcnt/1024, chrcnt, filecnt } '

ls -lR ./Authors ./ChangeLog ./Install ./Makefile ./ReadMe ./ToDo ./charcnt.sh ./gspiceui.1 ./gspiceui.lsm ./release-notes-v?.?.??.txt |
gawk 'BEGIN { chrcnt = 0; filecnt = 0 }
      { chrcnt += $5; filecnt++ }
      END { printf "  Other  : %6.1f KByte (%7s Bytes) in %3s files\n", chrcnt/1024, chrcnt, filecnt } '

echo

#***************************************************************************************************
