//**************************************************************************************************
//                                          SysScan.hpp                                            *
//                                         -------------                                           *
// Description : This class is intended to look for and provide information about the system :     *
//                 - the host application installation directory                                   *
//                 - other applications installed on the system                                    *
// Started     : 2020-09-27                                                                        *
// Last Update : 2021-09-30                                                                        *
// Copyright   : (C) 2020-2021 MSWaters                                                            *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef SYSSCAN_HPP
#define SYSSCAN_HPP

// Application Includes

#include "TypeDefs.hpp"

//**************************************************************************************************

class SysScan
{
  private :

    static  wxString  m_osPathInstall;  // The host application installation  directory
    static  wxString  m_osPathDoc;      // The host application documentation directory

            // The list of wxFileName objects. If a binary file is has already been searched for,
            // it's name will be in this list. If the binary is installed on the host system the
            // it's wxFileName object will have a path. If the binary file is found but has no path
            // it isn't installed on the system.
    static  ArrayFileName  m_oaBinFiles;

            void  InitPathVars  ( void );
            int   iSearchBinList( const wxString & rosFileBin );

  public :

            SysScan( void );
           ~SysScan( );

            // Functions related to host application paths
    const   wxString & rosGetPathInstall( void ) { return( m_osPathInstall ); }
    const   wxString & rosGetPathDoc    ( void ) { return( m_osPathDoc     ); }

            //  Functions related to installed applications
    static  bool  bFindBinFile(       wxFileName & rofnFileBin );
            bool  bAddBinFile ( const wxString   & rosFileBin  );
            bool  bIsInstalled( const wxString   & rosFileBin  );
            bool  bGetBinFile (       wxFileName & rofnFileBin );

            // The following function is intended for debugging
            void  Print( const wxString & rosPrefix="  " );
};

//**************************************************************************************************

#endif // SYSSCAN_HPP
