/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.invoke;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.onemind.commons.invoke.Invocable;
import org.onemind.commons.invoke.InvocableFunction;
import org.onemind.commons.java.lang.reflect.ReflectUtils;

public abstract class AbstractInvocable
implements Invocable {
    private Map _functions = new HashMap();

    public void addFunction(InvocableFunction function) {
        String key = ReflectUtils.toMethodString(function.getName(), function.getArgTypes());
        this._functions.put(key, function);
    }

    public InvocableFunction getFunction(String functionName, Object[] args) {
        return this.getFunction(functionName, ReflectUtils.toArgTypes(args));
    }

    public InvocableFunction getFunction(String functionName, Class[] argTypes) {
        String key = ReflectUtils.toMethodString(functionName, argTypes);
        InvocableFunction func = (InvocableFunction)this._functions.get(key);
        if (func != null) {
            return func;
        }
        Iterator it = this._functions.values().iterator();
        while (it.hasNext()) {
            func = (InvocableFunction)it.next();
            if (!functionName.equals(func.getName()) || !func.canInvokeOn(argTypes)) continue;
            return func;
        }
        return null;
    }

    public boolean canInvoke(String functionName, Object[] args) {
        InvocableFunction f = this.getFunction(functionName, args);
        return f != null;
    }

    public Object invoke(String functionName, Object[] args) throws Exception {
        InvocableFunction function = this.getFunction(functionName, args);
        if (function != null) {
            return function.invoke(this, args);
        }
        throw new NoSuchMethodException("Method " + ReflectUtils.toMethodString(functionName, args) + " not found for " + this);
    }

    public Collection getFunctions() {
        return Collections.unmodifiableCollection(this._functions.values());
    }
}

