/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.java.plugin.ObjectFactory;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.util.IoUtil;

public class PluginInfoTask
extends Task {
    private File manifest;
    private String propertyPluginId;
    private String propertyVersion;

    public void setManifest(File file) {
        this.manifest = file;
    }

    public void setPropertyPluginId(String string) {
        this.propertyPluginId = string;
    }

    public void setPropertyVersion(String string) {
        this.propertyVersion = string;
    }

    public void execute() throws BuildException {
        Version version;
        String string;
        Map map;
        URL uRL;
        if (this.manifest == null) {
            throw new BuildException("manifest attribute must be set!", this.getLocation());
        }
        try {
            uRL = IoUtil.file2url(this.manifest);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException("failed converting file " + this.manifest + " to URL", (Throwable)malformedURLException, this.getLocation());
        }
        this.log("Registering manifest " + this.manifest + " ...");
        PluginRegistry pluginRegistry = ObjectFactory.newInstance().createRegistry();
        try {
            map = pluginRegistry.register(new URL[]{uRL});
        }
        catch (ManifestProcessingException manifestProcessingException) {
            throw new BuildException("failed registering manifest " + uRL, (Throwable)manifestProcessingException, this.getLocation());
        }
        if (map.size() == 0) {
            throw new BuildException("no plug-ins registered", this.getLocation());
        }
        if (map.size() > 1) {
            throw new BuildException("too many plug-ins registered", this.getLocation());
        }
        this.log("... manifest " + this.manifest + " registered");
        Object v = map.values().iterator().next();
        if (v instanceof PluginDescriptor) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)v;
            string = pluginDescriptor.getId();
            version = pluginDescriptor.getVersion();
        } else if (v instanceof PluginFragment) {
            PluginFragment pluginFragment = (PluginFragment)v;
            string = pluginFragment.getId();
            version = pluginFragment.getVersion();
        } else {
            throw new BuildException("unexpected object type " + v.getClass().getName(), this.getLocation());
        }
        if (this.propertyPluginId != null) {
            this.getProject().setProperty(this.propertyPluginId, string);
        }
        if (this.propertyVersion != null) {
            this.getProject().setProperty(this.propertyVersion, version != null ? version.toString() : "");
        }
    }
}

